/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.collections.EnumerationList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderResourceLoader
implements ResourceLoader {
    private ClassLoader classLoader;

    public ClassLoaderResourceLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Class<?> classForName(String name) {
        try {
            return this.classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceLoadingException("Error loading class " + name, (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            throw new ResourceLoadingException("Error loading class " + name, (Throwable)e);
        }
        catch (TypeNotPresentException e) {
            throw new ResourceLoadingException("Error loading class " + name, (Throwable)e);
        }
    }

    public URL getResource(String name) {
        return this.classLoader.getResource(name);
    }

    public Collection<URL> getResources(String name) {
        try {
            return new EnumerationList<URL>(this.classLoader.getResources(name));
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Error loading resource " + name, (Throwable)e);
        }
    }

    public void cleanup() {
        this.classLoader = null;
    }
}

