/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.core.context;

import java.util.concurrent.ExecutorService;
import javax.ejb.ApplicationException;
import javax.ejb.TransactionAttributeType;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.aop.AbstractInterceptor;
import org.jboss.ejb3.async.spi.AsyncCancellableContext;
import org.jboss.ejb3.async.spi.AsyncInvocationContext;
import org.jboss.ejb3.async.spi.AsyncInvocationId;
import org.jboss.ejb3.context.base.BaseSessionInvocationContext;
import org.jboss.ejb3.core.context.TxUtil;
import org.jboss.ejb3.tx2.spi.TransactionalInvocationContext;

public class SessionInvocationContextAdapter
extends BaseSessionInvocationContext
implements TransactionalInvocationContext,
AsyncInvocationContext,
AsyncCancellableContext {
    private MethodInvocation delegate;
    private final ExecutorService asyncExecutor;
    private final AsyncCancellableContext container;

    public SessionInvocationContextAdapter(Class<?> invokedBusinessInterface, MethodInvocation delegate, ExecutorService asyncExecutor, AsyncCancellableContext container) {
        super(invokedBusinessInterface, delegate.getMethod(), delegate.getArguments());
        this.delegate = delegate;
        this.asyncExecutor = asyncExecutor;
        this.container = container;
    }

    public ApplicationException getApplicationException(Class<?> e) {
        return ((EJBContainer)AbstractInterceptor.getEJBContainer((Invocation)this.delegate)).getApplicationException(e, this.delegate.getMethod());
    }

    public TransactionAttributeType getTransactionAttribute() {
        return TxUtil.getTxType(this.delegate);
    }

    public int getTransactionTimeout() {
        return TxUtil.getTransactionTimeout(this.delegate);
    }

    public Object proceed() throws Exception {
        try {
            return this.delegate.invokeNext();
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void setParameters(Object[] params) throws IllegalArgumentException, IllegalStateException {
        super.setParameters(params);
        this.delegate.setArguments(params);
    }

    public ExecutorService getAsynchronousExecutor() {
        return this.asyncExecutor;
    }

    public boolean cancel(AsyncInvocationId id) throws IllegalArgumentException {
        return this.container.cancel(id);
    }
}

