/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.cache.ClusteredStatefulCache;
import org.jboss.ejb3.cache.Optimized;
import org.jboss.ejb3.cache.StatefulCache;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulContainerInvocation;

public class StatefulReplicationInterceptor
implements Interceptor {
    private static final ThreadLocal<Map<StatefulBeanContext, Stack<Boolean>>> replicationContext = new ThreadLocal();

    public String getName() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        StatefulContainerInvocation ejbInv = (StatefulContainerInvocation)invocation;
        StatefulBeanContext ctx = (StatefulBeanContext)ejbInv.getBeanContext();
        StatefulBeanContext root = ctx.getUltimateContainedIn();
        boolean clustered = false;
        StatefulContainer container = root.getContainer();
        ClusteredStatefulCache clusteredCache = null;
        if (container.getCache() instanceof ClusteredStatefulCache) {
            clustered = true;
            clusteredCache = (ClusteredStatefulCache)container.getCache();
        }
        if (clustered) {
            StatefulReplicationInterceptor.pushCallStack(root);
        }
        boolean stackUnwound = false;
        Object rtn = null;
        try {
            rtn = invocation.invokeNext();
        }
        catch (Throwable throwable) {
            stackUnwound = clustered && StatefulReplicationInterceptor.isCallStackUnwound(root);
            throw throwable;
        }
        stackUnwound = clustered && StatefulReplicationInterceptor.isCallStackUnwound(root);
        boolean mustReplicate = clustered;
        Object obj = invocation.getTargetObject();
        if (obj instanceof Optimized && !((Optimized)obj).isModified()) {
            mustReplicate = false;
        }
        if (mustReplicate) {
            root.markedForReplication = true;
        }
        if (stackUnwound && root.markedForReplication) {
            clusteredCache.replicate(root);
        }
        if (ctx != root && ctx.markedForReplication) {
            container = ctx.getContainer();
            StatefulCache cache = container.getCache();
            if (cache instanceof ClusteredStatefulCache) {
                clusteredCache = (ClusteredStatefulCache)cache;
                clusteredCache.replicate(ctx);
            } else {
                ctx.markedForReplication = false;
            }
        }
        return rtn;
    }

    private static void pushCallStack(StatefulBeanContext ctx) {
        Stack<Boolean> callStack = null;
        Map<StatefulBeanContext, Stack<Boolean>> map = replicationContext.get();
        if (map == null) {
            map = new HashMap<StatefulBeanContext, Stack<Boolean>>();
            replicationContext.set(map);
        } else {
            callStack = map.get(ctx);
        }
        if (callStack == null) {
            callStack = new Stack();
            map.put(ctx, callStack);
        }
        callStack.push(Boolean.TRUE);
    }

    private static boolean isCallStackUnwound(StatefulBeanContext ctx) {
        boolean unwound;
        Map<StatefulBeanContext, Stack<Boolean>> map = replicationContext.get();
        if (map == null) {
            throw new IllegalStateException("replicationContext contains no Map");
        }
        Stack<Boolean> callStack = map.get(ctx);
        if (callStack == null) {
            throw new IllegalStateException("replicationContext contains no call stack");
        }
        callStack.pop();
        boolean bl = unwound = callStack.size() == 0;
        if (unwound) {
            map.remove(ctx);
            if (map.size() == 0) {
                replicationContext.set(null);
            }
        }
        return unwound;
    }
}

