/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit.compiler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.faces.FacesException;
import org.ajax4jsf.renderkit.compiler.Signature;
import org.ajax4jsf.renderkit.compiler.Signature0;
import org.ajax4jsf.renderkit.compiler.Signature1;
import org.ajax4jsf.renderkit.compiler.Signature2;
import org.ajax4jsf.renderkit.compiler.TemplateContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Invoker {
    protected volatile Signature current;
    protected String methodName;

    public Invoker(String name) {
        this.methodName = name;
    }

    public Object invokeMethod(TemplateContext context, Object[] parameters) {
        Object result = null;
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            if (null == parameter) continue;
            parameterTypes[i] = parameter.getClass();
        }
        Signature signature = this.current;
        if (null == signature || !signature.isApplicable(context, this.getInvokedClass(context), parameterTypes)) {
            this.current = signature = this.provideMethod(context, parameterTypes);
        }
        try {
            result = signature.invoke(context, this.getInvokedObject(context), parameters);
        }
        catch (IllegalArgumentException e) {
            throw new FacesException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.handleIllegalAccessException(context, e);
        }
        catch (InvocationTargetException e) {
            this.handleInvocationTargetException(context, e);
        }
        return result;
    }

    abstract void handleInvocationTargetException(TemplateContext var1, InvocationTargetException var2);

    abstract void handleIllegalAccessException(TemplateContext var1, IllegalAccessException var2);

    abstract void handleMethodNotFoundException(TemplateContext var1);

    public abstract Class<?> getInvokedClass(TemplateContext var1);

    public abstract Object getInvokedObject(TemplateContext var1);

    protected Signature provideMethod(TemplateContext context, Class<?>[] parameterTypes) {
        Class<?> cls = this.getInvokedClass(context);
        if (null != cls) {
            Object object = this.getInvokedObject(context);
            Method[] methods = cls.getMethods();
            for (int m = 0; m < methods.length; ++m) {
                if (!methods[m].getName().equals(this.methodName) || object == null && !Modifier.isStatic(methods[m].getModifiers())) continue;
                Signature s = new Signature0(methods[m]);
                if (s.isApplicable(context, cls, parameterTypes)) {
                    return s;
                }
                s = new Signature1(methods[m]);
                if (s.isApplicable(context, cls, parameterTypes)) {
                    return s;
                }
                s = new Signature2(methods[m]);
                if (!s.isApplicable(context, cls, parameterTypes)) continue;
                return s;
            }
        }
        this.handleMethodNotFoundException(context);
        return null;
    }

    static boolean isMatching(Class<?>[] cs, Class<?>[] args) {
        if (cs.length != args.length) {
            return false;
        }
        for (int i = 0; i < cs.length; ++i) {
            if (args[i] == null || cs[i].isAssignableFrom(args[i])) continue;
            return false;
        }
        return true;
    }
}

