/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.spi.deployer.helpers;

import org.jboss.dependency.spi.ControllerContext;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentRegistry;
import org.jboss.deployers.structure.spi.DeploymentUnit;

public abstract class AbstractRealDeployer
extends AbstractDeployer {
    private boolean useUnitName;
    private DeploymentRegistry registry;

    public AbstractRealDeployer() {
        this.setStage(DeploymentStages.REAL);
    }

    public final void deploy(DeploymentUnit unit) throws DeploymentException {
        this.internalDeploy(unit);
        if (this.isControllerContextNameCandidate(unit)) {
            this.addControllerContextName(unit);
        }
    }

    protected boolean isControllerContextNameCandidate(DeploymentUnit unit) {
        return this.useUnitName && unit.isComponent();
    }

    protected abstract void internalDeploy(DeploymentUnit var1) throws DeploymentException;

    protected void addControllerContextName(DeploymentUnit unit) {
        unit.addControllerContextName((Object)unit.getName());
    }

    protected void removeControllerContextName(DeploymentUnit unit) {
        unit.removeControllerContextName((Object)unit.getName());
    }

    public final void undeploy(DeploymentUnit unit) {
        block3: {
            try {
                if (this.isControllerContextNameCandidate(unit)) {
                    this.removeControllerContextName(unit);
                }
            }
            catch (Throwable t) {
                if (!this.log.isTraceEnabled()) break block3;
                this.log.trace((Object)("Exception while removing unit name: " + t));
            }
        }
        this.internalUndeploy(unit);
    }

    protected void internalUndeploy(DeploymentUnit unit) {
    }

    protected DeploymentUnit putContext(ControllerContext context, DeploymentUnit unit) {
        return this.registry != null ? this.registry.putContext(context, unit) : null;
    }

    protected DeploymentUnit removeContext(ControllerContext context, DeploymentUnit unit) {
        return this.registry != null ? this.registry.removeContext(context, unit) : null;
    }

    public boolean isUseUnitName() {
        return this.useUnitName;
    }

    public void setUseUnitName(boolean useUnitName) {
        this.useUnitName = useUnitName;
    }

    public void setDeploymentRegistry(DeploymentRegistry registry) {
        this.registry = registry;
    }
}

