/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded.impl.base.scanner;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.ejb.MessageDriven;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import org.jboss.ejb3.embedded.impl.base.scanner.SecurityActions;
import org.jboss.ejb3.embedded.impl.base.scanner.filter.BundleSymbolicNameExclusionFilter;
import org.jboss.ejb3.embedded.spi.scanner.filter.ExclusionFilter;
import org.jboss.logging.Logger;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class ClassPathEjbJarScanner {
    private static final Logger log = Logger.getLogger(ClassPathEjbJarScanner.class);
    private static final String SYS_PROP_KEY_CLASS_PATH = "java.class.path";
    private static final String[] DUMMY = new String[0];
    private static final String PATH_EJB_JAR_XML = "META-INF/ejb-jar.xml";
    private static final String EXTENSION_CLASS = ".class";
    private static final String EXTENSION_JAR = ".jar";
    private static final Class<? extends Annotation>[] EJB_COMPONENT_ANNOTATIONS = new Class[]{Stateless.class, Stateful.class, Singleton.class, MessageDriven.class};
    @Deprecated
    private static final ScheduledExecutorService ses = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    private static final List<ExclusionFilter> exclusionFilters = new ArrayList<ExclusionFilter>();

    private ClassPathEjbJarScanner() {
        throw new UnsupportedOperationException("No instances permitted");
    }

    public static String[] getEjbJars() {
        String[] classPathEntries;
        ArrayList<String> returnValue = new ArrayList<String>();
        String classPath = SecurityActions.getSystemProperty(SYS_PROP_KEY_CLASS_PATH);
        if (log.isTraceEnabled()) {
            log.tracef("Class Path: %s", new Object[]{classPath});
        }
        for (String classPathEntry : classPathEntries = classPath.split(File.pathSeparator)) {
            if (!ClassPathEjbJarScanner.isEjbJar(classPathEntry)) continue;
            returnValue.add(classPathEntry);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("EJB Modules discovered on ClassPath: " + returnValue));
        }
        return returnValue.toArray(DUMMY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isEjbJar(String candidate) {
        VirtualFile file = VFS.getChild((String)candidate);
        Closeable handle = null;
        TempFileProvider provider = null;
        try {
            if (!file.exists()) {
                log.warn((Object)("File on ClassPath could not be found: " + file));
                boolean bl = false;
                return bl;
            }
            if (file.isDirectory()) {
                handle = VFS.mountReal((File)file.getPhysicalFile(), (VirtualFile)file);
            } else {
                if (!file.getName().endsWith(EXTENSION_JAR)) {
                    log.warn((Object)("Encountered unknown file type, skipping: " + file));
                    boolean bl = false;
                    return bl;
                }
                if (provider == null) {
                    provider = TempFileProvider.create((String)"jbossejbmodulescanner", (ScheduledExecutorService)ses);
                }
                handle = VFS.mountZip((File)file.getPhysicalFile(), (VirtualFile)file, (TempFileProvider)provider);
            }
            for (ExclusionFilter exclusionFilter : exclusionFilters) {
                if (!exclusionFilter.exclude(file)) continue;
                if (log.isTraceEnabled()) {
                    log.tracef("%s matched %s for exclusion; skipping", new Object[]{exclusionFilter, file});
                }
                boolean bl = false;
                return bl;
            }
            VirtualFile ejbJarXml = file.getChild(PATH_EJB_JAR_XML);
            if (ejbJarXml.exists()) {
                if (log.isTraceEnabled()) {
                    log.tracef("Found descriptor %s in %s", new Object[]{ejbJarXml.getPathNameRelativeTo(file), file});
                }
                boolean bl = true;
                return bl;
            }
            if (ClassPathEjbJarScanner.containsEjbComponentClass(file)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not mount file from ClassPath for EJB JAR module scanning", e);
        }
        finally {
            try {
                handle.close();
            }
            catch (IOException e) {
                log.warn((Object)("Could not close handle to mounted " + file), (Throwable)e);
            }
        }
    }

    @Deprecated
    private static boolean containsEjbComponentClass(VirtualFile file) {
        return ClassPathEjbJarScanner.containsEjbComponentClass(file, file);
    }

    @Deprecated
    private static boolean containsEjbComponentClass(VirtualFile root, VirtualFile file) {
        assert (file != null) : "File must be specified";
        for (VirtualFile child : file.getChildren()) {
            boolean foundInChild;
            if (child.isDirectory() && (foundInChild = ClassPathEjbJarScanner.containsEjbComponentClass(root, child))) {
                return true;
            }
            String childName = child.getPathNameRelativeTo(root);
            if (!childName.endsWith(EXTENSION_CLASS)) continue;
            String className = childName.substring(0, childName.length() - EXTENSION_CLASS.length()).replace('/', '.');
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className, false, SecurityActions.getTccl());
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Found .class on ClassPath which could not be found by the TCCL", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                log.warnf("Dev Hack Alert: Ignoring class on ClassPath which can't be loaded due to %s while loading %s; configure an exclusion filter so %s is not processed", new Object[]{ncdfe.toString(), className, root});
            }
            catch (SecurityException e) {
                log.warnf("Can't load class %s (%s).", new Object[]{className, e.toString()});
            }
            if (clazz == null) continue;
            for (Class<? extends Annotation> annotationClass : EJB_COMPONENT_ANNOTATIONS) {
                if (!clazz.isAnnotationPresent(annotationClass)) continue;
                if (log.isTraceEnabled()) {
                    log.tracef("Found %s on %s in %s", new Object[]{annotationClass, clazz, root});
                }
                return true;
            }
        }
        return false;
    }

    static {
        exclusionFilters.add(new BundleSymbolicNameExclusionFilter("org.eclipse", "org.junit"));
    }
}

