/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import java.util.Collection;
import java.util.LinkedHashMap;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.wsdl.Extendable;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLRPCPart;
import org.jboss.ws.metadata.wsdl.WSDLTypes;

public abstract class WSDLInterfaceMessageReference
extends Extendable
implements Comparable {
    protected Logger log = Logger.getLogger(this.getClass());
    private WSDLInterfaceOperation wsdlOperation;
    private String messageLabel;
    private QName element;
    private LinkedHashMap<String, WSDLRPCPart> childParts = new LinkedHashMap();
    private String partName;
    private QName messageName;
    private String action;

    public WSDLInterfaceMessageReference(WSDLInterfaceOperation wsdlOperation) {
        this.log.trace((Object)("New part for wsdlOperation: " + wsdlOperation.getName()));
        this.wsdlOperation = wsdlOperation;
    }

    public WSDLInterfaceOperation getWsdlOperation() {
        return this.wsdlOperation;
    }

    public String getMessageLabel() {
        return this.messageLabel;
    }

    public void setMessageLabel(String messageLabel) {
        this.messageLabel = messageLabel;
    }

    public QName getElement() {
        return this.element;
    }

    public void setElement(QName element) {
        this.log.trace((Object)("setElement: " + element));
        this.element = element;
    }

    public QName getXMLType() {
        WSDLProperty property;
        QName xmlType = null;
        WSDLDefinitions wsdlDefinitions = this.wsdlOperation.getWsdlInterface().getWsdlDefinitions();
        WSDLTypes wsdlTypes = wsdlDefinitions.getWsdlTypes();
        xmlType = wsdlTypes.getXMLType(this.element);
        if (xmlType == null && (property = this.getProperty("http://www.jboss.org/jbossws/part/xmltype")) != null) {
            String qnameRef = property.getValue();
            int colIndex = qnameRef.indexOf(58);
            String prefix = qnameRef.substring(0, colIndex);
            String localPart = qnameRef.substring(colIndex + 1);
            String nsURI = wsdlDefinitions.getNamespaceURI(prefix);
            xmlType = new QName(nsURI, localPart, prefix);
        }
        if (xmlType == null) {
            throw new WSException("Cannot obtain xmlType for element: " + this.element);
        }
        return xmlType;
    }

    public Collection<WSDLRPCPart> getChildParts() {
        return this.childParts.values();
    }

    public WSDLRPCPart getChildPart(String name) {
        return this.childParts.get(name);
    }

    public void addChildPart(WSDLRPCPart childPart) {
        this.childParts.put(childPart.getName(), childPart);
    }

    public void removeChildPart(String name) {
        this.childParts.remove(name);
    }

    public String getPartName() {
        return this.partName;
    }

    public void setMessageName(QName messageName) {
        this.messageName = messageName;
    }

    public QName getMessageName() {
        return this.messageName;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public void setPartName(String partName) {
        this.partName = partName;
    }

    public int compareTo(Object o) {
        int c = -1;
        if (o instanceof WSDLInterfaceMessageReference) {
            WSDLInterfaceMessageReference w = (WSDLInterfaceMessageReference)o;
            String oname = w.getElement().getLocalPart();
            String myname = this.getElement().getLocalPart();
            c = myname.compareTo(oname);
        }
        return c;
    }
}

