/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.element;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.xml.security.encryption.Reference;
import org.jboss.ws.extensions.security.Util;
import org.w3c.dom.Element;

public class ReferenceList {
    private LinkedList<String> references = new LinkedList();

    public ReferenceList() {
    }

    public ReferenceList(Element element) {
        Element child = Util.getFirstChildElement(element);
        while (child != null) {
            String uri;
            if ("http://www.w3.org/2001/04/xmlenc#".equals(child.getNamespaceURI()) && "DataReference".equals(child.getLocalName()) && (uri = child.getAttribute("URI")) != null && uri.length() > 1 && uri.charAt(0) == '#') {
                this.references.add(uri.substring(1));
            }
            child = Util.getNextSiblingElement(child);
        }
    }

    public ReferenceList(org.apache.xml.security.encryption.ReferenceList list) {
        Iterator i = list.getReferences();
        while (i.hasNext()) {
            Reference r = (Reference)i.next();
            this.references.add(r.getURI());
        }
    }

    public void add(String id) {
        this.references.addFirst(id);
    }

    public void populateRealReferenceList(org.apache.xml.security.encryption.ReferenceList list) {
        for (String i : this.references) {
            list.add(list.newDataReference("#" + i));
        }
    }

    public Collection<String> getAllReferences() {
        return this.references;
    }
}

