/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jopr;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.infinispan.jopr.CacheDiscovery;
import org.infinispan.jopr.CacheManagerComponent;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jmx.MBeanResourceComponent;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

public class CacheComponent
extends MBeanResourceComponent<CacheManagerComponent> {
    private static final Log log = LogFactory.getLog(CacheComponent.class);
    private ResourceContext<CacheManagerComponent> context;
    private String cacheManagerName;
    private String cacheName;

    public AvailabilityType getAvailability() {
        boolean trace = log.isTraceEnabled();
        EmsConnection conn = this.getConnection();
        try {
            conn.refresh();
            EmsBean bean = this.queryCacheBean();
            if (bean != null && bean.getAttribute("CacheStatus").getValue().equals(ComponentStatus.RUNNING.toString())) {
                bean.refreshAttributes();
                if (trace) {
                    log.trace((Object)"Cache {0} within {1} cache manager is running and attributes could be refreshed, so it's up.", new Object[]{this.cacheName, this.cacheManagerName});
                }
                return AvailabilityType.UP;
            }
            if (trace) {
                log.trace((Object)"Cache status for {0} within {1} cache manager is anything other than running, so it's down.", new Object[]{this.cacheName, this.cacheManagerName});
            }
            return AvailabilityType.DOWN;
        }
        catch (Exception e) {
            if (trace) {
                log.trace((Object)"There was an exception checking availability, so cache status is down.");
            }
            return AvailabilityType.DOWN;
        }
    }

    public void start(ResourceContext<CacheManagerComponent> context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Start cache component");
        }
        this.context = context;
        this.cacheManagerName = ((CacheManagerComponent)context.getParentResourceComponent()).context.getResourceKey();
        this.cacheName = context.getResourceKey();
    }

    public void stop() {
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Get values metrics");
        }
        for (MeasurementScheduleRequest req : metrics) {
            if (trace) {
                log.trace((Object)"Inspect metric {0}", new Object[]{req});
            }
            String metric = req.getName();
            try {
                EmsBean bean = this.queryComponentBean(metric);
                if (bean == null) continue;
                if (trace) {
                    log.trace((Object)"Retrieved mbean with name {0}", new Object[]{bean.getBeanName()});
                }
                bean.refreshAttributes();
                String attName = metric.substring(metric.indexOf(".") + 1);
                EmsAttribute att = bean.getAttribute(attName);
                if (att != null) {
                    Object o = att.getValue();
                    Class attrType = att.getTypeClass();
                    DataType type = req.getDataType();
                    if (type == DataType.MEASUREMENT) {
                        if (o != null) {
                            MeasurementDataNumeric res = this.constructMeasurementDataNumeric(attrType, o, req);
                            if (res == null) continue;
                            report.addData(res);
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"Metric ({0}) has null value, do not add to report", new Object[]{req.getName()});
                        continue;
                    }
                    if (type != DataType.TRAIT) continue;
                    String value = (String)o;
                    if (trace) {
                        log.trace((Object)"Metric ({0}) is trait with value {1}", new Object[]{req.getName(), value});
                    }
                    MeasurementDataTrait res = new MeasurementDataTrait(req, value);
                    report.addData(res);
                    continue;
                }
                log.warn((Object)"Attribute {0} not found", new Object[]{attName});
            }
            catch (Exception e) {
                log.warn((Object)("getValues failed for " + metric + " : "), (Throwable)e);
            }
        }
    }

    public OperationResult invokeOperation(String fullOpName, Configuration parameters) throws Exception {
        boolean trace = log.isTraceEnabled();
        EmsBean bean = this.queryComponentBean(fullOpName);
        String opName = fullOpName.substring(fullOpName.indexOf(".") + 1);
        EmsOperation ops = bean.getOperation(opName);
        Collection simples = parameters.getSimpleProperties().values();
        if (trace) {
            log.trace((Object)"Parameters, as simple properties, are {0}", new Object[]{simples});
        }
        Object[] realParams = new Object[simples.size()];
        int i = 0;
        for (PropertySimple property : simples) {
            realParams[i++] = property.getStringValue();
        }
        if (ops == null) {
            throw new Exception("Operation " + fullOpName + " can't be found");
        }
        Object result = ops.invoke(realParams);
        if (trace) {
            log.trace((Object)"Returning operation result containing {0}", new Object[]{result.toString()});
        }
        return new OperationResult(result.toString());
    }

    private EmsConnection getConnection() {
        return ((CacheManagerComponent)this.context.getParentResourceComponent()).getEmsConnection();
    }

    private MeasurementDataNumeric constructMeasurementDataNumeric(Class attrType, Object o, MeasurementScheduleRequest req) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Metric ({0}) is measurement with value {1}", new Object[]{req.getName(), o});
        }
        if (attrType.equals(Long.class) || attrType.equals(Long.TYPE)) {
            Long tmp = (Long)o;
            return new MeasurementDataNumeric(req, Double.valueOf(tmp.longValue()));
        }
        if (attrType.equals(Double.class) || attrType.equals(Double.TYPE)) {
            Double tmp = (Double)o;
            return new MeasurementDataNumeric(req, tmp);
        }
        if (attrType.equals(Integer.class) || attrType.equals(Integer.TYPE)) {
            Integer tmp = (Integer)o;
            return new MeasurementDataNumeric(req, Double.valueOf(tmp.intValue()));
        }
        if (attrType.equals(String.class)) {
            String tmp = (String)o;
            return new MeasurementDataNumeric(req, Double.valueOf(tmp));
        }
        log.warn((Object)"Unknown {0} attribute type for {1}", new Object[]{attrType, o});
        return null;
    }

    private String getSingleComponentPattern(String cacheManagerName, String cacheName, String componentName) {
        return this.namedCacheComponentPattern(cacheManagerName, cacheName, componentName) + ",*";
    }

    private String namedCacheComponentPattern(String cacheManagerName, String cacheName, String componentName) {
        return CacheDiscovery.cacheComponentPattern(cacheManagerName, componentName) + ",name=" + ObjectName.quote(cacheName);
    }

    private EmsBean queryCacheBean() {
        return this.queryBean("Cache");
    }

    private EmsBean queryComponentBean(String name) {
        String componentName = name.substring(0, name.indexOf("."));
        return this.queryBean(componentName);
    }

    private EmsBean queryBean(String componentName) {
        EmsBean bean;
        ObjectNameQueryUtility queryUtility;
        List beans;
        EmsConnection conn = this.getConnection();
        String pattern = this.getSingleComponentPattern(this.cacheManagerName, this.cacheName, componentName);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Pattern to query is {0}", new Object[]{pattern});
        }
        if ((beans = conn.queryBeans((queryUtility = new ObjectNameQueryUtility(pattern)).getTranslatedQuery())).size() > 1) {
            log.warn((Object)"More than one bean returned from applying {0} pattern: {1}", new Object[]{pattern, beans});
        }
        if ((bean = (EmsBean)beans.get(0)) == null && log.isTraceEnabled()) {
            log.trace((Object)"No mbean found with name {0}", new Object[]{pattern});
        }
        return bean;
    }
}

