/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.heks.businessobject;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import javax.naming.NamingException;
import org.jboss.ejb3.core.businessobject.BusinessObjectFactory;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.ejb3.util.CollectionHelper;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.jndi.resolver.impl.JNDIPolicyBasedJNDINameResolverFactory;
import org.jboss.metadata.ejb.jboss.jndi.resolver.spi.SessionBean31JNDINameResolver;
import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.DefaultJNDIBindingPolicyFactory;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;

public class EJB31StatelessBusinessObjectFactory
implements BusinessObjectFactory {
    public <B> B createBusinessObject(SessionContainer container, Serializable sessionId, Class<B> businessInterface) {
        assert (sessionId == null) : "sessionId must be null for Stateless";
        assert (businessInterface != null) : "businessInterface is null";
        try {
            HashSet businessInterfaceNames = new HashSet();
            JBossSessionBeanMetaData smd = (JBossSessionBeanMetaData)container.getXml();
            CollectionHelper.addAllIfSet(businessInterfaceNames, (Collection)smd.getBusinessRemotes());
            CollectionHelper.addAllIfSet(businessInterfaceNames, (Collection)smd.getBusinessLocals());
            if (smd instanceof JBossSessionBean31MetaData && ((JBossSessionBean31MetaData)smd).isNoInterfaceBean() && businessInterface.equals(container.getBeanClass())) {
                return this.createNoInterfaceBusinessObject(container, sessionId, businessInterface);
            }
            String interfaceName = businessInterface.getName();
            if (!businessInterfaceNames.contains(interfaceName)) {
                throw new IllegalStateException("Cannot find BusinessObject for interface: " + interfaceName);
            }
            String jndiName = container.getXml().determineResolvedJndiName(interfaceName);
            return businessInterface.cast(container.getInitialContext().lookup(jndiName));
        }
        catch (NamingException e) {
            throw new RuntimeException("failed to invoke getBusinessObject", e);
        }
    }

    private <B> B createNoInterfaceBusinessObject(SessionContainer container, Serializable sessionId, Class<B> businessInterface) throws NamingException {
        JBossSessionBean31MetaData beanMetaData = (JBossSessionBean31MetaData)container.getMetaData();
        String noInterfaceJndiName = this.getJNDINameResolver(beanMetaData).resolveNoInterfaceJNDIName(beanMetaData);
        return businessInterface.cast(container.getInitialContext().lookup(noInterfaceJndiName));
    }

    private SessionBean31JNDINameResolver getJNDINameResolver(JBossSessionBean31MetaData sessionBean) {
        DefaultJndiBindingPolicy jndiBindingPolicy = DefaultJNDIBindingPolicyFactory.getDefaultJNDIBindingPolicy();
        return JNDIPolicyBasedJNDINameResolverFactory.getJNDINameResolver((JBossSessionBean31MetaData)sessionBean, (DefaultJndiBindingPolicy)jndiBindingPolicy);
    }
}

