/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jgroups.TimeoutException;
import org.jgroups.stack.Interval;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.DefaultTimeScheduler;
import org.jgroups.util.Promise;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"time-sensitive"}, dataProvider="createTimer", sequential=true)
public class TimeSchedulerTest {
    static final int NUM_MSGS = 1000;
    static long[] xmit_timeouts = new long[]{1000L, 2000L, 4000L, 8000L};
    static double PERCENTAGE_OFF = 0.3;

    @DataProvider(name="createTimer")
    Object[][] createTimer() {
        return Util.createTimer();
    }

    @Test(dataProvider="createTimer")
    public void testCancel(TimeScheduler timer) throws InterruptedException {
        for (int i = 0; i < 10; ++i) {
            timer.scheduleWithDynamicInterval(new OneTimeTask(1000L));
        }
        assert (timer.size() == 10);
        timer.stop();
        assert (timer.size() == 0) : "stopped timer should have no tasks";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="createTimer")
    public void testSchedulingTasksThenCancellingEverySecondTask(TimeScheduler timer) {
        int NUM = 20;
        Future[] futures = new Future[20];
        try {
            Future future;
            int i;
            for (i = 0; i < 20; ++i) {
                futures[i] = timer.schedule(new MyRunnable(i), 1000L, TimeUnit.MILLISECONDS);
                if (i % 2 != 0) continue;
                futures[i].cancel(false);
            }
            Util.sleep(3000L);
            for (i = 0; i < 20; ++i) {
                future = futures[i];
                System.out.println("[" + i + "] done=" + future.isDone() + ", cancelled=" + future.isCancelled());
            }
            for (i = 0; i < 20; ++i) {
                future = futures[i];
                assert (future.isDone());
                if (i % 2 == 0 ? !$assertionsDisabled && !future.isCancelled() : !$assertionsDisabled && future.isCancelled()) {
                    throw new AssertionError();
                }
            }
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="createTimer")
    public void testTaskCancellationBeforeTaskHasRun(TimeScheduler timer) throws InterruptedException {
        StressTask task = new StressTask();
        try {
            Future<?> future = timer.scheduleWithDynamicInterval(task);
            assert (timer.size() == 1);
            future.cancel(true);
            assert (timer.size() == 1);
            Util.sleep(200L);
            int num_executions = task.getNumExecutions();
            System.out.println("number of task executions=" + num_executions);
            assert (num_executions == 0) : "task should never have executed as it was cancelled before execution";
            if (timer instanceof DefaultTimeScheduler) {
                ((DefaultTimeScheduler)timer).purge();
            } else {
                Util.sleep(1000L);
            }
            assert (timer.size() == 0);
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="createTimer")
    public void testTaskCancellationAfterHasRun(TimeScheduler timer) throws InterruptedException {
        StressTask task = new StressTask();
        try {
            Future<?> future = timer.scheduleWithDynamicInterval(task);
            assert (timer.size() == 1);
            Util.sleep(500L);
            future.cancel(true);
            int size = timer.size();
            assert (size == 1) : " timer size should be 1, but is " + size;
            int num_executions = task.getNumExecutions();
            System.out.println("number of task executions=" + num_executions);
            assert (num_executions >= 1) : "task should have executed at least 1 time, as it was cancelled after 500ms";
            if (timer instanceof DefaultTimeScheduler) {
                ((DefaultTimeScheduler)timer).purge();
            } else {
                Util.sleep(1000L);
            }
            assert (timer.size() == 0) : " timer size should be 0, but is " + size;
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="createTimer")
    public void testRepeatingTask(TimeScheduler timer) throws InterruptedException {
        RepeatingTask task = new RepeatingTask(300L);
        try {
            Future<?> future = timer.scheduleAtFixedRate(task, 0L, 300L, TimeUnit.MILLISECONDS);
            Util.sleep(3200L);
            System.out.println("<<< cancelling task");
            future.cancel(true);
            Util.sleep(1000L);
            int num = task.getNum();
            System.out.println("task executed " + num + " times");
            assert (num >= 8 && num <= 11) : "number of executions is " + num + ", but should be >= 8 and <= 11\n" + "Execution times: " + TimeSchedulerTest.printExecutionTimes(task);
        }
        finally {
            timer.stop();
        }
    }

    private static String printExecutionTimes(RepeatingTask task) {
        StringBuilder sb = new StringBuilder();
        List<Long> times = task.getExecutionTimes();
        if (times.isEmpty()) {
            return "[]";
        }
        int cnt = 1;
        for (Long time : times) {
            sb.append("#" + cnt++ + ": ").append(time).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="createTimer")
    public void testStress(TimeScheduler timer) throws InterruptedException {
        int NUM_A = 500;
        int NUM_B = 1000;
        int cnt = 0;
        int print = 50000;
        try {
            int i;
            System.out.println("-- adding 500000 tasks...");
            for (i = 0; i < 500; ++i) {
                for (int j = 0; j < 1000; ++j) {
                    StressTask t = new StressTask();
                    Future<?> future = timer.scheduleWithDynamicInterval(t);
                    future.cancel(true);
                    if (++cnt <= 0 || cnt % print != 0) continue;
                    System.out.println(cnt);
                }
            }
            System.out.println("-- added 500000 tasks, waiting for termination");
            Util.sleep(1000L);
            for (i = 0; i < 10; ++i) {
                int size = timer.size();
                System.out.println(size);
                if (size == 0) break;
                Util.sleep(500L);
            }
            assert (timer.size() == 0);
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="createTimer")
    public void testDynamicTask(TimeScheduler timer) throws InterruptedException {
        DynamicTask task = new DynamicTask();
        try {
            Future<?> future = timer.scheduleWithDynamicInterval(task);
            assert (!future.isCancelled());
            assert (!future.isDone());
            Thread.sleep(3000L);
            assert (!future.isCancelled());
            assert (!future.isDone());
            future.cancel(true);
            assert (future.isCancelled());
            assert (future.isDone());
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="createTimer")
    public void testDynamicTaskCancel(TimeScheduler timer) throws InterruptedException {
        try {
            DynamicTask task = new DynamicTask();
            Future<?> future = timer.scheduleWithDynamicInterval(task);
            assert (!future.isCancelled());
            assert (!future.isDone());
            Thread.sleep(3000L);
            assert (!future.isCancelled());
            assert (!future.isDone());
            assert (future.cancel(true));
            assert (future.isCancelled());
            assert (future.isDone());
            assert (!future.cancel(true));
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="createTimer")
    public void testIsDone(TimeScheduler timer) throws InterruptedException {
        try {
            DynamicTask task = new DynamicTask();
            Future<?> future = timer.scheduleWithDynamicInterval(task);
            assert (!future.isCancelled());
            assert (!future.isDone());
            Thread.sleep(3000L);
            assert (!future.isCancelled());
            assert (!future.isDone());
            future.cancel(true);
            assert (future.isCancelled());
            assert (future.isDone());
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="createTimer")
    public void testIsDone2(TimeScheduler timer) throws InterruptedException {
        try {
            DynamicTask task = new DynamicTask(new long[]{1000L, 2000L, -1L});
            Future<?> future = timer.scheduleWithDynamicInterval(task);
            assert (!future.isCancelled());
            assert (!future.isDone());
            Thread.sleep(3500L);
            assert (!future.isCancelled());
            assert (future.isDone());
            assert (!future.cancel(true));
            assert (future.isCancelled());
            assert (future.isDone());
            assert (!future.cancel(true));
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="createTimer")
    public void testIsDone3(TimeScheduler timer) throws InterruptedException {
        try {
            DynamicTask task = new DynamicTask(new long[]{-1L});
            Future<?> future = timer.scheduleWithDynamicInterval(task);
            Thread.sleep(100L);
            assert (!future.isCancelled());
            assert (future.isDone());
            assert (!future.cancel(true));
            assert (future.isCancelled());
            assert (future.isDone());
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="createTimer")
    public void testImmediateExecution(TimeScheduler timer) throws InterruptedException {
        try {
            Promise<Boolean> p = new Promise<Boolean>();
            ImmediateTask task = new ImmediateTask(p);
            timer.execute(task);
            try {
                long start = System.currentTimeMillis();
                p.getResultWithTimeout(500L);
                long stop = System.currentTimeMillis();
                System.out.println("task took " + (stop - start) + "ms");
            }
            catch (TimeoutException e) {
                assert (false) : "ran into timeout - task should have executed immediately";
            }
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="createTimer")
    public void test2Tasks(TimeScheduler timer) throws InterruptedException {
        try {
            System.out.println(System.currentTimeMillis() + ": adding task");
            timer.schedule(new MyTask(), 500L, TimeUnit.MILLISECONDS);
            int size = timer.size();
            System.out.println("queue size=" + size);
            Assert.assertEquals((int)1, (int)size);
            Thread.sleep(1000L);
            size = timer.size();
            System.out.println("queue size=" + size);
            Assert.assertEquals((int)0, (int)size);
            Thread.sleep(1500L);
            System.out.println(System.currentTimeMillis() + ": adding task");
            timer.schedule(new MyTask(), 500L, TimeUnit.MILLISECONDS);
            System.out.println(System.currentTimeMillis() + ": adding task");
            timer.schedule(new MyTask(), 500L, TimeUnit.MILLISECONDS);
            System.out.println(System.currentTimeMillis() + ": adding task");
            timer.schedule(new MyTask(), 500L, TimeUnit.MILLISECONDS);
            size = timer.size();
            System.out.println("queue size=" + size);
            Assert.assertEquals((int)3, (int)size);
            Thread.sleep(1000L);
            size = timer.size();
            System.out.println("queue size=" + size);
            Assert.assertEquals((int)0, (int)size);
        }
        finally {
            timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="createTimer")
    public void testRetransmits(TimeScheduler timer) throws InterruptedException {
        int num_non_correct_entries = 0;
        ConcurrentHashMap<Long, Entry> msgs = new ConcurrentHashMap<Long, Entry>();
        try {
            System.out.println("-- adding 1000 messages:");
            for (long i = 0L; i < 1000L; ++i) {
                Entry entry = new Entry(i);
                msgs.put(new Long(i), entry);
                timer.scheduleWithDynamicInterval(entry);
            }
            System.out.println("-- done");
            System.out.println("-- waiting for all retransmits");
            long end_time = System.currentTimeMillis() + 20000L;
            long start = System.currentTimeMillis();
            while (System.currentTimeMillis() < end_time && (num_non_correct_entries = TimeSchedulerTest.check(msgs, false)) != 0) {
                Util.sleep(1000L);
            }
            System.out.println("-- waited for " + (System.currentTimeMillis() - start) + " ms");
            num_non_correct_entries = TimeSchedulerTest.check(msgs, true);
            if (num_non_correct_entries > 0) {
                System.err.println("Number of incorrect retransmission timeouts: " + num_non_correct_entries);
            }
            assert (num_non_correct_entries == 0) : "expected 0 incorrect entries but got " + num_non_correct_entries;
        }
        finally {
            timer.stop();
        }
    }

    @Test(dataProvider="createTimer")
    public void testTasksPreemptingEachOther(TimeScheduler timer) {
        final ArrayList results = new ArrayList(3);
        long execution_time = 4000L;
        final long base = System.currentTimeMillis();
        Integer[] arr$ = new Integer[]{1, 2, 3};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int num;
            final int cnt = num = arr$[i$].intValue();
            timer.schedule(new Runnable(){

                @Override
                public void run() {
                    results.add(cnt);
                    System.out.println("[" + (System.currentTimeMillis() - base) + "] " + cnt);
                }
            }, execution_time, TimeUnit.MILLISECONDS);
            execution_time -= 1300L;
            Util.sleep(300L);
        }
        for (int i = 0; i < 10 && results.size() != 3; ++i) {
            Util.sleep(500L);
        }
        System.out.println("results = " + results);
        assert (results.size() == 3) : "results = " + results;
        assert ((Integer)results.get(0) == 3) : "results = " + results;
        assert ((Integer)results.get(1) == 2) : "results = " + results;
        assert ((Integer)results.get(2) == 1) : "results = " + results;
    }

    @Test(dataProvider="createTimer")
    public void testSchedulerWithFixedDelay(TimeScheduler timer) {
        final AtomicBoolean set = new AtomicBoolean(false);
        Future<?> future = timer.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                set.set(true);
            }
        }, 0L, 3000L, TimeUnit.MILLISECONDS);
        Util.sleep(500L);
        future.cancel(true);
        System.out.println("variable was set: " + set);
        assert (set.get());
        future = timer.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                set.set(true);
            }
        }, 300L, 3000L, TimeUnit.MILLISECONDS);
        Util.sleep(1000L);
        future.cancel(true);
        System.out.println("variable was set: " + set);
        assert (set.get());
    }

    static int check(Map<Long, Entry> msgs, boolean print) {
        int retval = 0;
        for (long i = 0L; i < 1000L; ++i) {
            Entry entry = msgs.get(new Long(i));
            if (entry.isCorrect(print)) continue;
            ++retval;
        }
        return retval;
    }

    private static class Entry
    implements TimeScheduler.Task {
        long start_time = 0L;
        long first_xmit = 0L;
        long second_xmit = 0L;
        long third_xmit = 0L;
        long fourth_xmit = 0L;
        Interval interval = new StaticInterval(xmit_timeouts);
        long seqno = 0L;

        Entry(long seqno) {
            this.seqno = seqno;
            this.start_time = System.currentTimeMillis();
        }

        @Override
        public long nextInterval() {
            return this.interval.next();
        }

        @Override
        public void run() {
            if (this.first_xmit == 0L) {
                this.first_xmit = System.currentTimeMillis();
            } else if (this.second_xmit == 0L) {
                this.second_xmit = System.currentTimeMillis();
            } else if (this.third_xmit == 0L) {
                this.third_xmit = System.currentTimeMillis();
            } else if (this.fourth_xmit == 0L) {
                this.fourth_xmit = System.currentTimeMillis();
            }
        }

        boolean isCorrect(boolean print) {
            long delta;
            long expected = xmit_timeouts[0];
            long t = this.first_xmit - this.start_time;
            long diff = Math.abs(expected - t);
            if (diff <= (delta = (long)((double)expected * PERCENTAGE_OFF))) {
                return true;
            }
            expected = xmit_timeouts[1];
            t = this.second_xmit - this.first_xmit;
            diff = Math.abs(expected - t);
            if (diff <= (delta = (long)((double)expected * PERCENTAGE_OFF))) {
                return true;
            }
            expected = xmit_timeouts[2];
            t = this.third_xmit - this.second_xmit;
            diff = Math.abs(expected - t);
            if (diff <= (delta = (long)((double)expected * PERCENTAGE_OFF))) {
                return true;
            }
            expected = xmit_timeouts[3];
            t = this.fourth_xmit - this.third_xmit;
            diff = Math.abs(expected - t);
            if (diff <= (delta = (long)((double)expected * PERCENTAGE_OFF))) {
                return true;
            }
            if (print) {
                System.err.println("#" + this.seqno + ": " + this + ": (" + "entry is more than " + PERCENTAGE_OFF + " percentage off ");
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.first_xmit - this.start_time).append(", ").append(this.second_xmit - this.first_xmit).append(", ");
            sb.append(this.third_xmit - this.second_xmit).append(", ").append(this.fourth_xmit - this.third_xmit);
            return sb.toString();
        }
    }

    static class MyRunnable
    implements Runnable {
        final int num;

        public MyRunnable(int num) {
            this.num = num;
        }

        @Override
        public void run() {
            System.out.println("[" + this.num + "] at " + System.currentTimeMillis());
        }
    }

    static class StressTask
    implements TimeScheduler.Task {
        int num_executions = 0;

        StressTask() {
        }

        public int getNumExecutions() {
            return this.num_executions;
        }

        @Override
        public long nextInterval() {
            return 50L;
        }

        @Override
        public void run() {
            ++this.num_executions;
        }
    }

    static class RepeatingTask
    extends OneTimeTask {
        int num = 0;
        List<Long> execution_times = new LinkedList<Long>();
        private long base = 0L;

        RepeatingTask(long timeout) {
            super(timeout);
        }

        public int getNum() {
            return this.num;
        }

        public List<Long> getExecutionTimes() {
            return this.execution_times;
        }

        @Override
        public void run() {
            if (this.base == 0L) {
                this.base = System.currentTimeMillis();
            }
            long time = System.currentTimeMillis() - this.base;
            System.out.println(this.num + 1 + ": this is a repeating task (" + time + "ms after start)");
            this.execution_times.add(time);
            ++this.num;
        }
    }

    static class OneTimeTask
    implements TimeScheduler.Task {
        boolean done = false;
        private long timeout = 0L;

        OneTimeTask(long timeout) {
            this.timeout = timeout;
        }

        @Override
        public long nextInterval() {
            return this.timeout;
        }

        @Override
        public void run() {
            System.out.println(System.currentTimeMillis() + ": this is MyTask running - done");
            this.done = true;
        }
    }

    static class DynamicTask
    implements TimeScheduler.Task {
        long[] times = new long[]{1000L, 2000L, 4000L};
        int index = 0;

        public DynamicTask() {
        }

        public DynamicTask(long[] times) {
            this.times = times;
        }

        @Override
        public long nextInterval() {
            if (this.index == this.times.length - 1) {
                return this.times[this.index];
            }
            return this.times[this.index++];
        }

        @Override
        public void run() {
            System.out.println("dynamic task run at " + new Date());
        }
    }

    static class MyTask
    implements Runnable {
        MyTask() {
        }

        @Override
        public void run() {
            System.out.println(System.currentTimeMillis() + ": this is MyTask running - done");
        }
    }

    private static class ImmediateTask
    implements Runnable {
        Promise<Boolean> p;

        public ImmediateTask(Promise<Boolean> p) {
            this.p = p;
        }

        @Override
        public void run() {
            this.p.setResult(true);
        }
    }
}

