/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jgroups.protocols.S3_PING;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-independent"})
public class S3_PINGTest {
    private S3_PING ping;

    @BeforeMethod
    public void setUp() {
        this.ping = new S3_PING();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testValidatePropertiesWithPreSignedPutSet() {
        this.ping.pre_signed_put_url = "http://s3.amazonaws.com/test-bucket/node1";
        this.ping.validateProperties();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testValidatePropertiesWithPreSignedDeleteSet() {
        this.ping.pre_signed_delete_url = "http://s3.amazonaws.com/test-bucket/node1";
        this.ping.validateProperties();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testValidatePropertiesWithBothPreSignedSetButNoBucket() {
        this.ping.pre_signed_put_url = "http://s3.amazonaws.com/";
        this.ping.pre_signed_delete_url = "http://s3.amazonaws.com/";
        this.ping.validateProperties();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testValidatePropertiesWithBothPreSignedSetButNoFile() {
        this.ping.pre_signed_put_url = "http://s3.amazonaws.com/test-bucket";
        this.ping.pre_signed_delete_url = "http://s3.amazonaws.com/test-bucket";
        this.ping.validateProperties();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testValidatePropertiesWithBothPreSignedSetButTooManySubdirectories() {
        this.ping.pre_signed_put_url = "http://s3.amazonaws.com/test-bucket/subdir/DemoCluster/node1";
        this.ping.pre_signed_delete_url = "http://s3.amazonaws.com/test-bucket/subdir/DemoCluster/node1";
        this.ping.validateProperties();
    }

    @Test
    public void testValidatePropertiesWithBothPreSignedSetToValid() {
        this.ping.pre_signed_put_url = "http://s3.amazonaws.com/test-bucket/node1";
        this.ping.pre_signed_delete_url = "http://s3.amazonaws.com/test-bucket/node1";
        this.ping.validateProperties();
    }

    @Test
    public void testValidatePropertiesWithBothPreSignedSetToValidSubdirectory() {
        this.ping.pre_signed_put_url = "http://s3.amazonaws.com/test-bucket/DemoCluster/node1";
        this.ping.pre_signed_delete_url = "http://s3.amazonaws.com/test-bucket/DemoCluster/node1";
        this.ping.validateProperties();
    }

    @Test
    public void testUsingPreSignedUrlWhenNotSet() {
        Assert.assertFalse((boolean)this.ping.usingPreSignedUrls());
    }

    @Test
    public void testUsingPreSignedUrlWhenSet() {
        this.ping.pre_signed_put_url = "http://s3.amazonaws.com/test-bucket/node1";
        Assert.assertTrue((boolean)this.ping.usingPreSignedUrls());
    }

    @Test
    public void testGenerateQueryStringAuthenticationWithBasicGet() {
        String expectedUrl = "http://s3.amazonaws.com/test-bucket/node1?AWSAccessKeyId=abcd&Expires=1234567890&Signature=Khyk4bU1A3vaed9woyp%2B5qepazQ%3D";
        String encodedUrl = S3_PING.Utils.generateQueryStringAuthentication("abcd", "efgh", "get", "test-bucket", "node1", new HashMap(), new HashMap(), 1234567890L);
        Assert.assertEquals((String)encodedUrl, (String)expectedUrl);
    }

    @Test
    public void testGenerateQueryStringAuthenticationWithBasicPost() {
        String expectedUrl = "http://s3.amazonaws.com/test-bucket/node1?AWSAccessKeyId=abcd&Expires=1234567890&Signature=%2BsCW1Fc20UUvIqPjeGXkyN960sk%3D";
        String encodedUrl = S3_PING.Utils.generateQueryStringAuthentication("abcd", "efgh", "POST", "test-bucket", "node1", new HashMap(), new HashMap(), 1234567890L);
        Assert.assertEquals((String)encodedUrl, (String)expectedUrl);
    }

    @Test
    public void testGenerateQueryStringAuthenticationWithBasicPutAndHeaders() {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("x-amz-acl", Arrays.asList("public-read"));
        String expectedUrl = "http://s3.amazonaws.com/test-bucket/subdir/node1?AWSAccessKeyId=abcd&Expires=1234567890&Signature=GWu2Mm5MysW83YDgS2R0Jakthes%3D";
        String encodedUrl = S3_PING.Utils.generateQueryStringAuthentication("abcd", "efgh", "put", "test-bucket", "subdir/node1", new HashMap(), headers, 1234567890L);
        Assert.assertEquals((String)encodedUrl, (String)expectedUrl);
    }

    @Test
    public void testGeneratePreSignedUrlForPut() {
        String expectedUrl = "http://s3.amazonaws.com/test-bucket/subdir/node1?AWSAccessKeyId=abcd&Expires=1234567890&Signature=GWu2Mm5MysW83YDgS2R0Jakthes%3D";
        String preSignedUrl = S3_PING.generatePreSignedUrl("abcd", "efgh", "put", "test-bucket", "subdir/node1", 1234567890L);
        Assert.assertEquals((String)preSignedUrl, (String)expectedUrl);
    }

    @Test
    public void testGeneratePreSignedUrlForDelete() {
        String expectedUrl = "http://s3.amazonaws.com/test-bucket/subdir/node1?AWSAccessKeyId=abcd&Expires=1234567890&Signature=qbEMukqq0KIpZVjXaDi0VxepSVo%3D";
        String preSignedUrl = S3_PING.generatePreSignedUrl("abcd", "efgh", "delete", "test-bucket", "subdir/node1", 1234567890L);
        Assert.assertEquals((String)preSignedUrl, (String)expectedUrl);
    }
}

