/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.api.server;

import org.jboss.bootstrap.api.as.server.JBossASServerFactory;
import org.jboss.embedded.api.server.JBossASEmbeddedServer;
import org.jboss.embedded.api.server.SecurityActions;

public class JBossASEmbeddedServerFactory {
    private static final String DEFAULT_SERVER_IMPL_CLASS_NAME = "org.jboss.embedded.core.server.JBossASEmbeddedServerImpl";
    private static final String SYS_PROP_TMP_DIR = "java.io.tmpdir";

    private JBossASEmbeddedServerFactory() {
        throw new UnsupportedOperationException("No instances permitted");
    }

    public static JBossASEmbeddedServer createServer() {
        return JBossASEmbeddedServerFactory.createServer(SecurityActions.getTccl());
    }

    public static JBossASEmbeddedServer createServer(ClassLoader cl) throws IllegalArgumentException {
        String sysPropBootLogDir = "jboss.boot.server.log.dir";
        String sysPropLogDir = "jboss.server.log.dir";
        String manualBootLogDir = SecurityActions.getSystemProperty("jboss.boot.server.log.dir");
        String manualLogDir = SecurityActions.getSystemProperty("jboss.server.log.dir");
        if (manualBootLogDir == null && manualLogDir == null) {
            String serverLogDir = SecurityActions.getSystemProperty(SYS_PROP_TMP_DIR);
            SecurityActions.setSystemProperty("jboss.boot.server.log.dir", serverLogDir);
            System.out.println("Boot Log available in: " + serverLogDir);
        } else if (manualLogDir != null) {
            SecurityActions.setSystemProperty("jboss.boot.server.log.dir", manualLogDir);
        }
        try {
            return (JBossASEmbeddedServer)JBossASServerFactory.createServer((String)DEFAULT_SERVER_IMPL_CLASS_NAME, (ClassLoader)cl, JBossASEmbeddedServer.class);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("Server instance could not be created", ie);
        }
    }
}

