/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.editor.completion;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.options.editor.completion.CodeCompletionOptionsSelector;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class CodeCompletionOptionsPanel
extends JPanel
implements PropertyChangeListener {
    private CodeCompletionOptionsSelector selector;
    private PropertyChangeListener weakListener;
    private JComboBox cbLanguage;
    private JLabel lLanguage;
    private JPanel panel;

    public CodeCompletionOptionsPanel() {
        this.initComponents();
        this.cbLanguage.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof String) {
                    object = ((String)object).length() > 0 ? EditorSettings.getDefault().getLanguageName((String)object) : NbBundle.getMessage(CodeCompletionOptionsPanel.class, (String)"LBL_AllLanguages");
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
    }

    public void setSelector(CodeCompletionOptionsSelector codeCompletionOptionsSelector) {
        if (this.selector != null) {
            this.selector.removePropertyChangeListener(this.weakListener);
        }
        this.selector = codeCompletionOptionsSelector;
        if (this.selector != null) {
            this.weakListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.selector);
            this.selector.addPropertyChangeListener(this.weakListener);
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            ArrayList<? extends String> arrayList = new ArrayList<String>();
            arrayList.addAll(codeCompletionOptionsSelector.getMimeTypes());
            Collections.sort(arrayList, new LanguagesComparator());
            for (String string : arrayList) {
                defaultComboBoxModel.addElement(string);
            }
            this.cbLanguage.setModel(defaultComboBoxModel);
            this.cbLanguage.setSelectedIndex(0);
        } else {
            this.cbLanguage.setModel(new DefaultComboBoxModel());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.panel.setVisible(false);
        this.panel.removeAll();
        PreferencesCustomizer preferencesCustomizer = this.selector.getSelectedCustomizer();
        if (preferencesCustomizer != null) {
            this.panel.add((Component)preferencesCustomizer.getComponent(), "Center");
        }
        this.panel.setVisible(true);
    }

    private void initComponents() {
        this.lLanguage = new JLabel();
        this.cbLanguage = new JComboBox();
        this.panel = new JPanel();
        this.lLanguage.setLabelFor(this.cbLanguage);
        Mnemonics.setLocalizedText((JLabel)this.lLanguage, (String)NbBundle.getMessage(CodeCompletionOptionsPanel.class, (String)"CTL_Language"));
        this.cbLanguage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodeCompletionOptionsPanel.this.languageChanged(actionEvent);
            }
        });
        this.panel.setOpaque(false);
        this.panel.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lLanguage).addPreferredGap(0).add((Component)this.cbLanguage, -2, -1, -2).addContainerGap()).add((Component)this.panel, -1, 132, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lLanguage).add((Component)this.cbLanguage, -2, -1, -2)).addPreferredGap(0).add((Component)this.panel, -1, 131, Short.MAX_VALUE)));
    }

    private void languageChanged(ActionEvent actionEvent) {
        this.selector.setSelectedMimeType((String)this.cbLanguage.getSelectedItem());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LanguagesComparator
    implements Comparator<String> {
        private LanguagesComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            if (string.length() == 0) {
                return string2.length() == 0 ? 0 : -1;
            }
            if (string2.length() == 0) {
                return 1;
            }
            String string3 = EditorSettings.getDefault().getLanguageName(string);
            String string4 = EditorSettings.getDefault().getLanguageName(string2);
            return string3.compareTo(string4);
        }
    }
}

