/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.DialogDescriptor;
import org.openide.util.NbBundle;

public final class JavaPlatformSelector
extends JPanel
implements ListSelectionListener {
    private static final String OK_BUTTON_NAME = NbBundle.getMessage(JavaPlatformSelector.class, (String)"JavaPlatformSelector_OkButtonName");
    private static final String USE_SEL_PLATFORM_CHCKBOX_NAME = NbBundle.getMessage(JavaPlatformSelector.class, (String)"JavaPlatformSelector_UseSelPlatformChckBoxName");
    private static final String NO_SUPPORTED_PLATFORM_MSG = NbBundle.getMessage(JavaPlatformSelector.class, (String)"JavaPlatformSelector_NoSupportedPlatformMsg");
    private static final String SELECT_PLATFORM_CALIBRATE_MSG = NbBundle.getMessage(JavaPlatformSelector.class, (String)"JavaPlatformSelector_SelectPlatformCalibrateMsg");
    private static final String SELECT_PLATFORM_CALIBRATE_DIALOG_CAPTION = NbBundle.getMessage(JavaPlatformSelector.class, (String)"JavaPlatformSelector_SelectPlatformCalibrateDialogCaption");
    private static final String SELECT_PLATFORM_PROFILE_MSG = NbBundle.getMessage(JavaPlatformSelector.class, (String)"JavaPlatformSelector_SelectPlatformProfileMsg");
    private static final String SELECT_PLATFORM_PROFILE_DIALOG_CAPTION = NbBundle.getMessage(JavaPlatformSelector.class, (String)"JavaPlatformSelector_SelectPlatformProfileDialogCaption");
    private static final String CANNOT_USE_PLATFORM_MSG = NbBundle.getMessage(JavaPlatformSelector.class, (String)"JavaPlatformSelector_CannotUsePlatform");
    private static final String LIST_ACCESS_NAME = NbBundle.getMessage(JavaPlatformSelector.class, (String)"JavaPlatformSelector_ListAccessName");
    private static JavaPlatformSelector defaultPlatform;
    private JLabel noteLabel;
    private JButton okButton = new JButton(OK_BUTTON_NAME);
    private JCheckBox alwaysCheckBox;
    private JList list;

    private JavaPlatformSelector() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.list = new JList();
        this.list.setVisibleRowCount(6);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
        this.list.getAccessibleContext().setAccessibleName(LIST_ACCESS_NAME);
        this.noteLabel = new JLabel();
        this.noteLabel.setLabelFor(this.list);
        this.noteLabel.setFocusable(false);
        this.alwaysCheckBox = new JCheckBox(USE_SEL_PLATFORM_CHCKBOX_NAME, false);
        this.add((Component)new JScrollPane(this.list), "Center");
        this.add((Component)this.noteLabel, "North");
        this.add((Component)this.alwaysCheckBox, "South");
    }

    public static synchronized JavaPlatformSelector getDefault() {
        if (defaultPlatform == null) {
            defaultPlatform = new JavaPlatformSelector();
        }
        return defaultPlatform;
    }

    public static List getSupportedPlatforms() {
        JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2se", null));
        ArrayList<JavaPlatform> arrayList = new ArrayList<JavaPlatform>();
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            JavaPlatform javaPlatform = javaPlatformArray[i];
            if (!MiscUtils.isSupportedJVM((Map)javaPlatform.getSystemProperties())) continue;
            arrayList.add(javaPlatformArray[i]);
        }
        return arrayList;
    }

    public JavaPlatform selectPlatformForCalibration() {
        List list = JavaPlatformSelector.getSupportedPlatforms();
        if (list.size() == 0) {
            Profiler.getDefault().displayError(NO_SUPPORTED_PLATFORM_MSG);
            PlatformsCustomizer.showCustomizer(null);
            return null;
        }
        this.noteLabel.setText(SELECT_PLATFORM_CALIBRATE_MSG);
        this.noteLabel.getAccessibleContext().setAccessibleName(SELECT_PLATFORM_CALIBRATE_MSG);
        this.list.getAccessibleContext().setAccessibleDescription(SELECT_PLATFORM_CALIBRATE_MSG);
        this.list.setModel(new JPListModel(list));
        this.alwaysCheckBox.setVisible(false);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, SELECT_PLATFORM_CALIBRATE_DIALOG_CAPTION, true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, null, null);
        this.list.setSelectedIndex(0);
        this.validateOKButton();
        Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(SELECT_PLATFORM_CALIBRATE_DIALOG_CAPTION);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == this.okButton) {
            int n = this.list.getSelectedIndex();
            return (JavaPlatform)list.get(n);
        }
        return null;
    }

    public JavaPlatform selectPlatformToUse() {
        List list = JavaPlatformSelector.getSupportedPlatforms();
        if (list.size() == 0) {
            Profiler.getDefault().displayError(NO_SUPPORTED_PLATFORM_MSG);
            PlatformsCustomizer.showCustomizer(null);
            return null;
        }
        this.noteLabel.setText("<html>" + CANNOT_USE_PLATFORM_MSG + "<br>" + SELECT_PLATFORM_PROFILE_MSG + "</html>");
        this.noteLabel.getAccessibleContext().setAccessibleName(CANNOT_USE_PLATFORM_MSG + SELECT_PLATFORM_PROFILE_MSG);
        this.list.getAccessibleContext().setAccessibleDescription(CANNOT_USE_PLATFORM_MSG + SELECT_PLATFORM_PROFILE_MSG);
        this.list.setModel(new JPListModel(list));
        this.alwaysCheckBox.setSelected(false);
        this.alwaysCheckBox.setVisible(true);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, SELECT_PLATFORM_PROFILE_DIALOG_CAPTION, true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, null, null);
        this.list.setSelectedIndex(0);
        this.validateOKButton();
        ProfilerDialogs.createDialog(dialogDescriptor).setVisible(true);
        if (dialogDescriptor.getValue() == this.okButton) {
            int n = this.list.getSelectedIndex();
            JavaPlatform javaPlatform = (JavaPlatform)list.get(n);
            if (this.alwaysCheckBox.isSelected()) {
                Profiler.getDefault().getGlobalProfilingSettings().setJavaPlatformForProfiling(javaPlatform == null ? null : javaPlatform.getDisplayName());
            }
            return javaPlatform;
        }
        return null;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.validateOKButton();
    }

    private void validateOKButton() {
        this.okButton.setEnabled(this.list.getSelectedIndex() != -1);
    }

    public static class JPListModel
    extends AbstractListModel {
        private List platforms;

        private JPListModel(List list) {
            this.platforms = list;
        }

        public Object getElementAt(int n) {
            return ((JavaPlatform)this.platforms.get(n)).getDisplayName();
        }

        public int getSize() {
            return this.platforms.size();
        }
    }
}

