/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.output;

import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class CompileAnnotation
implements OutputListener {
    File clazzfile;
    private int lineNum;
    private String text;

    public CompileAnnotation(File file, String string, String string2) {
        this.clazzfile = file;
        this.text = string2;
        try {
            this.lineNum = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.lineNum = -1;
        }
    }

    public void outputLineSelected(OutputEvent outputEvent) {
    }

    public void outputLineAction(OutputEvent outputEvent) {
        block9: {
            FileUtil.refreshFor((File[])new File[]{this.clazzfile});
            FileObject fileObject = FileUtil.toFileObject((File)this.clazzfile);
            if (fileObject == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie != null && fileObject == dataObject.getPrimaryFile()) {
                    if (this.lineNum == -1) {
                        editorCookie.open();
                        break block9;
                    }
                    editorCookie.openDocument();
                    try {
                        Line line = editorCookie.getLineSet().getOriginal(this.lineNum - 1);
                        if (!line.isDeleted()) {
                            line.show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FOCUS);
                        }
                        break block9;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        editorCookie.open();
                    }
                    break block9;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    public void outputLineCleared(OutputEvent outputEvent) {
    }

    public String toString() {
        return "error[" + this.clazzfile + ":" + this.lineNum + ":" + this.text + "]";
    }
}

