/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarFile;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.maven.TextValueCompleter;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.customizer.ActionMappings;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.modules.maven.execute.NbGlobalActionGoalProvider;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.io.xpp3.NetbeansBuildActionXpp3Reader;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.options.GlobalOptionsPanel;
import org.netbeans.modules.maven.options.MavenOptionController;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.options.MyJTextField;
import org.netbeans.modules.maven.spi.actions.MavenActionsProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsPanel
extends JPanel {
    private static final String CP_SELECTED = "wasSelected";
    private boolean changed;
    private boolean valid;
    private ActionListener listener;
    private DocumentListener docList;
    private MavenOptionController controller;
    private TextValueCompleter completer;
    static String[] AVAILABLE_OPTIONS = new String[]{"--offline", "--debug", "--errors", "--batch-mode", "--fail-fast", "--fail-at-end", "--fail-never", "--strict-checksums", "--lax-checksums", "--check-plugin-updates", "--no-plugin-updates", "--update-snapshots", "--no-plugin-registry"};
    private ButtonGroup bgChecksums;
    private ButtonGroup bgFailure;
    private ButtonGroup bgPlugins;
    private JButton btnCommandLine;
    private JButton btnGoals;
    private JButton btnIndex;
    private JButton btnLocalRepository;
    private JButton btnOptions;
    private JCheckBox cbSkipTests;
    private JCheckBox cbSnapshots;
    private JComboBox comBinaries;
    private JComboBox comIndex;
    private JComboBox comJavadoc;
    private JComboBox comSource;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel lblBinaries;
    private JLabel lblCommandLine;
    private JLabel lblEmbeddedVersion;
    private JLabel lblExternalVersion;
    private JLabel lblIndex;
    private JLabel lblJavadoc;
    private JLabel lblLocalRepository;
    private JLabel lblOptions;
    private JLabel lblSource;
    private JTextField txtCommandLine;
    private JTextField txtLocalRepository;
    private JTextField txtOptions;

    SettingsPanel(MavenOptionController mavenOptionController) {
        this.initComponents();
        MavenSettings.DownloadStrategy[] downloadStrategyArray = MavenSettings.DownloadStrategy.values();
        this.comBinaries.setModel(new DefaultComboBoxModel<MavenSettings.DownloadStrategy>(downloadStrategyArray));
        this.comJavadoc.setModel(new DefaultComboBoxModel<MavenSettings.DownloadStrategy>(downloadStrategyArray));
        this.comSource.setModel(new DefaultComboBoxModel<MavenSettings.DownloadStrategy>(downloadStrategyArray));
        DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string = "";
                if (object.equals((Object)MavenSettings.DownloadStrategy.NEVER)) {
                    string = NbBundle.getMessage(SettingsPanel.class, (String)"TIT_NEVER");
                } else if (object.equals((Object)MavenSettings.DownloadStrategy.EVERY_OPEN)) {
                    string = NbBundle.getMessage(SettingsPanel.class, (String)"TIT_EVERY");
                } else if (object.equals((Object)MavenSettings.DownloadStrategy.FIRST_OPEN)) {
                    string = NbBundle.getMessage(SettingsPanel.class, (String)"TIT_FIRST");
                }
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        };
        this.comBinaries.setRenderer(defaultListCellRenderer);
        this.comSource.setRenderer(defaultListCellRenderer);
        this.comJavadoc.setRenderer(defaultListCellRenderer);
        this.controller = mavenOptionController;
        this.docList = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SettingsPanel.this.documentChanged(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SettingsPanel.this.documentChanged(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                SettingsPanel.this.documentChanged(documentEvent);
            }
        };
        this.initValues();
        ((MyJTextField)this.txtLocalRepository).setHintText(NbBundle.getMessage(SettingsPanel.class, (String)"txt_default_repository"));
        this.listener = new ActionListenerImpl();
        this.cbSnapshots.addActionListener(this.listener);
        this.comIndex.addActionListener(this.listener);
        this.completer = new TextValueCompleter(SettingsPanel.getGlobalOptions(), this.txtOptions, " ");
        this.initEmbeddedVersion();
    }

    static String[] getAvailableOptionsDescriptions() {
        return new String[]{NbBundle.getMessage(SettingsPanel.class, (String)"WORK_OFFLINE"), NbBundle.getMessage(SettingsPanel.class, (String)"PRODUCE_EXECUTION_DEBUG_OUTPUT"), NbBundle.getMessage(SettingsPanel.class, (String)"PRODUCE_EXECUTION_ERROR_MESSAGES"), NbBundle.getMessage(SettingsPanel.class, (String)"NON-INTERACTIVE_MODE."), NbBundle.getMessage(SettingsPanel.class, (String)"STOP_AT_FIRST_FAILURE"), NbBundle.getMessage(SettingsPanel.class, (String)"ONLY_FAIL_THE_BUILD_AFTERWARDS"), NbBundle.getMessage(SettingsPanel.class, (String)"NEVER_FAIL_THE_BUILD"), NbBundle.getMessage(SettingsPanel.class, (String)"FAIL_CHECKSUMS"), NbBundle.getMessage(SettingsPanel.class, (String)"WARN_CHECKSUMS"), NbBundle.getMessage(SettingsPanel.class, (String)"FORCE_UPTODATE_CHECK"), NbBundle.getMessage(SettingsPanel.class, (String)"SUPPRESS_UPTODATE_CHECK"), NbBundle.getMessage(SettingsPanel.class, (String)"FORCES_A_CHECK"), NbBundle.getMessage(SettingsPanel.class, (String)"DON'T_USE_PLUGIN-REGISTRY")};
    }

    private static List<String> getGlobalOptions() {
        return Arrays.asList(AVAILABLE_OPTIONS);
    }

    private void initEmbeddedVersion() {
        this.lblEmbeddedVersion.setText(NbBundle.getMessage(SettingsPanel.class, (String)"LBL_MavenVersion2", (Object)"3.0-SNAPSHOT"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initExternalVersion() {
        var1_1 = this.txtCommandLine.getText().trim();
        if (var1_1.length() == 0) {
            var2_2 = MavenSettings.getDefaultMavenInstanceVersion();
            if (var2_2 != null) {
                this.lblExternalVersion.setText(NbBundle.getMessage(SettingsPanel.class, (String)"LBL_ExMavenVersion3", (Object)var2_2));
                return;
            }
            this.lblExternalVersion.setText(var2_2 != null ? var2_2 : "");
            return;
        }
        var2_3 = new File(var1_1);
        var3_4 = new File(var2_3, "lib");
        if (var3_4.exists()) {
            for (File var8_9 : var4_5 = var3_4.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".jar");
                }
            })) {
                block15: {
                    var9_10 = null;
                    try {
                        try {
                            var9_10 = new JarFile(var8_9);
                            var10_11 = var9_10.getEntry("META-INF/maven/org.apache.maven/maven-core/pom.properties");
                            if (var10_11 == null) break block15;
                            var11_15 = var9_10.getInputStream(var10_11);
                            var12_16 = new Properties();
                            var12_16.load(var11_15);
                            if (var12_16.getProperty("builtOn") != null) {
                                this.lblExternalVersion.setText(NbBundle.getMessage(SettingsPanel.class, (String)"LBL_ExMavenVersion1", (Object)var12_16.getProperty("version", "unknown"), (Object)var12_16.getProperty("builtOn")));
                            } else {
                                this.lblExternalVersion.setText(NbBundle.getMessage(SettingsPanel.class, (String)"LBL_ExMavenVersion2", (Object)var12_16.getProperty("version", "unknown")));
                            }
                            var14_13 = null;
                            if (var9_10 == null) return;
                        }
                        catch (IOException var10_12) {
                            var14_13 = null;
                            if (var9_10 == null) continue;
                            try {
                                var9_10.close();
                            }
                            catch (IOException var15_14) {}
                            continue;
                        }
                    }
                    catch (Throwable var13_17) {
                        var14_13 = null;
                        if (var9_10 == null) throw var13_17;
                        ** try [egrp 2[TRYBLOCK] [5 : 284->292)] { 
lbl44:
                        // 1 sources

                        var9_10.close();
                        throw var13_17;
lbl46:
                        // 1 sources

                        catch (IOException var15_14) {
                            // empty catch block
                        }
                        throw var13_17;
                    }
                    ** try [egrp 2[TRYBLOCK] [5 : 284->292)] { 
lbl51:
                    // 1 sources

                    var9_10.close();
                    return;
lbl53:
                    // 1 sources

                    catch (IOException var15_14) {
                        // empty catch block
                    }
                    return;
                }
                var14_13 = null;
                if (var9_10 == null) continue;
                try {}
                catch (IOException var15_14) {}
                var9_10.close();
            }
        }
        this.lblExternalVersion.setText(NbBundle.getMessage(SettingsPanel.class, (String)"ERR_NoValidInstallation"));
    }

    private void initValues() {
        this.comIndex.setSelectedIndex(0);
        this.cbSnapshots.setSelected(true);
    }

    private void documentChanged(DocumentEvent documentEvent) {
        File file;
        this.changed = true;
        boolean bl = this.valid;
        this.valid = this.txtCommandLine.getText().trim().length() > 0 ? (file = new File(this.txtCommandLine.getText())).exists() && new File(file, "bin" + File.separator + "mvn").exists() : true;
        if (bl != this.valid) {
            this.controller.firePropChange("valid", bl, this.valid);
        }
        this.initExternalVersion();
    }

    private ComboBoxModel createComboModel() {
        return new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(SettingsPanel.class, (String)"FREQ_weekly"), NbBundle.getMessage(SettingsPanel.class, (String)"FREQ_Daily"), NbBundle.getMessage(SettingsPanel.class, (String)"FREQ_Always"), NbBundle.getMessage(SettingsPanel.class, (String)"FREQ_Never")});
    }

    private void initComponents() {
        this.bgChecksums = new ButtonGroup();
        this.bgPlugins = new ButtonGroup();
        this.bgFailure = new ButtonGroup();
        this.lblCommandLine = new JLabel();
        this.txtCommandLine = new JTextField();
        this.btnCommandLine = new JButton();
        this.lblExternalVersion = new JLabel();
        this.lblOptions = new JLabel();
        this.txtOptions = new JTextField();
        this.btnOptions = new JButton();
        this.cbSkipTests = new JCheckBox();
        this.lblLocalRepository = new JLabel();
        this.txtLocalRepository = new MyJTextField();
        this.btnLocalRepository = new JButton();
        this.lblEmbeddedVersion = new JLabel();
        this.lblBinaries = new JLabel();
        this.comBinaries = new JComboBox();
        this.lblJavadoc = new JLabel();
        this.comJavadoc = new JComboBox();
        this.lblSource = new JLabel();
        this.comSource = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.btnGoals = new JButton();
        this.lblIndex = new JLabel();
        this.comIndex = new JComboBox();
        this.btnIndex = new JButton();
        this.cbSnapshots = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.lblCommandLine, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblCommandLine.text"));
        this.txtCommandLine.setText(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.txtCommandLine.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCommandLine, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.btnCommandLine.text"));
        this.btnCommandLine.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.btnCommandLineActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblExternalVersion, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblExternalVersion.text", (Object[])new Object[0]));
        Mnemonics.setLocalizedText((JLabel)this.lblOptions, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblOptions.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnOptions, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.btnOptions.text"));
        this.btnOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.btnOptionsActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbSkipTests, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbSkipTests.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblLocalRepository, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblLocalRepository.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLocalRepository, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.btnLocalRepository.text"));
        this.btnLocalRepository.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.btnLocalRepositoryActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblEmbeddedVersion, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblEmbeddedVersion.text"));
        this.lblBinaries.setLabelFor(this.comBinaries);
        Mnemonics.setLocalizedText((JLabel)this.lblBinaries, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblBinaries.text"));
        this.lblJavadoc.setLabelFor(this.comJavadoc);
        Mnemonics.setLocalizedText((JLabel)this.lblJavadoc, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblJavadoc.text"));
        this.lblSource.setLabelFor(this.comSource);
        Mnemonics.setLocalizedText((JLabel)this.lblSource, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblSource.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.jLabel3.text"));
        this.jLabel3.setVerticalAlignment(1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnGoals, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.btnGoals.text"));
        this.btnGoals.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.btnGoalsActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblIndex, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblIndex.text"));
        this.comIndex.setModel(this.createComboModel());
        Mnemonics.setLocalizedText((AbstractButton)this.btnIndex, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.btnIndex.text"));
        this.btnIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.btnIndexActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbSnapshots, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbSnapshots.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblCommandLine).add((Component)this.lblOptions).add((Component)this.lblLocalRepository)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblEmbeddedVersion, -1, 470, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.txtCommandLine, -1, 387, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnCommandLine)).add((Component)this.lblExternalVersion, -1, 470, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.comSource, 0, 387, Short.MAX_VALUE).add((Component)this.comJavadoc, 0, 387, Short.MAX_VALUE).add((Component)this.comBinaries, 0, 387, Short.MAX_VALUE).add((Component)this.txtLocalRepository, -1, 387, Short.MAX_VALUE).add((Component)this.txtOptions, -1, 387, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.btnLocalRepository).add((Component)this.btnOptions))).add((Component)this.cbSkipTests))).add((Component)this.jLabel1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblJavadoc).add((Component)this.lblBinaries).add((Component)this.lblSource).add((Component)this.jLabel3, -1, 531, Short.MAX_VALUE)).add(106, 106, 106)).add((Component)this.btnGoals).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblIndex).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbSnapshots).add((Component)this.comIndex, 0, 391, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.btnIndex))).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.btnCommandLine, this.btnIndex, this.btnLocalRepository, this.btnOptions}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblEmbeddedVersion).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblCommandLine).add((Component)this.txtCommandLine, -2, -1, -2).add((Component)this.btnCommandLine)).addPreferredGap(0).add((Component)this.lblExternalVersion, -2, 14, -2).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblOptions).add((Component)this.txtOptions, -2, -1, -2).add((Component)this.btnOptions)).addPreferredGap(0).add((Component)this.cbSkipTests).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.txtLocalRepository, -2, -1, -2).add((Component)this.btnLocalRepository).add((Component)this.lblLocalRepository)).add(16, 16, 16).add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblBinaries).add((Component)this.comBinaries, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblJavadoc).add((Component)this.comJavadoc, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblSource).add((Component)this.comSource, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabel3, -2, 44, -2).addPreferredGap(1).add((Component)this.btnGoals).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.btnIndex).add((Component)this.lblIndex).add((Component)this.comIndex, -2, -1, -2)).addPreferredGap(0).add((Component)this.cbSnapshots).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void btnIndexActionPerformed(ActionEvent actionEvent) {
        this.btnIndex.setEnabled(false);
        new RequestProcessor("Maven Repo Index Transfer/Scan").post(new Runnable(){

            public void run() {
                RepositoryInfo repositoryInfo = RepositoryPreferences.getInstance().getRepositoryInfoById("local");
                if (repositoryInfo != null) {
                    RepositoryIndexer.indexRepo((RepositoryInfo)repositoryInfo);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SettingsPanel.this.btnIndex.setEnabled(true);
                        }
                    });
                }
            }
        });
    }

    private void btnLocalRepositoryActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setDialogTitle(NbBundle.getMessage(SettingsPanel.class, (String)"TIT_Select"));
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setFileHidingEnabled(false);
        String string = ((MyJTextField)this.txtLocalRepository).getRealText();
        if (string.trim().length() == 0) {
            string = new File(System.getProperty("user.home"), ".m2").getAbsolutePath();
        }
        if (string.length() > 0 && (file = new File(string)).exists()) {
            jFileChooser.setSelectedFile(file);
        }
        if (0 == jFileChooser.showOpenDialog(this)) {
            file = jFileChooser.getSelectedFile();
            ((MyJTextField)this.txtLocalRepository).setRealText(FileUtil.normalizeFile((File)file).getAbsolutePath());
        }
    }

    private void btnCommandLineActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setDialogTitle(NbBundle.getMessage(SettingsPanel.class, (String)"TIT_Select2"));
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setFileHidingEnabled(false);
        String string = this.txtCommandLine.getText();
        if (string.trim().length() == 0) {
            string = new File(System.getProperty("user.home")).getAbsolutePath();
        }
        if (string.length() > 0 && (file = new File(string)).exists()) {
            jFileChooser.setSelectedFile(file);
        }
        if (0 == jFileChooser.showOpenDialog(this)) {
            file = jFileChooser.getSelectedFile();
            this.txtCommandLine.setText(FileUtil.normalizeFile((File)file).getAbsolutePath());
        }
    }

    private void btnGoalsActionPerformed(ActionEvent actionEvent) {
        NbGlobalActionGoalProvider nbGlobalActionGoalProvider = null;
        for (Object object : Lookup.getDefault().lookupAll(MavenActionsProvider.class)) {
            if (!(object instanceof NbGlobalActionGoalProvider)) continue;
            nbGlobalActionGoalProvider = (NbGlobalActionGoalProvider)object;
        }
        assert (nbGlobalActionGoalProvider != null);
        try {
            Object object;
            ActionToGoalMapping actionToGoalMapping = new NetbeansBuildActionXpp3Reader().read(new StringReader(nbGlobalActionGoalProvider.getRawMappingsAsString()));
            object = new ActionMappings(actionToGoalMapping);
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            ((JPanel)object).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SettingsPanel.class, (String)"ACSD_Global"));
            DialogDescriptor dialogDescriptor = new DialogDescriptor(object, NbBundle.getMessage(SettingsPanel.class, (String)"TIT_Global"));
            Object object2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (object2 == DialogDescriptor.OK_OPTION) {
                FileObject fileObject = FileUtil.getConfigFile((String)"Projects/org-netbeans-modules-maven");
                CustomizerProviderImpl.writeNbActionsModel(fileObject, actionToGoalMapping, M2Configuration.getFileNameExt(M2Configuration.DEFAULT));
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    private void btnOptionsActionPerformed(ActionEvent actionEvent) {
        GlobalOptionsPanel globalOptionsPanel = new GlobalOptionsPanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)globalOptionsPanel, NbBundle.getMessage(SettingsPanel.class, (String)"TIT_Add_Globals"));
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == DialogDescriptor.OK_OPTION) {
            this.txtOptions.setText(this.txtOptions.getText() + globalOptionsPanel.getSelectedOnes());
        }
    }

    public void setValues() {
        this.txtOptions.setText(MavenSettings.getDefault().getDefaultOptions());
        this.txtCommandLine.getDocument().removeDocumentListener(this.docList);
        File file = MavenSettings.getDefault().getCommandLinePath();
        this.txtCommandLine.setText(file != null ? file.getAbsolutePath() : "");
        this.initExternalVersion();
        this.txtCommandLine.getDocument().addDocumentListener(this.docList);
        this.cbSnapshots.setSelected(RepositoryPreferences.getInstance().isIncludeSnapshots());
        this.comIndex.setSelectedIndex(RepositoryPreferences.getInstance().getIndexUpdateFrequency());
        String string = MavenSettings.getDefault().getCustomLocalRepository();
        ((MyJTextField)this.txtLocalRepository).setRealText(string != null ? string : "");
        this.comBinaries.setSelectedItem((Object)MavenSettings.getDefault().getBinaryDownloadStrategy());
        this.comJavadoc.setSelectedItem((Object)MavenSettings.getDefault().getJavadocDownloadStrategy());
        this.comSource.setSelectedItem((Object)MavenSettings.getDefault().getSourceDownloadStrategy());
        this.cbSkipTests.setSelected(MavenSettings.getDefault().isSkipTests());
        this.changed = false;
    }

    public void applyValues() {
        File file;
        MavenSettings.getDefault().setDefaultOptions(this.txtOptions.getText().trim());
        MavenSettings.getDefault().setCustomLocalRepository(((MyJTextField)this.txtLocalRepository).getRealText());
        String string = this.txtCommandLine.getText().trim();
        if (string.length() == 0) {
            string = null;
        }
        File file2 = file = string != null ? new File(string) : null;
        if (file != null && file.exists()) {
            MavenSettings.getDefault().setCommandLinePath(file);
        } else {
            MavenSettings.getDefault().setCommandLinePath(null);
        }
        RepositoryPreferences.getInstance().setIndexUpdateFrequency(this.comIndex.getSelectedIndex());
        RepositoryPreferences.getInstance().setIncludeSnapshots(this.cbSnapshots.isSelected());
        MavenSettings.getDefault().setBinaryDownloadStrategy((MavenSettings.DownloadStrategy)((Object)this.comBinaries.getSelectedItem()));
        MavenSettings.getDefault().setJavadocDownloadStrategy((MavenSettings.DownloadStrategy)((Object)this.comJavadoc.getSelectedItem()));
        MavenSettings.getDefault().setSourceDownloadStrategy((MavenSettings.DownloadStrategy)((Object)this.comSource.getSelectedItem()));
        MavenSettings.getDefault().setSkipTests(this.cbSkipTests.isSelected());
        this.changed = false;
    }

    boolean hasValidValues() {
        return this.valid;
    }

    boolean hasChangedValues() {
        return this.changed;
    }

    private class ActionListenerImpl
    implements ActionListener {
        private ActionListenerImpl() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SettingsPanel.this.changed = true;
        }
    }
}

