/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import hidden.org.codehaus.plexus.util.StringUtils;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.exec.ProgressTransferListener;
import org.netbeans.modules.maven.nodes.AddDependencyPanel;
import org.netbeans.modules.maven.nodes.DependencyNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

public class DependenciesNode
extends AbstractNode {
    static final int TYPE_COMPILE = 0;
    static final int TYPE_TEST = 1;
    static final int TYPE_RUNTIME = 2;
    private static final String SHOW_NONCLASSPATH_DEPENDENCIES = "show.nonclasspath.dependencies";
    private static final String SHOW_MANAGED_DEPENDENCIES = "show.managed.dependencies";
    public static final String PREF_DEPENDENCIES_UI = "org/netbeans/modules/maven/dependencies/ui";
    private NbMavenProjectImpl project;
    private int type;
    private static final DependencyWrapper NULL = new DependencyWrapper(null, null);
    private static final String ICON_KEY_UIMANAGER = "Tree.closedIcon";
    private static final String OPENED_ICON_KEY_UIMANAGER = "Tree.openIcon";
    private static final String ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.icon";
    private static final String OPENED_ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.openedIcon";
    private static final String ICON_PATH = "org/netbeans/modules/maven/defaultFolder.gif";
    private static final String OPENED_ICON_PATH = "org/netbeans/modules/maven/defaultFolderOpen.gif";

    DependenciesNode(DependenciesChildren dependenciesChildren, NbMavenProjectImpl nbMavenProjectImpl, int n) {
        super((Children)dependenciesChildren, Lookups.fixed((Object[])new Object[]{nbMavenProjectImpl}));
        this.setName("Dependencies" + n);
        this.type = n;
        switch (n) {
            case 0: {
                this.setDisplayName(NbBundle.getMessage(DependenciesNode.class, (String)"LBL_Libraries"));
                break;
            }
            case 1: {
                this.setDisplayName(NbBundle.getMessage(DependenciesNode.class, (String)"LBL_Test_Libraries"));
                break;
            }
            case 2: {
                this.setDisplayName(NbBundle.getMessage(DependenciesNode.class, (String)"LBL_Runtime_Libraries"));
                break;
            }
            default: {
                this.setDisplayName(NbBundle.getMessage(DependenciesNode.class, (String)"LBL_Libraries"));
            }
        }
        this.project = nbMavenProjectImpl;
        this.setIconBaseWithExtension(ICON_PATH);
    }

    public Image getIcon(int n) {
        Image image = ImageUtilities.mergeImages((Image)DependenciesNode.getTreeFolderIcon(false), (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/libraries-badge.png"), (int)8, (int)8);
        return image;
    }

    public Image getOpenedIcon(int n) {
        Image image = ImageUtilities.mergeImages((Image)DependenciesNode.getTreeFolderIcon(true), (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/libraries-badge.png"), (int)8, (int)8);
        return image;
    }

    public Action[] getActions(boolean bl) {
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        arrayList.add(new AddDependencyAction());
        arrayList.add(null);
        arrayList.add(new ResolveDepsAction(this.project));
        arrayList.add(new DownloadJavadocSrcAction(true));
        arrayList.add(new DownloadJavadocSrcAction(false));
        arrayList.addAll(Utilities.actionsForPath((String)"Projects/org-netbeans-modules-maven/DependenciesActions"));
        arrayList.add(null);
        arrayList.add(new ShowClasspathDepsAction());
        arrayList.add(new ShowManagedStateAction());
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private static boolean showNonClasspath() {
        Preferences preferences = NbPreferences.root().node(PREF_DEPENDENCIES_UI);
        boolean bl = preferences.getBoolean(SHOW_NONCLASSPATH_DEPENDENCIES, false);
        return bl;
    }

    static boolean showManagedState() {
        Preferences preferences = NbPreferences.root().node(PREF_DEPENDENCIES_UI);
        boolean bl = preferences.getBoolean(SHOW_MANAGED_DEPENDENCIES, false);
        return bl;
    }

    public static Image getTreeFolderIcon(boolean bl) {
        Image image = null;
        Icon icon = UIManager.getIcon(bl ? OPENED_ICON_KEY_UIMANAGER : ICON_KEY_UIMANAGER);
        if (icon != null) {
            image = ImageUtilities.icon2Image((Icon)icon);
        } else {
            image = (Image)UIManager.get(bl ? OPENED_ICON_KEY_UIMANAGER_NB : ICON_KEY_UIMANAGER_NB);
            if (image == null) {
                image = ImageUtilities.loadImage((String)(bl ? OPENED_ICON_PATH : ICON_PATH), (boolean)true);
            }
        }
        assert (image != null);
        return image;
    }

    private static class ExpandAction
    extends AbstractAction {
        private DependenciesChildren parent;

        public ExpandAction(DependenciesChildren dependenciesChildren) {
            this.parent = dependenciesChildren;
            this.putValue("Name", NbBundle.getMessage(DependenciesNode.class, (String)"LBL_Expand"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.parent.showNonCP();
        }
    }

    private static class NonCPNode
    extends AbstractNode {
        private DependenciesChildren parent;

        NonCPNode(int n, DependenciesChildren dependenciesChildren) {
            super(Children.LEAF);
            this.parent = dependenciesChildren;
            if (n == 1) {
                this.setDisplayName(NbBundle.getMessage(DependenciesNode.class, (String)"LBL_NonCPCount1"));
            } else {
                this.setDisplayName(NbBundle.getMessage(DependenciesNode.class, (String)"LBL_NonCPCount2", (Object)n));
            }
        }

        public Action getPreferredAction() {
            return new ExpandAction(this.parent);
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{new ExpandAction(this.parent)};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DependenciesComparator
    implements Comparator<DependencyWrapper> {
        private DependenciesComparator() {
        }

        @Override
        public int compare(DependencyWrapper dependencyWrapper, DependencyWrapper dependencyWrapper2) {
            boolean bl;
            if (dependencyWrapper == NULL && dependencyWrapper2 == NULL) {
                return 0;
            }
            if (dependencyWrapper == NULL) {
                return -1;
            }
            if (dependencyWrapper2 == NULL) {
                return 1;
            }
            boolean bl2 = dependencyWrapper.getArtifact().getDependencyTrail().size() > 2;
            boolean bl3 = bl = dependencyWrapper2.getArtifact().getDependencyTrail().size() > 2;
            if (bl2 && !bl) {
                return 1;
            }
            if (!bl2 && bl) {
                return -1;
            }
            int n = dependencyWrapper.getArtifact().getArtifactId().compareTo(dependencyWrapper2.getArtifact().getArtifactId());
            if (n != 0) {
                return n;
            }
            return dependencyWrapper.getArtifact().compareTo((Object)dependencyWrapper2.getArtifact());
        }
    }

    private class ShowManagedStateAction
    extends AbstractAction
    implements Presenter.Popup {
        public ShowManagedStateAction() {
            String string = NbBundle.getMessage(DependenciesNode.class, (String)"LBL_ShowManagedState");
            this.putValue("Name", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = DependenciesNode.showManagedState();
            Preferences preferences = NbPreferences.root().node(DependenciesNode.PREF_DEPENDENCIES_UI);
            preferences.putBoolean(DependenciesNode.SHOW_MANAGED_DEPENDENCIES, !bl);
            try {
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                Exceptions.printStackTrace((Throwable)backingStoreException);
            }
            for (Node node : DependenciesNode.this.getChildren().getNodes(true)) {
                if (!(node instanceof DependencyNode)) continue;
                ((DependencyNode)node).refreshNode();
            }
        }

        public JMenuItem getPopupPresenter() {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this);
            jCheckBoxMenuItem.setSelected(DependenciesNode.showManagedState());
            return jCheckBoxMenuItem;
        }
    }

    private static class ShowClasspathDepsAction
    extends AbstractAction
    implements Presenter.Popup {
        public ShowClasspathDepsAction() {
            String string = NbBundle.getMessage(DependenciesNode.class, (String)"LBL_ShowNonClasspath");
            this.putValue("Name", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = DependenciesNode.showNonClasspath();
            Preferences preferences = NbPreferences.root().node(DependenciesNode.PREF_DEPENDENCIES_UI);
            preferences.putBoolean(DependenciesNode.SHOW_NONCLASSPATH_DEPENDENCIES, !bl);
            try {
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                Exceptions.printStackTrace((Throwable)backingStoreException);
            }
        }

        public JMenuItem getPopupPresenter() {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this);
            jCheckBoxMenuItem.setSelected(DependenciesNode.showNonClasspath());
            return jCheckBoxMenuItem;
        }
    }

    public static class ResolveDepsAction
    extends AbstractAction {
        private Project project;

        public ResolveDepsAction(Project project) {
            this.putValue("Name", NbBundle.getMessage(DependenciesNode.class, (String)"LBL_Download"));
            this.project = project;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(false);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ((NbMavenProject)ResolveDepsAction.this.project.getLookup().lookup(NbMavenProject.class)).downloadDependencyAndJavadocSource();
                }
            });
        }
    }

    private class DownloadJavadocSrcAction
    extends AbstractAction {
        private boolean javadoc;

        public DownloadJavadocSrcAction(boolean bl) {
            this.putValue("Name", bl ? NbBundle.getMessage(DependenciesNode.class, (String)"LBL_Download_Javadoc") : NbBundle.getMessage(DependenciesNode.class, (String)"LBL_Download__Sources"));
            this.javadoc = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    MavenEmbedder mavenEmbedder = EmbedderFactory.getOnlineEmbedder();
                    Node[] nodeArray = DependenciesNode.this.getChildren().getNodes();
                    ProgressContributor[] progressContributorArray = new ProgressContributor[nodeArray.length];
                    for (int i = 0; i < nodeArray.length; ++i) {
                        progressContributorArray[i] = AggregateProgressFactory.createProgressContributor((String)("multi-" + i));
                    }
                    String string = DownloadJavadocSrcAction.this.javadoc ? NbBundle.getMessage(DependenciesNode.class, (String)"Progress_Javadoc") : NbBundle.getMessage(DependenciesNode.class, (String)"Progress_Source");
                    AggregateProgressHandle aggregateProgressHandle = AggregateProgressFactory.createHandle((String)string, (ProgressContributor[])progressContributorArray, null, null);
                    aggregateProgressHandle.start();
                    try {
                        ProgressTransferListener.setAggregateHandle((AggregateProgressHandle)aggregateProgressHandle);
                        for (int i = 0; i < nodeArray.length; ++i) {
                            if (!(nodeArray[i] instanceof DependencyNode)) continue;
                            DependencyNode dependencyNode = (DependencyNode)nodeArray[i];
                            if (DownloadJavadocSrcAction.this.javadoc && !dependencyNode.hasJavadocInRepository()) {
                                dependencyNode.downloadJavadocSources(mavenEmbedder, progressContributorArray[i], DownloadJavadocSrcAction.this.javadoc);
                                continue;
                            }
                            if (!DownloadJavadocSrcAction.this.javadoc && !dependencyNode.hasSourceInRepository()) {
                                dependencyNode.downloadJavadocSources(mavenEmbedder, progressContributorArray[i], DownloadJavadocSrcAction.this.javadoc);
                                continue;
                            }
                            progressContributorArray[i].finish();
                        }
                        Object var9_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        aggregateProgressHandle.finish();
                        ProgressTransferListener.clearAggregateHandle();
                        throw throwable;
                    }
                    aggregateProgressHandle.finish();
                    ProgressTransferListener.clearAggregateHandle();
                }
            });
        }
    }

    private class AddDependencyAction
    extends AbstractAction {
        public AddDependencyAction() {
            this.putValue("Name", NbBundle.getMessage(DependenciesNode.class, (String)"BTN_Add_Library"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AddDependencyPanel addDependencyPanel = new AddDependencyPanel(DependenciesNode.this.project.getOriginalMavenProject(), DependenciesNode.this.project);
            String string = DependenciesNode.this.type == 2 ? "runtime" : (DependenciesNode.this.type == 1 ? "test" : "compile");
            addDependencyPanel.setSelectedScope(string);
            addDependencyPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DependenciesNode.class, (String)"TIT_Add_Library"));
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addDependencyPanel, NbBundle.getMessage(DependenciesNode.class, (String)"TIT_Add_Library"));
            dialogDescriptor.setClosingOptions(new Object[]{addDependencyPanel.getOkButton(), DialogDescriptor.CANCEL_OPTION});
            dialogDescriptor.setOptions(new Object[]{addDependencyPanel.getOkButton(), DialogDescriptor.CANCEL_OPTION});
            addDependencyPanel.attachDialogDisplayer(dialogDescriptor);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (addDependencyPanel.getOkButton() == object) {
                String string2 = addDependencyPanel.getVersion();
                if (string2 != null && string2.trim().length() == 0) {
                    string2 = null;
                }
                ModelUtils.addDependency(DependenciesNode.this.project.getProjectDirectory().getFileObject("pom.xml"), addDependencyPanel.getGroupId(), addDependencyPanel.getArtifactId(), string2, null, addDependencyPanel.getScope(), null, false);
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        ((NbMavenProject)DependenciesNode.this.project.getLookup().lookup(NbMavenProject.class)).downloadDependencyAndJavadocSource();
                    }
                });
            }
        }
    }

    private static class DependencyWrapper {
        private Artifact artifact;
        private Dependency dependency;

        public DependencyWrapper(Artifact artifact, Dependency dependency) {
            this.artifact = artifact;
            this.dependency = dependency;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public Dependency getDependency() {
            return this.dependency;
        }

        public boolean equals(Object object) {
            if (this == NULL && object == NULL) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            DependencyWrapper dependencyWrapper = (DependencyWrapper)object;
            return this.artifact == dependencyWrapper.artifact || this.artifact != null && this.artifact.equals(dependencyWrapper.artifact);
        }

        public int hashCode() {
            int n = 7;
            if (this == NULL) {
                return n;
            }
            n = 23 * n + (this.artifact != null ? this.artifact.hashCode() : 0);
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DependenciesChildren
    extends Children.Keys<DependencyWrapper>
    implements PropertyChangeListener,
    PreferenceChangeListener {
        private NbMavenProjectImpl project;
        private int type;
        boolean showNonCP = false;
        int nonCPcount = 0;

        public DependenciesChildren(NbMavenProjectImpl nbMavenProjectImpl, int n) {
            this.project = nbMavenProjectImpl;
            this.type = n;
        }

        public void showNonCP() {
            this.showNonCP = true;
            this.regenerateKeys();
            this.refresh();
            this.refreshKey(NULL);
        }

        protected Node[] createNodes(DependencyWrapper dependencyWrapper) {
            if (dependencyWrapper == NULL) {
                return new Node[]{new NonCPNode(this.nonCPcount, this)};
            }
            Lookup lookup = Lookups.fixed((Object[])new Object[]{dependencyWrapper.getArtifact(), dependencyWrapper.getDependency(), this.project});
            return new Node[]{new DependencyNode(lookup, true)};
        }

        Node getParentNode() {
            return this.getNode();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
                this.regenerateKeys();
                this.refresh();
                this.refreshKey(NULL);
            }
        }

        protected void addNotify() {
            super.addNotify();
            NbMavenProject.addPropertyChangeListener(this.project, this);
            Preferences preferences = NbPreferences.root().node(DependenciesNode.PREF_DEPENDENCIES_UI);
            preferences.addPreferenceChangeListener(this);
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptyList());
            NbMavenProject.removePropertyChangeListener(this.project, this);
            Preferences preferences = NbPreferences.root().node(DependenciesNode.PREF_DEPENDENCIES_UI);
            preferences.removePreferenceChangeListener(this);
            super.removeNotify();
        }

        int regenerateKeys() {
            int n;
            TreeSet<DependencyWrapper> treeSet = new TreeSet<DependencyWrapper>(new DependenciesComparator());
            MavenProject mavenProject = this.project.getOriginalMavenProject();
            if (this.type == 0) {
                treeSet.addAll(this.create(mavenProject.getCompileDependencies(), mavenProject.getArtifacts()));
                if (this.nonCPcount > 0) {
                    treeSet.add(NULL);
                }
            }
            if (this.type == 1) {
                treeSet.addAll(this.create(mavenProject.getTestDependencies(), mavenProject.getArtifacts()));
                n = this.nonCPcount;
                this.nonCPcount = 0;
                treeSet.removeAll(this.create(mavenProject.getCompileDependencies(), mavenProject.getArtifacts()));
                treeSet.removeAll(this.create(mavenProject.getRuntimeDependencies(), mavenProject.getArtifacts()));
                this.nonCPcount = (n -= this.nonCPcount) - this.nonCPcount;
                if (this.nonCPcount <= 0) {
                    treeSet.remove(NULL);
                } else {
                    treeSet.add(NULL);
                }
            }
            if (this.type == 2) {
                treeSet.addAll(this.create(mavenProject.getRuntimeDependencies(), mavenProject.getArtifacts()));
                n = this.nonCPcount;
                this.nonCPcount = 0;
                treeSet.removeAll(this.create(mavenProject.getCompileDependencies(), mavenProject.getArtifacts()));
                this.nonCPcount = n - this.nonCPcount;
                if (this.nonCPcount <= 0) {
                    treeSet.remove(NULL);
                } else {
                    treeSet.add(NULL);
                }
            }
            this.setKeys(treeSet);
            return treeSet.size();
        }

        private Set<DependencyWrapper> create(Collection<Dependency> collection, Collection<Artifact> collection2) {
            boolean bl = DependenciesNode.showNonClasspath() || this.showNonCP;
            int n = 0;
            TreeSet<DependencyWrapper> treeSet = new TreeSet<DependencyWrapper>(new DependenciesComparator());
            for (Dependency dependency : collection) {
                boolean bl2 = false;
                for (Artifact artifact : collection2) {
                    if (!artifact.getGroupId().equals(dependency.getGroupId()) || !artifact.getArtifactId().equals(dependency.getArtifactId()) || !StringUtils.equals((String)artifact.getClassifier(), (String)dependency.getClassifier())) continue;
                    if (bl || artifact.getArtifactHandler().isAddedToClasspath()) {
                        treeSet.add(new DependencyWrapper(artifact, dependency));
                    } else {
                        ++n;
                    }
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                System.out.println("not found artifact for " + dependency);
            }
            this.nonCPcount = n;
            return treeSet;
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            if (DependenciesNode.SHOW_NONCLASSPATH_DEPENDENCIES.equals(preferenceChangeEvent.getKey())) {
                this.regenerateKeys();
            }
        }
    }
}

