/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.debug;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.classpath.BootClassPathImpl;
import org.netbeans.modules.maven.spi.debug.AdditionalDebuggedProjects;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private Utils() {
    }

    static MethodBreakpoint createBreakpoint(String string) {
        MethodBreakpoint methodBreakpoint = MethodBreakpoint.create((String)string, (String)"*");
        methodBreakpoint.setHidden(true);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)methodBreakpoint);
        return methodBreakpoint;
    }

    public static File[] convertStringsToNormalizedFiles(Collection<String> collection) {
        File[] fileArray = new File[collection.size()];
        int n = 0;
        for (String string : collection) {
            File file = new File(string);
            fileArray[n] = file = FileUtil.normalizeFile((File)file);
            ++n;
        }
        return fileArray;
    }

    static Set<String> collectClasspaths(Project project) throws DependencyResolutionRequiredException {
        HashSet<String> hashSet = new HashSet<String>();
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        MavenProject mavenProject = nbMavenProject.getMavenProject();
        hashSet.addAll(mavenProject.getTestClasspathElements());
        boolean bl = "pom".equals(nbMavenProject.getPackagingType());
        if (bl) {
            SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
            Set set = subprojectProvider.getSubprojects();
            for (Project project2 : set) {
                hashSet.addAll(Utils.collectClasspaths(project2));
            }
        }
        return hashSet;
    }

    static Set<String> collectSourceRoots(Project project) {
        HashSet<String> hashSet = new HashSet<String>();
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        MavenProject mavenProject = nbMavenProject.getMavenProject();
        hashSet.addAll(mavenProject.getTestCompileSourceRoots());
        boolean bl = "pom".equals(nbMavenProject.getPackagingType());
        if (bl) {
            SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
            Set set = subprojectProvider.getSubprojects();
            for (Project project2 : set) {
                hashSet.addAll(Utils.collectSourceRoots(project2));
            }
        }
        return hashSet;
    }

    static ClassPath createSourcePath(Project project) {
        ClassPath classPath;
        Project project22;
        AdditionalDebuggedProjects additionalDebuggedProjects;
        Set<String> set;
        File[] fileArray = new File[]{};
        try {
            set = Utils.collectClasspaths(project);
            additionalDebuggedProjects = (AdditionalDebuggedProjects)project.getLookup().lookup(AdditionalDebuggedProjects.class);
            if (additionalDebuggedProjects != null) {
                for (Project project22 : additionalDebuggedProjects.getProjects()) {
                    set.addAll(Utils.collectClasspaths(project22));
                }
            }
            fileArray = Utils.convertStringsToNormalizedFiles(set);
            classPath = Utils.convertToSourcePath(fileArray);
        }
        catch (DependencyResolutionRequiredException dependencyResolutionRequiredException) {
            dependencyResolutionRequiredException.printStackTrace();
            classPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        }
        set = Utils.collectSourceRoots(project);
        additionalDebuggedProjects = (AdditionalDebuggedProjects)project.getLookup().lookup(AdditionalDebuggedProjects.class);
        if (additionalDebuggedProjects != null) {
            for (Project project22 : additionalDebuggedProjects.getProjects()) {
                set.addAll(Utils.collectSourceRoots(project22));
            }
        }
        fileArray = Utils.convertStringsToNormalizedFiles(set);
        ClassPath classPath2 = Utils.convertToClassPath(fileArray);
        project22 = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPath, classPath2});
        return project22;
    }

    static ClassPath createJDKSourcePath(Project project) {
        String string = ((AuxiliaryProperties)project.getLookup().lookup(AuxiliaryProperties.class)).get("netbeans.hint.jdkPlatform", true);
        JavaPlatform javaPlatform = BootClassPathImpl.getActivePlatform(string);
        if (javaPlatform == null) {
            javaPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        }
        return javaPlatform.getSourceFolders();
    }

    private static ClassPath convertToClassPath(File[] fileArray) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (int i = 0; i < fileArray.length; ++i) {
            URL uRL = Utils.fileToURL(fileArray[i]);
            arrayList.add(uRL);
        }
        URL[] uRLArray = arrayList.toArray(new URL[arrayList.size()]);
        return ClassPathSupport.createClassPath((URL[])uRLArray);
    }

    private static ClassPath convertToSourcePath(File[] fileArray) {
        ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
        HashSet<URL> hashSet = new HashSet<URL>();
        for (int i = 0; i < fileArray.length; ++i) {
            URL uRL = Utils.fileToURL(fileArray[i]);
            try {
                FileObject[] fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)uRL).getRoots();
                for (int j = 0; j < fileObjectArray.length; ++j) {
                    block8: {
                        if (FileUtil.isArchiveFile((FileObject)fileObjectArray[j])) {
                            fileObjectArray[j] = FileUtil.getArchiveRoot((FileObject)fileObjectArray[j]);
                        }
                        try {
                            uRL = fileObjectArray[j].getURL();
                            if (uRL.toExternalForm().endsWith("/")) break block8;
                            uRL = new URL(uRL.toExternalForm() + "/");
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                            ErrorManager.getDefault().notify(4096, (Throwable)fileStateInvalidException);
                            continue;
                        }
                        catch (MalformedURLException malformedURLException) {
                            ErrorManager.getDefault().notify(4096, (Throwable)malformedURLException);
                            continue;
                        }
                    }
                    if (uRL == null || hashSet.contains(uRL)) continue;
                    arrayList.add(ClassPathSupport.createResource((URL)uRL));
                    hashSet.add(uRL);
                }
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return ClassPathSupport.createClassPath(arrayList);
    }

    static URL fileToURL(File file) {
        try {
            URL uRL = file.toURI().toURL();
            if (FileUtil.isArchiveFile((URL)uRL)) {
                uRL = FileUtil.getArchiveRoot((URL)uRL);
            }
            if (!uRL.toExternalForm().endsWith("/")) {
                uRL = new URL(uRL.toExternalForm() + "/");
            }
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify(4096, (Throwable)malformedURLException);
            return null;
        }
    }
}

