/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.configurations;

import hidden.org.codehaus.plexus.util.StringUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.ProjectProfileHandler;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class M2ConfigProvider
implements ProjectConfigurationProvider<M2Configuration> {
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private NbMavenProjectImpl project;
    private List<M2Configuration> profiles = null;
    private List<M2Configuration> shared = null;
    private List<M2Configuration> nonshared = null;
    private final M2Configuration DEFAULT;
    private M2Configuration active;
    private String initialActive;
    private AuxiliaryConfiguration aux;
    private ProjectProfileHandler profileHandler;
    private PropertyChangeListener propertyChange;
    static String NAMESPACE = "http://www.netbeans.org/ns/maven-config-data/1";
    static String ROOT = "config-data";
    static String ENABLED = "enabled";
    static String ACTIVATED = "activated";
    static String CONFIGURATIONS = "configurations";
    static String CONFIG = "configuration";
    static String PROPERTY = "property";
    static String PROPERTY_NAME_ATTR = "name";
    static String CONFIG_PROFILES_ATTR = "profiles";
    static String CONFIG_ID_ATTR = "id";

    public M2ConfigProvider(NbMavenProjectImpl nbMavenProjectImpl, AuxiliaryConfiguration auxiliaryConfiguration, ProjectProfileHandler projectProfileHandler) {
        NodeList nodeList;
        this.project = nbMavenProjectImpl;
        this.aux = auxiliaryConfiguration;
        this.profileHandler = projectProfileHandler;
        this.DEFAULT = M2Configuration.createDefault(this.project);
        Element element = auxiliaryConfiguration.getConfigurationFragment(ROOT, NAMESPACE, false);
        if (element != null && (nodeList = element.getElementsByTagNameNS(NAMESPACE, ACTIVATED)).getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            this.initialActive = new String(element2.getTextContent());
        }
        this.active = this.DEFAULT;
        this.propertyChange = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
                    M2ConfigProvider m2ConfigProvider = M2ConfigProvider.this;
                    synchronized (m2ConfigProvider) {
                        M2ConfigProvider.this.profiles = null;
                    }
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            M2ConfigProvider.this.checkActiveAgainstAll(M2ConfigProvider.this.getConfigurations(), false);
                            M2ConfigProvider.this.firePropertyChange();
                        }
                    });
                }
            }
        };
    }

    private void checkActiveAgainstAll(Collection<M2Configuration> collection, boolean bl) {
        boolean bl2 = false;
        for (M2Configuration m2Configuration : collection) {
            if (!m2Configuration.getId().equals(this.active.getId())) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        M2ConfigProvider.this.doSetActiveConfiguration(M2ConfigProvider.this.DEFAULT, M2ConfigProvider.this.active);
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                }
            };
            if (bl) {
                RequestProcessor.getDefault().post(runnable);
            } else {
                runnable.run();
            }
        }
    }

    private synchronized Collection<M2Configuration> getConfigurations(boolean bl) {
        if (this.profiles == null && !bl) {
            this.profiles = this.createProfilesList();
        }
        if (this.shared == null) {
            this.shared = this.readConfiguration(true);
        }
        if (this.nonshared == null) {
            this.nonshared = this.readConfiguration(false);
        }
        ArrayList<M2Configuration> arrayList = new ArrayList<M2Configuration>();
        arrayList.add(this.DEFAULT);
        arrayList.addAll(this.shared);
        arrayList.addAll(this.nonshared);
        if (!bl) {
            Iterator<M2Configuration> iterator = this.profiles.iterator();
            while (iterator.hasNext()) {
                M2Configuration m2Configuration = iterator.next();
                if (!arrayList.contains(m2Configuration)) {
                    arrayList.add(m2Configuration);
                    continue;
                }
                iterator.remove();
            }
        }
        return arrayList;
    }

    public synchronized Collection<M2Configuration> getConfigurations() {
        return this.getConfigurations(false);
    }

    public M2Configuration getDefaultConfig() {
        return this.DEFAULT;
    }

    public synchronized Collection<M2Configuration> getProfileConfigurations() {
        this.getConfigurations();
        return this.profiles;
    }

    public synchronized Collection<M2Configuration> getSharedConfigurations() {
        this.getConfigurations();
        return this.shared;
    }

    public synchronized Collection<M2Configuration> getNonSharedConfigurations() {
        this.getConfigurations();
        return this.nonshared;
    }

    public boolean hasCustomizer() {
        return true;
    }

    public void customize() {
        CustomizerProviderImpl customizerProviderImpl = (CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class);
        customizerProviderImpl.showCustomizer("CONFIGURATION");
    }

    public boolean configurationsAffectAction(String string) {
        return !"delete".equals(string) && !"copy".equals(string) && !"move".equals(string);
    }

    public synchronized M2Configuration getActiveConfiguration() {
        Collection<M2Configuration> collection = this.getConfigurations(false);
        if (this.initialActive != null) {
            for (M2Configuration m2Configuration : collection) {
                if (!this.initialActive.equals(m2Configuration.getId())) continue;
                this.active = m2Configuration;
                this.initialActive = null;
                break;
            }
            if (this.initialActive != null) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        try {
                            M2ConfigProvider.this.doSetActiveConfiguration(M2ConfigProvider.this.DEFAULT, null);
                        }
                        catch (Exception exception) {
                            Exceptions.printStackTrace((Throwable)exception);
                        }
                    }
                });
                this.initialActive = null;
            }
        }
        this.checkActiveAgainstAll(collection, true);
        return this.active;
    }

    public synchronized void setConfigurations(List<M2Configuration> list, List<M2Configuration> list2, boolean bl) {
        M2ConfigProvider.writeAuxiliaryData(this.aux, true, list);
        M2ConfigProvider.writeAuxiliaryData(this.aux, false, list2);
        this.shared = list;
        this.nonshared = list2;
        if (this.active != null) {
            M2Configuration m2Configuration;
            if (list.contains(this.active)) {
                this.active = m2Configuration = list.get(list.indexOf(this.active));
            }
            if (list2.contains(this.active)) {
                this.active = m2Configuration = list2.get(list2.indexOf(this.active));
            }
        }
        this.profiles = null;
        this.firePropertyChange();
    }

    public synchronized void setActiveConfiguration(M2Configuration m2Configuration) throws IllegalArgumentException, IOException {
        if (this.active == m2Configuration || this.active != null && this.active.equals(m2Configuration)) {
            return;
        }
        this.doSetActiveConfiguration(m2Configuration, this.active);
        NbMavenProject.fireMavenProjectReload(this.project);
    }

    private synchronized void doSetActiveConfiguration(M2Configuration m2Configuration, M2Configuration m2Configuration2) throws IllegalArgumentException, IOException {
        this.active = m2Configuration;
        M2ConfigProvider.writeAuxiliaryData(this.aux, ACTIVATED, this.active.getId());
        this.support.firePropertyChange("activeConfiguration", m2Configuration2, this.active);
    }

    private List<M2Configuration> createProfilesList() {
        List<String> list = this.profileHandler.getAllProfiles();
        ArrayList<M2Configuration> arrayList = new ArrayList<M2Configuration>();
        for (String string : list) {
            M2Configuration m2Configuration = new M2Configuration(string, this.project);
            m2Configuration.setActivatedProfiles(Collections.singletonList(string));
            arrayList.add(m2Configuration);
        }
        return arrayList;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.support.getPropertyChangeListeners().length == 0) {
            this.project.getProjectWatcher().addPropertyChangeListener(this.propertyChange);
        }
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
        if (this.support.getPropertyChangeListeners().length == 0) {
            this.project.getProjectWatcher().removePropertyChangeListener(this.propertyChange);
        }
    }

    private void firePropertyChange() {
        this.support.firePropertyChange("configurations", null, null);
    }

    private List<M2Configuration> readConfiguration(boolean bl) {
        NodeList nodeList;
        Element element = this.aux.getConfigurationFragment(ROOT, NAMESPACE, bl);
        if (element != null && (nodeList = element.getElementsByTagNameNS(NAMESPACE, CONFIG)).getLength() > 0) {
            ArrayList<M2Configuration> arrayList = new ArrayList<M2Configuration>();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Object object;
                Element element2 = (Element)nodeList.item(i);
                M2Configuration m2Configuration = new M2Configuration(element2.getAttribute(CONFIG_ID_ATTR), this.project);
                String string = element2.getAttribute(CONFIG_PROFILES_ATTR);
                if (string != null) {
                    object = string.split(" ");
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    for (Object object2 : object) {
                        if (((String)object2).trim().length() <= 0) continue;
                        arrayList2.add(((String)object2).trim());
                    }
                    m2Configuration.setActivatedProfiles(arrayList2);
                }
                object = element2.getElementsByTagName(PROPERTY);
                for (int j = 0; j < object.getLength(); ++j) {
                    Element element3 = (Element)object.item(j);
                    String string2 = element3.getAttribute(PROPERTY_NAME_ATTR);
                    String string3 = element3.getTextContent();
                    if (string2 == null || string3 == null) continue;
                    m2Configuration.getProperties().setProperty(string2, string3);
                }
                arrayList.add(m2Configuration);
            }
            return arrayList;
        }
        return new ArrayList<M2Configuration>();
    }

    public static void writeAuxiliaryData(AuxiliaryConfiguration auxiliaryConfiguration, String string, String string2) {
        Element element;
        NodeList nodeList;
        Element element2 = auxiliaryConfiguration.getConfigurationFragment(ROOT, NAMESPACE, false);
        if (element2 == null) {
            element2 = XMLUtil.createDocument((String)ROOT, (String)NAMESPACE, null, null).getDocumentElement();
        }
        if ((nodeList = element2.getElementsByTagNameNS(NAMESPACE, string)).getLength() > 0) {
            element = (Element)nodeList.item(0);
        } else {
            element = element2.getOwnerDocument().createElementNS(NAMESPACE, string);
            element2.appendChild(element);
        }
        element.setTextContent(string2);
        auxiliaryConfiguration.putConfigurationFragment(element2, false);
    }

    private static void writeAuxiliaryData(AuxiliaryConfiguration auxiliaryConfiguration, boolean bl, List<M2Configuration> list) {
        Element element;
        NodeList nodeList;
        Element element2 = auxiliaryConfiguration.getConfigurationFragment(ROOT, NAMESPACE, bl);
        if (element2 == null) {
            element2 = XMLUtil.createDocument((String)ROOT, (String)NAMESPACE, null, null).getDocumentElement();
        }
        if ((nodeList = element2.getElementsByTagNameNS(NAMESPACE, CONFIGURATIONS)).getLength() > 0) {
            element = (Element)nodeList.item(0);
            NodeList nodeList2 = element.getChildNodes();
            int n = nodeList2.getLength();
            for (int i = 0; i < n; ++i) {
                element.removeChild(nodeList2.item(0));
            }
        } else {
            element = element2.getOwnerDocument().createElementNS(NAMESPACE, CONFIGURATIONS);
            element2.appendChild(element);
        }
        for (M2Configuration m2Configuration : list) {
            Element element3 = element.getOwnerDocument().createElementNS(NAMESPACE, CONFIG);
            element3.setAttribute(CONFIG_ID_ATTR, m2Configuration.getId());
            element3.setAttribute(CONFIG_PROFILES_ATTR, StringUtils.join(m2Configuration.getActivatedProfiles().iterator(), (String)" "));
            Enumeration<?> enumeration = m2Configuration.getProperties().propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = m2Configuration.getProperties().getProperty(string);
                if (string == null || string2 == null) continue;
                Element element4 = element.getOwnerDocument().createElementNS(NAMESPACE, PROPERTY);
                element4.setAttribute(PROPERTY_NAME_ATTR, string);
                element4.setTextContent(string2);
                element3.appendChild(element4);
            }
            element.appendChild(element3);
        }
        auxiliaryConfiguration.putConfigurationFragment(element2, bl);
    }
}

