/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.derby.DerbyOptions;
import org.netbeans.modules.derby.JDKDerbyHelper;
import org.netbeans.modules.derby.api.DerbyDatabases;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class Installer
extends ModuleInstall {
    private static final Logger LOGGER = Logger.getLogger(Installer.class.getName());

    public void restored() {
        WindowManager.getDefault().invokeWhenUIReady((Runnable)new RegisterJDKDerby());
    }

    private static final class RegisterJDKDerby
    implements Runnable {
        private final JDKDerbyHelper helper = JDKDerbyHelper.forDefaultPlatform();

        private RegisterJDKDerby() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                RequestProcessor.getDefault().post((Runnable)this);
                return;
            }
            if (!this.helper.canBundleDerby()) {
                LOGGER.fine("Default platform cannot bundle Derby");
                return;
            }
            ProgressHandle progressHandle = ProgressHandleFactory.createSystemHandle((String)NbBundle.getMessage(Installer.class, (String)"MSG_RegisterJavaDB"));
            progressHandle.start();
            try {
                if (this.registerJDKDerby()) {
                    this.registerSampleDatabase();
                }
            }
            finally {
                progressHandle.finish();
            }
        }

        private boolean registerJDKDerby() {
            if (DerbyOptions.getDefault().getLocation().length() > 0) {
                return false;
            }
            String string = this.helper.findDerbyLocation();
            if (string != null) {
                LOGGER.log(Level.FINE, "Registering JDK Derby at {0}", string);
                return DerbyOptions.getDefault().trySetLocation(string);
            }
            return false;
        }

        private void registerSampleDatabase() {
            try {
                DerbyDatabases.createSampleDatabase();
            }
            catch (DatabaseException databaseException) {
                Logger.getLogger(Installer.class.getName()).log(Level.WARNING, null, databaseException);
            }
            catch (IOException iOException) {
                Logger.getLogger(Installer.class.getName()).log(Level.WARNING, null, iOException);
            }
        }
    }
}

