/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Collection;
import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.core.stack.api.support.ThreadStateMapper;
import org.netbeans.modules.dlight.threadmap.api.ThreadSummaryData;
import org.netbeans.modules.dlight.visualizers.api.ThreadStateResources;
import org.netbeans.modules.dlight.visualizers.threadmap.OrderedEnumStateIterator;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateColumnImpl;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadSummaryColumnImpl;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadsPanel;
import org.netbeans.modules.dlight.visualizers.threadmap.TimeLineUtils;
import org.netbeans.modules.dlight.visualizers.threadmap.UIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadSummaryCellRenderer
extends JPanel
implements TableCellRenderer,
Serializable {
    private Color unselectedBackground;
    private Color unselectedForeground;
    private ThreadSummaryColumnImpl threadSummary;
    private ThreadsPanel viewManager;
    private long threadTime;
    private long threadRunningTime;
    private long threadRunningRatio;
    private Collection<TimeIntervalDataFilter> timeFilters;
    private long dataStart;
    private EnumMap<ThreadState.MSAState, AtomicInteger> map = new EnumMap(ThreadState.MSAState.class);

    public ThreadSummaryCellRenderer(ThreadsPanel threadsPanel) {
        this.viewManager = threadsPanel;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.unselectedBackground = UIUtils.getProfilerResultsBackground();
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.unselectedForeground = color;
    }

    @Override
    public boolean isOpaque() {
        Color color = this.getBackground();
        Container container = this.getParent();
        if (container != null) {
            container = container.getParent();
        }
        boolean bl = color != null && container != null && color.equals(container.getBackground()) && container.isOpaque();
        return !bl && super.isOpaque();
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            super.setForeground(jTable.isFocusOwner() ? jTable.getSelectionForeground() : UIUtils.getUnfocusedSelectionForeground());
            super.setBackground(jTable.isFocusOwner() ? jTable.getSelectionBackground() : UIUtils.getUnfocusedSelectionBackground());
        } else if ((n & 1) == 0) {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
            super.setBackground(UIUtils.getDarker(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground()));
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground());
        }
        if (object instanceof ThreadSummaryColumnImpl) {
            this.threadSummary = (ThreadSummaryColumnImpl)object;
        }
        this.timeFilters = this.viewManager.getTimeIntervalSelection();
        this.dataStart = this.viewManager.getDataStart();
        return this;
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2;
        super.paint(graphics);
        for (AtomicInteger atomicInteger : this.map.values()) {
            atomicInteger.set(0);
        }
        int n3 = this.countSum(this.map);
        this.threadTime = n3;
        if (n3 > 0) {
            ThreadStateColumnImpl.normilizeMap(this.map, n3, 1);
            ThreadStateColumnImpl.roundMap(this.map);
        }
        this.threadRunningTime = this.sumStates(ThreadState.MSAState.Running, ThreadState.MSAState.RunningUser, ThreadState.MSAState.RunningSystemCall, ThreadState.MSAState.RunningOther);
        int n4 = this.getHeight() - 6;
        if (n3 > 0) {
            n2 = 50;
            int n5 = 0;
            n5 = 0;
            int n6 = 6;
            n = 60;
            OrderedEnumStateIterator orderedEnumStateIterator = new OrderedEnumStateIterator(this.map);
            while (orderedEnumStateIterator.hasNext()) {
                Object object = orderedEnumStateIterator.next();
                AtomicInteger atomicInteger = (AtomicInteger)object.getValue();
                n5 = n2;
                n2 = (atomicInteger.get() * n + n5) % 100;
                int n7 = (atomicInteger.get() * n + n5) / 100;
                if (n7 > 0) {
                    graphics.setColor(ThreadStateColumnImpl.getThreadStateColor((ThreadState.MSAState)object.getKey()));
                    graphics.fillRect(n6, 3, n7, n4);
                }
                n6 += n7;
            }
        }
        this.threadRunningRatio = this.sumStates(ThreadState.MSAState.Running, ThreadState.MSAState.RunningUser, ThreadState.MSAState.RunningSystemCall, ThreadState.MSAState.RunningOther);
        n2 = (int)(100L * this.threadRunningRatio) / 100;
        String string = "" + n2 + "%";
        Font font = new Font(null, 1, n4 - 2);
        graphics.setFont(font);
        n = this.getHeight() - 3 - 2;
        graphics.setColor(UIUtils.getDarker(this.getBackground(), 0.4f));
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                graphics.drawString(string, 9 + i, n + j);
            }
        }
        graphics.setColor(this.getBackground());
        graphics.drawString(string, 9, n);
    }

    @Override
    public String getToolTipText() {
        EnumMap<ThreadState.MSAState, AtomicInteger> enumMap = new EnumMap<ThreadState.MSAState, AtomicInteger>(ThreadState.MSAState.class);
        int n = this.countSum(enumMap);
        if (n > 0) {
            ThreadStateColumnImpl.normilizeMap(enumMap, n, 1);
            ThreadStateColumnImpl.roundMap(enumMap);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            stringBuilder.append("<table>");
            OrderedEnumStateIterator orderedEnumStateIterator = new OrderedEnumStateIterator(enumMap);
            while (orderedEnumStateIterator.hasNext()) {
                Object object = orderedEnumStateIterator.next();
                int n2 = ((AtomicInteger)object.getValue()).get();
                ThreadState.MSAState mSAState = (ThreadState.MSAState)object.getKey();
                ThreadStateResources threadStateResources = ThreadStateResources.forState(mSAState);
                if (threadStateResources == null) continue;
                stringBuilder.append("<tr>");
                stringBuilder.append("<td>");
                stringBuilder.append("<font bgcolor=\"#");
                stringBuilder.append(ThreadSummaryCellRenderer.colorToHexString(threadStateResources.color));
                stringBuilder.append("\">&nbsp;&nbsp;");
                stringBuilder.append("</font></td>");
                stringBuilder.append("<td>");
                stringBuilder.append(threadStateResources.name);
                stringBuilder.append("</td>");
                stringBuilder.append("<td>");
                stringBuilder.append(TimeLineUtils.getMillisValue(n2 * n * 10));
                stringBuilder.append("</td>");
                stringBuilder.append("<td>");
                stringBuilder.append("" + n2 + "%");
                stringBuilder.append("</td>");
                stringBuilder.append("</tr>");
            }
            stringBuilder.append("</table>");
            stringBuilder.append("</html>");
            return stringBuilder.toString();
        }
        return super.getToolTipText();
    }

    private int countSum(EnumMap<ThreadState.MSAState, AtomicInteger> enumMap) {
        int n = 0;
        for (ThreadSummaryData.StateDuration stateDuration : this.threadSummary.getSummary()) {
            ThreadState.MSAState mSAState = stateDuration.getState();
            if (!this.viewManager.isFullMode()) {
                mSAState = ThreadStateMapper.toSimpleState((ThreadState.MSAState)mSAState);
            }
            if (mSAState == null) continue;
            int n2 = (int)(stateDuration.getDuration() / 1000L / 1000L / 10L);
            n += n2;
            AtomicInteger atomicInteger = enumMap.get(mSAState);
            if (atomicInteger != null) {
                atomicInteger.addAndGet(n2);
                continue;
            }
            atomicInteger = new AtomicInteger(n2);
            enumMap.put(mSAState, atomicInteger);
        }
        n = (n + 50) / 100;
        ThreadStateColumnImpl.normilizeMap(enumMap, 100, n);
        return n;
    }

    private static String colorToHexString(Color color) {
        return String.format("%06x", color.getRGB() & 0xFFFFFF);
    }

    private int sumStates(ThreadState.MSAState ... mSAStateArray) {
        int n = 0;
        for (ThreadState.MSAState mSAState : mSAStateArray) {
            AtomicInteger atomicInteger = this.map.get(mSAState);
            if (atomicInteger == null) continue;
            n += atomicInteger.get();
        }
        return n;
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public void validate() {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
    }
}

