/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.core.stack.dataprovider.FunctionsListDataProvider;
import org.netbeans.modules.dlight.core.stack.dataprovider.SourceFileInfoDataProvider;
import org.netbeans.modules.dlight.core.stack.spi.AnnotatedSourceSupport;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.SessionStateListener;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.SourceSupportProvider;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.visualizers.FunctionsListSheetCell;
import org.netbeans.modules.dlight.visualizers.ImageLoader;
import org.netbeans.modules.dlight.visualizers.OnTimerTask;
import org.netbeans.modules.dlight.visualizers.VisualizerTopComponentTopComponent;
import org.netbeans.modules.dlight.visualizers.VisualizersSupport;
import org.netbeans.modules.dlight.visualizers.api.ColumnsUIMapping;
import org.netbeans.modules.dlight.visualizers.api.FunctionsListViewVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.impl.FunctionsListViewVisualizerConfigurationAccessor;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.ETableColumnModel;
import org.netbeans.swing.outline.Outline;
import org.openide.awt.HtmlRenderer;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionsListViewVisualizer
extends JPanel
implements Visualizer<FunctionsListViewVisualizerConfiguration>,
OnTimerTask,
ComponentListener,
ExplorerManager.Provider {
    private static final long MIN_REFRESH_MILLIS = 500L;
    private static final Logger log = DLightLogger.getLogger(FunctionsListViewVisualizer.class);
    private Future<Boolean> task;
    private final QueryLock queryLock = new QueryLock();
    private final SourcePrefetchExecutorLock sourcePrefetchExecutorLock = new SourcePrefetchExecutorLock();
    private final UILock uiLock = new UILock();
    private JButton refresh;
    private boolean isEmptyContent;
    private boolean isLoadingContent;
    private boolean isShown = true;
    private final OutlineView outlineView;
    private final ExplorerManager explorerManager;
    private final FunctionDatatableDescription functionDatatableDescription;
    private final FunctionsListDataProvider dataProvider;
    private final DataTableMetadata metadata;
    private final ColumnsUIMapping columnsUIMapping;
    private final List<DataTableMetadata.Column> metrics;
    private final FunctionsListViewVisualizerConfiguration configuration;
    private final VisualizersSupport visSupport;
    private FunctionCallChildren currentChildren;
    private ExecutorService sourcePrefetchExecutor;
    private static final boolean isMacLaf = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static final Color macBackground = UIManager.getColor("NbExplorerView.background");
    private static final boolean useHtmlFormat;
    private static final Color htmlEnabledForeground;
    private static final Color htmlDisabledForeground;
    private static final Color tooltipBG;
    private Map<Integer, Boolean> ascColumnValues = new HashMap<Integer, Boolean>();
    private final SourceSupportProvider sourceSupportProvider = (SourceSupportProvider)Lookup.getDefault().lookup(SourceSupportProvider.class);

    private static Color getColor(String string, Color color) {
        Color color2 = UIManager.getDefaults().getColor(string);
        return color2 == null ? color : color2;
    }

    public FunctionsListViewVisualizer(FunctionsListDataProvider functionsListDataProvider, FunctionsListViewVisualizerConfiguration functionsListViewVisualizerConfiguration) {
        super(new BorderLayout());
        KeyStroke keyStroke;
        this.visSupport = new VisualizersSupport(new VisualizerImplSessionStateListener());
        this.explorerManager = new ExplorerManager();
        this.configuration = functionsListViewVisualizerConfiguration;
        this.functionDatatableDescription = FunctionsListViewVisualizerConfigurationAccessor.getDefault().getFunctionDatatableDescription(functionsListViewVisualizerConfiguration);
        this.metrics = FunctionsListViewVisualizerConfigurationAccessor.getDefault().getMetricsList(functionsListViewVisualizerConfiguration);
        this.columnsUIMapping = FunctionsListViewVisualizerConfigurationAccessor.getDefault().getColumnsUIMapping(functionsListViewVisualizerConfiguration);
        this.dataProvider = functionsListDataProvider;
        this.metadata = functionsListViewVisualizerConfiguration.getMetadata();
        this.addComponentListener(this);
        String string = this.columnsUIMapping == null || this.columnsUIMapping.getDisplayedName(this.functionDatatableDescription.getNameColumn()) == null ? this.metadata.getColumnByName(this.functionDatatableDescription.getNameColumn()).getColumnUName() : this.columnsUIMapping.getDisplayedName(this.functionDatatableDescription.getNameColumn());
        this.outlineView = new OutlineView(string);
        this.outlineView.setDragSource(false);
        this.outlineView.setDropTarget(false);
        this.outlineView.setAllowedDragActions(0);
        this.outlineView.setAllowedDropActions(0);
        final Outline outline = this.outlineView.getOutline();
        outline.getTableHeader().setReorderingAllowed(false);
        outline.setRootVisible(false);
        outline.putClientProperty((Object)"ComputingTooltip", (Object)Boolean.TRUE);
        outline.setDefaultRenderer(Object.class, (TableCellRenderer)new ExtendedTableCellRendererForNode(this.explorerManager));
        outline.setDefaultRenderer(Node.Property.class, (TableCellRenderer)new FunctionsListSheetCell.OutlineSheetCell(this.outlineView.getOutline(), this.metrics));
        outline.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                FunctionCallNode functionCallNode;
                GoToSourceAction goToSourceAction;
                Node[] nodeArray;
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && MouseUtils.isDoubleClick((MouseEvent)mouseEvent) && (nodeArray = FunctionsListViewVisualizer.this.explorerManager.getSelectedNodes()) != null && nodeArray.length > 0 && nodeArray[0] instanceof FunctionCallNode && (goToSourceAction = (functionCallNode = (FunctionCallNode)nodeArray[0]).getGoToSourceAction()) != null) {
                    if (goToSourceAction.isEnabled()) {
                        goToSourceAction.actionPerformed(new ActionEvent((Object)functionCallNode, 1001, ""));
                    } else {
                        Logger.getLogger(OutlineView.class.getName()).info("Action " + goToSourceAction + " on node " + (Object)((Object)functionCallNode) + " is disabled");
                    }
                    mouseEvent.consume();
                    return;
                }
                super.mouseClicked(mouseEvent);
            }
        });
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        for (DataTableMetadata.Column column : this.metrics) {
            String string2 = this.columnsUIMapping == null || this.columnsUIMapping.getDisplayedName(column.getColumnName()) == null ? column.getColumnUName() : this.columnsUIMapping.getDisplayedName(column.getColumnName());
            String string3 = this.columnsUIMapping == null || this.columnsUIMapping.getTooltip(column.getColumnName()) == null ? column.getColumnLongUName() : this.columnsUIMapping.getTooltip(column.getColumnName());
            keyStroke = new PropertySupport(column.getColumnName(), column.getColumnClass(), string2, string3, true, false){

                public Object getValue() throws IllegalAccessException, InvocationTargetException {
                    return null;
                }

                public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                }
            };
            arrayList.add(keyStroke);
        }
        int n = this.metrics.size() + 1;
        int n2 = 49;
        for (int i = 1; i <= n; ++i) {
            final int n3 = i - 1;
            keyStroke = KeyStroke.getKeyStroke(n2++, 8, true);
            this.outlineView.getInputMap(1).put(keyStroke, "ascSortFor" + i);
            this.outlineView.getActionMap().put("ascSortFor" + i, new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = n3;
                    ETableColumnModel eTableColumnModel = null;
                    if (outline.getColumnModel() instanceof ETableColumnModel) {
                        eTableColumnModel = (ETableColumnModel)outline.getColumnModel();
                        eTableColumnModel.clearSortedColumns();
                    }
                    boolean bl = !FunctionsListViewVisualizer.this.ascColumnValues.containsKey(n) ? true : (Boolean)FunctionsListViewVisualizer.this.ascColumnValues.get(n);
                    outline.setColumnSorted(n, bl, 1);
                    FunctionsListViewVisualizer.this.ascColumnValues.put(n, !bl);
                    outline.getTableHeader().resizeAndRepaint();
                }
            });
        }
        outline.getSelectionModel().setSelectionMode(0);
        this.outlineView.setProperties(arrayList.toArray(new Node.Property[0]));
        VisualizerTopComponentTopComponent.findInstance().addComponentListener(this);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(27, 0, true);
        this.outlineView.getOutline().getInputMap(1).put(keyStroke2, "return");
        this.outlineView.getOutline().getActionMap().put("return", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionsListViewVisualizer.this.refresh.requestFocus(false);
            }
        });
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(10, 0, true);
        this.outlineView.getOutline().getInputMap(1).put(keyStroke3, "enter");
        this.outlineView.getOutline().getActionMap().put("enter", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionCallNode functionCallNode;
                GoToSourceAction goToSourceAction;
                Node[] nodeArray = FunctionsListViewVisualizer.this.explorerManager.getSelectedNodes();
                if (nodeArray != null && nodeArray.length > 0 && nodeArray[0] instanceof FunctionCallNode && (goToSourceAction = (functionCallNode = (FunctionCallNode)nodeArray[0]).getGoToSourceAction()) != null) {
                    goToSourceAction.actionPerformed(null);
                }
            }
        });
        keyStroke = (ETableColumnModel)outline.getColumnModel();
        TableColumn tableColumn = keyStroke.getColumn(0);
        ETableColumn eTableColumn = (ETableColumn)tableColumn;
        eTableColumn.setNestedComparator((Comparator)new Comparator<FunctionCallNode>(){

            @Override
            public int compare(FunctionCallNode functionCallNode, FunctionCallNode functionCallNode2) {
                return functionCallNode.getName().compareTo(functionCallNode2.getName());
            }
        });
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        if (this.refresh != null) {
            this.refresh.requestFocus();
        }
    }

    public FunctionsListViewVisualizerConfiguration getVisualizerConfiguration() {
        return this.configuration;
    }

    public JComponent getComponent() {
        return this;
    }

    public VisualizerContainer getDefaultContainer() {
        return VisualizerTopComponentTopComponent.findInstance();
    }

    public void refresh() {
        this.asyncFillModel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncFillModel(boolean bl) {
        QueryLock queryLock = this.queryLock;
        synchronized (queryLock) {
            if (this.task != null && !this.task.isDone()) {
                if (bl) {
                    this.task.cancel(true);
                } else {
                    return;
                }
            }
            UIThread.invoke((Runnable)new Runnable(){

                public void run() {
                    FunctionsListViewVisualizer.this.setLoadingContent();
                }
            });
            this.task = DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    FunctionsListViewVisualizer.this.syncFillModel(true);
                    return Boolean.TRUE;
                }
            }, (String)("FunctionsListViewVisualizer Async data load for " + this.configuration.getID() + " from main table " + this.configuration.getMetadata().getName()));
        }
    }

    private void syncFillModel(boolean bl) {
        long l = System.currentTimeMillis();
        List list = this.dataProvider.getFunctionsList(this.metadata, this.functionDatatableDescription, this.metrics);
        List list2 = this.dataProvider.getDetailedFunctionsList(this.metadata, this.functionDatatableDescription, this.metrics);
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        try {
            if (bl && l3 < 500L) {
                Thread.sleep(500L - l3);
            }
            this.updateList(list, list2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void asyncNotifyAnnotedSourceProviders(final List<FunctionCallWithMetric> list, final List<FunctionCallWithMetric> list2) {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        Collection collection = Lookup.getDefault().lookupAll(AnnotatedSourceSupport.class);
        for (final AnnotatedSourceSupport annotatedSourceSupport : collection) {
            DLightExecutorService.submit((Runnable)new Runnable(){

                public void run() {
                    annotatedSourceSupport.updateSource((SourceFileInfoDataProvider)FunctionsListViewVisualizer.this.dataProvider, FunctionsListViewVisualizer.this.metrics, list2, list);
                }
            }, (String)"Annoted Source from FunctionsListView Visualizer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateList(final List<FunctionCallWithMetric> list, List<FunctionCallWithMetric> list2) {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        final boolean bl = list == null || list.isEmpty();
        SourcePrefetchExecutorLock sourcePrefetchExecutorLock = this.sourcePrefetchExecutorLock;
        synchronized (sourcePrefetchExecutorLock) {
            if (this.sourcePrefetchExecutor != null) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return FunctionsListViewVisualizer.this.sourcePrefetchExecutor.shutdownNow();
                    }
                });
                this.sourcePrefetchExecutor = null;
            }
            if (!this.isEmptyContent) {
                this.sourcePrefetchExecutor = Executors.newFixedThreadPool(2);
            }
        }
        this.asyncNotifyAnnotedSourceProviders(list, list2);
        UIThread.invoke((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                UILock uILock = FunctionsListViewVisualizer.this.uiLock;
                synchronized (uILock) {
                    FunctionsListViewVisualizer.this.setContent(bl);
                    if (!bl) {
                        final FunctionCallChildren functionCallChildren = new FunctionCallChildren(list);
                        FunctionsListViewVisualizer.this.currentChildren = functionCallChildren;
                        if (!Children.MUTEX.isReadAccess()) {
                            Children.MUTEX.writeAccess(new Runnable(){

                                public void run() {
                                    FunctionsListViewVisualizer.this.explorerManager.setRootContext((Node)new AbstractNode((Children)functionCallChildren));
                                    FunctionsListViewVisualizer.this.setNonEmptyContent();
                                }
                            });
                        }
                    }
                }
            }
        });
    }

    private void setEmptyContent() {
        this.isEmptyContent = true;
        this.removeAll();
        JLabel jLabel = new JLabel(this.visSupport != null && this.visSupport.isSessionAnalyzed() ? FunctionsListViewVisualizerConfigurationAccessor.getDefault().getEmptyAnalyzeMessage(this.configuration) : FunctionsListViewVisualizerConfigurationAccessor.getDefault().getEmptyRunningMessage(this.configuration), 0);
        this.add((Component)jLabel, "Center");
        this.add((Component)this.createToolbar(), "West");
        this.repaint();
        this.revalidate();
    }

    private void setLoadingContent() {
        this.isEmptyContent = false;
        this.isLoadingContent = true;
        this.removeAll();
        JLabel jLabel = new JLabel(FunctionsListViewVisualizer.getMessage("Loading"), 0);
        this.add((Component)jLabel, "Center");
        this.repaint();
        this.revalidate();
    }

    private void setContent(boolean bl) {
        if (this.isLoadingContent && bl) {
            this.isLoadingContent = false;
            this.setEmptyContent();
            return;
        }
        if (this.isLoadingContent && !bl) {
            this.isLoadingContent = false;
            this.setNonEmptyContent();
            return;
        }
        if (this.isEmptyContent && !bl) {
            this.setNonEmptyContent();
            return;
        }
        if (bl) {
            this.setEmptyContent();
            return;
        }
    }

    private void setNonEmptyContent() {
        this.isEmptyContent = false;
        this.removeAll();
        JToolBar jToolBar = this.createToolbar();
        this.add((Component)jToolBar, "West");
        this.add((Component)this.outlineView, "Center");
        this.repaint();
        this.validate();
        this.refresh.requestFocus();
    }

    private JToolBar createToolbar() {
        JToolBar jToolBar = new JToolBar();
        if (isMacLaf) {
            jToolBar.setBackground(macBackground);
        }
        jToolBar.setFloatable(false);
        jToolBar.setOrientation(1);
        jToolBar.setRollover(true);
        this.refresh = new JButton();
        this.refresh.setIcon(ImageLoader.loadIcon("refresh.png"));
        this.refresh.setToolTipText(FunctionsListViewVisualizer.getMessage("Refresh.Tooltip"));
        this.refresh.setHorizontalTextPosition(0);
        this.refresh.setVerticalTextPosition(3);
        this.refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionsListViewVisualizer.this.asyncFillModel(false);
            }
        });
        jToolBar.add(this.refresh);
        return jToolBar;
    }

    @Override
    public int onTimer() {
        return 0;
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        super.removeNotify();
        QueryLock queryLock = this.queryLock;
        synchronized (queryLock) {
            if (this.task != null) {
                this.task.cancel(false);
                this.task = null;
            }
        }
        this.removeComponentListener(this);
        VisualizerTopComponentTopComponent.findInstance().removeComponentListener(this);
    }

    @Override
    public void timerStopped() {
        if (this.isEmptyContent) {
            this.setEmptyContent();
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (this.isShown) {
            return;
        }
        this.isShown = this.isShowing();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.isShown = false;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public void updateVisualizerConfiguration(FunctionsListViewVisualizerConfiguration functionsListViewVisualizerConfiguration) {
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(FunctionsListViewVisualizer.class, (String)string);
    }

    static {
        String string = System.getProperty("FunctionsListViewVisualizer.usehtml", "true");
        useHtmlFormat = "true".equalsIgnoreCase(string);
        htmlEnabledForeground = FunctionsListViewVisualizer.getColor("FormattedTextField.foreground", Color.BLACK);
        htmlDisabledForeground = FunctionsListViewVisualizer.getColor("FormattedTextField.inactiveForeground", Color.GRAY);
        tooltipBG = FunctionsListViewVisualizer.getColor("ToolTip.background", Color.YELLOW);
    }

    private static final class UILock {
        private UILock() {
        }
    }

    private static final class SourcePrefetchExecutorLock {
        private SourcePrefetchExecutorLock() {
        }
    }

    private static final class QueryLock {
        private QueryLock() {
        }
    }

    private static class VisualizerImplSessionStateListener
    implements SessionStateListener {
        private VisualizerImplSessionStateListener() {
        }

        public void sessionStateChanged(DLightSession dLightSession, DLightSession.SessionState sessionState, DLightSession.SessionState sessionState2) {
        }
    }

    private class ExtendedTableCellRendererForNode
    extends DefaultTableCellRenderer {
        private final String dots = " ... ";
        private final Graphics2D scratchGraphics = new BufferedImage(1, 1, 1).createGraphics();
        private FunctionCallNode node;
        private int cellwidth;
        private int cellheight;
        private final ExplorerManager manager;

        public ExtendedTableCellRendererForNode(ExplorerManager explorerManager) {
            this.manager = explorerManager;
            this.setVerticalAlignment(1);
        }

        public String getToolTipText() {
            return this.ensureVisible(this.node.getHtmlDisplayName(), tooltipBG);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (jTable instanceof ETable) {
                n = ((ETable)jTable).convertRowIndexToModel(n);
                Node node = this.manager.getRootContext().getChildren().getNodeAt(n);
                if (node instanceof FunctionCallNode) {
                    this.node = (FunctionCallNode)node;
                    this.setText(this.ensureVisible(this.node.getHtmlDisplayName(), this.getBackground()));
                }
            }
            return this;
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            int n5 = 0;
            if (n3 > 0 && n4 > 0) {
                this.cellwidth = n3;
                this.cellheight = n4;
                n5 = (int)HtmlRenderer.renderHTML((String)(this.node.getHtmlDisplayName() + ' '), (Graphics)this.scratchGraphics, (int)n, (int)n2, (int)n3, (int)n4, (Font)this.getFont(), (Color)Color.black, (int)0, (boolean)false);
            }
            super.setBounds(n, n2, Math.max(n3, n5) + 10, n4);
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = (int)HtmlRenderer.renderHTML((String)(this.node.getHtmlDisplayName() + ' '), (Graphics)this.scratchGraphics, (int)0, (int)0, (int)this.cellwidth, (int)0, (Font)this.getFont(), (Color)Color.black, (int)0, (boolean)false);
            if (this.cellwidth < n) {
                int n2 = (int)graphics.getFontMetrics().getStringBounds(" ... ", graphics).getMaxX();
                ((Graphics2D)graphics).setBackground(this.getBackground());
                graphics.setColor(this.getContrastGrayColor(htmlDisabledForeground, this.getBackground()));
                graphics.clearRect(this.cellwidth - n2, 0, n2, this.cellheight);
                graphics.drawString(" ... ", this.cellwidth - n2, fontMetrics.getHeight() + fontMetrics.getLeading() - fontMetrics.getDescent());
            }
        }

        private Color getContrastGrayColor(Color color, Color color2) {
            int n = color.getRGB();
            int n2 = ((n >> 16 & 0xFF) + (n >> 8 & 0xFF) + (n & 0xFF)) / 3;
            int n3 = (((n = color2.getRGB()) >> 16 & 0xFF) + (n >> 8 & 0xFF) + (n & 0xFF)) / 3;
            if (Math.abs(n2 - n3) > 100) {
                return new Color(n2, n2, n2);
            }
            int n4 = n3 > 128 ? n3 - 100 : n3 + 100;
            return new Color(n4, n4, n4);
        }

        private String ensureVisible(String string, Color color) {
            Color color2 = this.getContrastGrayColor(htmlEnabledForeground, color);
            Color color3 = this.getContrastGrayColor(htmlDisabledForeground, color);
            String string2 = String.format("color='#%02x%02x%02x'", color2.getRed(), color2.getGreen(), color2.getBlue());
            String string3 = String.format("color='#%02x%02x%02x'", color3.getRed(), color3.getGreen(), color3.getBlue());
            string = string.replace("color='black'", string2);
            return string.replace("color='gray'", string3);
        }
    }

    private class GoToSourceAction
    extends AbstractAction {
        private final FunctionCallNode functionCallNode;
        private SourceFileInfoProvider.SourceFileInfo sourceInfo;
        private Future<Boolean> goToSourceTask;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GoToSourceAction(FunctionCallNode functionCallNode) {
            super(NbBundle.getMessage(FunctionsListViewVisualizer.class, (String)"GoToSourceActionName"));
            this.functionCallNode = functionCallNode;
            SourcePrefetchExecutorLock sourcePrefetchExecutorLock = FunctionsListViewVisualizer.this.sourcePrefetchExecutorLock;
            synchronized (sourcePrefetchExecutorLock) {
                if (FunctionsListViewVisualizer.this.sourcePrefetchExecutor == null) {
                    FunctionsListViewVisualizer.this.sourcePrefetchExecutor = Executors.newFixedThreadPool(2);
                }
            }
            FunctionsListViewVisualizer.this.sourcePrefetchExecutor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    FunctionCallWithMetric functionCallWithMetric = GoToSourceAction.this.functionCallNode.getFunctionCall();
                    SourceFileInfoProvider.SourceFileInfo sourceFileInfo = FunctionsListViewVisualizer.this.dataProvider.getSourceFileInfo((FunctionCall)functionCallWithMetric);
                    if (sourceFileInfo != null && sourceFileInfo.isSourceKnown()) {
                        GoToSourceAction.this.setEnabled(true);
                    }
                    1 var3_3 = this;
                    synchronized (var3_3) {
                        GoToSourceAction.this.sourceInfo = sourceFileInfo;
                    }
                    GoToSourceAction.this.functionCallNode.fire();
                }
            });
            this.setEnabled(false);
        }

        public synchronized void actionPerformed(ActionEvent actionEvent) {
            if (this.goToSourceTask != null && !this.goToSourceTask.isDone()) {
                return;
            }
            this.goToSourceTask = DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    SourceFileInfoProvider.SourceFileInfo sourceFileInfo = GoToSourceAction.this.getSource();
                    if (sourceFileInfo == null || !sourceFileInfo.isSourceKnown()) {
                        return false;
                    }
                    FunctionsListViewVisualizer.this.sourceSupportProvider.showSource(sourceFileInfo);
                    return true;
                }
            }, (String)"GoToSource from Functions List View");
        }

        private synchronized SourceFileInfoProvider.SourceFileInfo getSource() {
            return this.sourceInfo;
        }
    }

    private class FunctionCallNode
    extends AbstractNode {
        private final FunctionCallWithMetric functionCall;
        private Node.PropertySet propertySet;
        private final Action[] actions;
        private final GoToSourceAction goToSourceAction;
        private String plainDisplayName;
        private String htmlDisplayName;
        private String functionName;

        FunctionCallNode(FunctionCallWithMetric functionCallWithMetric) {
            super(Children.LEAF);
            this.plainDisplayName = null;
            this.htmlDisplayName = null;
            this.functionName = null;
            this.functionCall = functionCallWithMetric;
            this.goToSourceAction = new GoToSourceAction(this);
            this.actions = new Action[]{this.goToSourceAction};
            this.propertySet = new Node.PropertySet(){

                public Node.Property<?>[] getProperties() {
                    ArrayList<1> arrayList = new ArrayList<1>();
                    for (final DataTableMetadata.Column column : FunctionsListViewVisualizer.this.metrics) {
                        PropertySupport propertySupport = new PropertySupport(column.getColumnName(), column.getColumnClass(), column.getColumnUName(), column.getColumnLongUName(), true, false){

                            public Object getValue() throws IllegalAccessException, InvocationTargetException {
                                return !FunctionCallNode.this.functionCall.hasMetric(column.getColumnName()) ? FunctionsListViewVisualizer.getMessage("NotDefined") : FunctionCallNode.this.functionCall.getMetricValue(column.getColumnName());
                            }

                            public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                            }
                        };
                        arrayList.add(propertySupport);
                    }
                    return arrayList.toArray(new Node.Property[0]);
                }
            };
            this.updateNames();
        }

        public synchronized String getName() {
            return this.functionName;
        }

        public FunctionCallWithMetric getFunctionCall() {
            return this.functionCall;
        }

        public Image getIcon(int n) {
            return null;
        }

        public Image getOpenedIcon(int n) {
            return null;
        }

        public Action getPreferredAction() {
            return null;
        }

        GoToSourceAction getGoToSourceAction() {
            return this.goToSourceAction;
        }

        private void fire() {
            this.updateNames();
            this.fireDisplayNameChange(null, this.getDisplayName());
        }

        public Action[] getActions(boolean bl) {
            return this.actions;
        }

        public synchronized String getDisplayName() {
            return useHtmlFormat ? this.htmlDisplayName : this.plainDisplayName;
        }

        public synchronized String getHtmlDisplayName() {
            return this.htmlDisplayName;
        }

        private synchronized void updateNames() {
            this.plainDisplayName = this.functionCall.getDisplayedName();
            String string = this.functionCall.getFunction().getName();
            String string2 = this.functionCall.getFunction().getQuilifiedName();
            int n = string.indexOf(string2);
            int n2 = string2.lastIndexOf(58);
            if (n2 > 0) {
                n += n2 + 1;
                string2 = string2.substring(n2 + 1);
            }
            this.functionName = string2;
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + string2.length());
            string3 = this.toHtml(string3);
            string2 = this.toHtml(string2);
            string4 = this.toHtml(string4);
            string2 = "<b>" + string2 + "</b>";
            String string5 = string3 + string2 + string4 + "&nbsp;";
            GoToSourceAction goToSourceAction = this.getGoToSourceAction();
            StringBuilder stringBuilder = new StringBuilder("<html>");
            String string6 = null;
            if (goToSourceAction.isEnabled()) {
                stringBuilder.append("<font color='black'>" + string5 + "</font>");
                SourceFileInfoProvider.SourceFileInfo sourceFileInfo = goToSourceAction.getSource();
                if (sourceFileInfo != null && sourceFileInfo.isSourceKnown()) {
                    String string7 = new File(sourceFileInfo.getFileName()).getName();
                    int n3 = sourceFileInfo.getLine();
                    String string8 = n3 > 0 ? FunctionsListViewVisualizer.getMessage("FunctionCallNode.prefix.withLine") : FunctionsListViewVisualizer.getMessage("FunctionCallNode.prefix.withoutLine");
                    string6 = string8 + "&nbsp;" + string7 + (n3 > 0 ? ":" + n3 : "");
                    stringBuilder.append("<font color='gray'>" + string6 + "</font>");
                }
            } else {
                stringBuilder.append("<font color='gray'>" + string5 + "</font>");
            }
            stringBuilder.append("</html>");
            this.htmlDisplayName = stringBuilder.toString();
        }

        public Node.PropertySet[] getPropertySets() {
            return new Node.PropertySet[]{this.propertySet};
        }

        private String toHtml(String string) {
            string = string.replace("&", "&amp;");
            string = string.replace("<", "&lt;");
            string = string.replace(">", "&gt;");
            string = string.replace(" ", "&nbsp;");
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FunctionCallChildren
    extends Children.Keys<FunctionCallWithMetric> {
        private final List<FunctionCallWithMetric> list;

        public FunctionCallChildren(List<FunctionCallWithMetric> list) {
            this.list = list;
        }

        protected Node[] createNodes(FunctionCallWithMetric functionCallWithMetric) {
            return new Node[]{new FunctionCallNode(functionCallWithMetric)};
        }

        protected void addNotify() {
            this.setKeys(this.list);
        }
    }
}

