/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.openide.util.Lookup;

public final class SettingsConversions {
    private static final Logger LOG = Logger.getLogger(SettingsConversions.class.getName());
    private static volatile boolean noSettingsChangeCalls = false;
    private static final Map<Class, Boolean> settingsChangeAvailable = Collections.synchronizedMap(new WeakHashMap());

    public static String insetsToString(Insets insets) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(insets.top);
        stringBuilder.append(',');
        stringBuilder.append(insets.left);
        stringBuilder.append(',');
        stringBuilder.append(insets.bottom);
        stringBuilder.append(',');
        stringBuilder.append(insets.right);
        return stringBuilder.toString();
    }

    public static Insets parseInsets(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[4];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            if (n > 3) {
                return null;
            }
            try {
                nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                LOG.log(Level.WARNING, null, numberFormatException);
                return null;
            }
            ++n;
        }
        if (n != 4) {
            return null;
        }
        return new Insets(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public static String dimensionToString(Dimension dimension) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(dimension.width);
        stringBuilder.append(',');
        stringBuilder.append(dimension.height);
        return stringBuilder.toString();
    }

    public static Dimension parseDimension(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[2];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            if (n > 1) {
                return null;
            }
            try {
                nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                LOG.log(Level.WARNING, null, numberFormatException);
                return null;
            }
            ++n;
        }
        if (n != 2) {
            return null;
        }
        return new Dimension(nArray[0], nArray[1]);
    }

    private static String wrap(String string) {
        return string.length() == 1 ? "0" + string : string;
    }

    public static String color2String(Color color) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('#');
        stringBuilder.append(SettingsConversions.wrap(Integer.toHexString(color.getRed()).toUpperCase()));
        stringBuilder.append(SettingsConversions.wrap(Integer.toHexString(color.getGreen()).toUpperCase()));
        stringBuilder.append(SettingsConversions.wrap(Integer.toHexString(color.getBlue()).toUpperCase()));
        return stringBuilder.toString();
    }

    public static Color parseColor(String string) {
        try {
            return Color.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.log(Level.WARNING, null, numberFormatException);
            return null;
        }
    }

    public static Object callFactory(Preferences preferences, MimePath mimePath, String string, Object object) {
        String string2 = preferences.get(string, null);
        if (string2 != null) {
            int n = string2.lastIndexOf(46);
            assert (n != -1) : "Need fully qualified name of class with the static setting factory method, but got '" + string2 + "'";
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            try {
                Method method;
                Class<?> clazz = classLoader.loadClass(string3);
                try {
                    method = clazz.getDeclaredMethod(string4, MimePath.class, String.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        method = clazz.getDeclaredMethod(string4, new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        throw noSuchMethodException;
                    }
                }
                Object object2 = method.getParameterTypes().length == 2 ? method.invoke(null, mimePath, string) : method.invoke(null, new Object[0]);
                if (object2 != null) {
                    return object2;
                }
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, null, exception);
            }
        }
        return object;
    }

    public static void callSettingsChange(Object object) {
        Class<?> clazz;
        Object object2;
        assert (object != null) : "The instance parameter should not be null";
        if (noSettingsChangeCalls) {
            return;
        }
        try {
            object2 = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (object2 == null) {
                object2 = SettingsConversions.class.getClassLoader();
            }
            clazz = ((ClassLoader)object2).loadClass("org.netbeans.editor.SettingsChangeEvent");
        }
        catch (ClassNotFoundException classNotFoundException) {
            noSettingsChangeCalls = true;
            return;
        }
        object2 = object.getClass();
        Boolean bl = settingsChangeAvailable.get(object2);
        if (bl == null || bl.booleanValue()) {
            AccessibleObject accessibleObject = null;
            try {
                accessibleObject = ((Class)object2).getMethod("settingsChange", clazz);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (accessibleObject == null || !accessibleObject.isAccessible()) {
                settingsChangeAvailable.put((Class)object2, false);
                return;
            }
            settingsChangeAvailable.put((Class)object2, true);
            try {
                ((Method)accessibleObject).invoke(object, new Object[]{null});
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getCause());
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, null, exception);
            }
        }
    }

    private SettingsConversions() {
    }
}

