/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import javax.xml.namespace.QName;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.build.model.ModelLineage;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.ModelList;
import org.netbeans.modules.maven.model.pom.POMComponent;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.maven.model.pom.POMQName;
import org.netbeans.modules.maven.model.pom.POMQNames;
import org.netbeans.modules.maven.model.pom.Project;
import org.netbeans.modules.maven.navigator.POMInheritancePanel;
import org.netbeans.modules.maven.navigator.POMModelVisitor;
import org.netbeans.modules.maven.navigator.ROUtil;
import org.netbeans.modules.maven.navigator.TapPanel;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.cookies.EditorCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.w3c.dom.NodeList;

public class POMModelPanel
extends JPanel
implements ExplorerManager.Provider,
Runnable,
CaretListener {
    private static final String NAVIGATOR_SHOW_UNDEFINED = "navigator.showUndefined";
    private transient ExplorerManager explorerManager = new ExplorerManager();
    private BeanTreeView treeView;
    private DataObject current;
    private JTextComponent currentComponent;
    private int currentDot = -1;
    private RequestProcessor.Task caretTask = RequestProcessor.getDefault().create(new Runnable(){

        public void run() {
            if (POMModelPanel.this.currentDot != -1) {
                POMModelPanel.this.updateCaret(POMModelPanel.this.currentDot);
            }
        }
    });
    private FileChangeAdapter adapter = new FileChangeAdapter(){

        public void fileChanged(FileEvent fileEvent) {
            POMModelPanel.this.showWaitNode();
            RequestProcessor.getDefault().post((Runnable)POMModelPanel.this);
        }
    };
    private TapPanel filtersPanel;
    private Configuration configuration;
    private JScrollPane jScrollPane1;

    public POMModelPanel() {
        this.initComponents();
        this.configuration = new Configuration();
        boolean bl = NbPreferences.forModule(POMModelPanel.class).getBoolean(NAVIGATOR_SHOW_UNDEFINED, true);
        this.configuration.setFilterUndefined(bl);
        this.treeView = (BeanTreeView)this.jScrollPane1;
        this.filtersPanel = new TapPanel();
        this.filtersPanel.setOrientation(2);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        String string = org.openide.util.Utilities.keyToString((KeyStroke)keyStroke);
        this.filtersPanel.setToolTipText(NbBundle.getMessage(POMModelPanel.class, (String)"TIP_TapPanel", (Object)string));
        JComponent jComponent = this.createFilterButtons();
        jComponent.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        this.filtersPanel.add(jComponent);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.filtersPanel.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.add((Component)this.filtersPanel, "South");
    }

    static void selectByNode(Node node, String string, int n) {
        if (node == null) {
            return;
        }
        POMModelVisitor.POMCutHolder pOMCutHolder = (POMModelVisitor.POMCutHolder)node.getLookup().lookup(POMModelVisitor.POMCutHolder.class);
        if (pOMCutHolder != null) {
            Object[] objectArray = pOMCutHolder.getCutValues();
            if (n >= objectArray.length) {
                return;
            }
            if (objectArray[n] != null && objectArray[n] instanceof POMComponent) {
                int n2;
                POMComponent pOMComponent = (POMComponent)objectArray[n];
                if (string != null) {
                    QName qName = POMQName.createQName((String)string, (boolean)pOMComponent.getModel().getPOMQNames().isNSAware());
                    NodeList nodeList = pOMComponent.getPeer().getElementsByTagName(qName.getLocalPart());
                    n2 = nodeList != null && nodeList.getLength() > 0 ? pOMComponent.getModel().getAccess().findPosition(nodeList.item(0)) : -1;
                } else {
                    n2 = pOMComponent.getModel().getAccess().findPosition((org.w3c.dom.Node)pOMComponent.getPeer());
                }
                if (n2 != -1) {
                    POMModelPanel.select(node, n2, n);
                }
            } else if (objectArray[n] != null && string == null) {
                String string2 = POMModelPanel.getElementNameFromNode(node);
                POMModelPanel.selectByNode(node.getParentNode(), string2, n);
            }
        }
    }

    private static void select(final Node node, final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                POMModelVisitor.POMCutHolder pOMCutHolder = (POMModelVisitor.POMCutHolder)node.getLookup().lookup(POMModelVisitor.POMCutHolder.class);
                POMModel[] pOMModelArray = pOMCutHolder.getSource();
                if (pOMModelArray.length <= n2) {
                    return;
                }
                POMModel pOMModel = pOMModelArray[n2];
                DataObject dataObject = (DataObject)pOMModel.getModelSource().getLookup().lookup(DataObject.class);
                if (dataObject == null) {
                    return;
                }
                EditorCookie.Observable observable = (EditorCookie.Observable)(dataObject = ROUtil.checkPOMFileObjectReadOnly(dataObject)).getLookup().lookup(EditorCookie.Observable.class);
                if (observable == null) {
                    return;
                }
                JEditorPane[] jEditorPaneArray = observable.getOpenedPanes();
                if (jEditorPaneArray != null && jEditorPaneArray.length > 0) {
                    JEditorPane jEditorPane = jEditorPaneArray[0];
                    try {
                        jEditorPane.setCaretPosition(n);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    TopComponent topComponent = NbEditorUtilities.getOuterTopComponent((JTextComponent)jEditorPane);
                    if (!topComponent.isVisible()) {
                        topComponent.requestVisible();
                    }
                } else {
                    observable.open();
                    try {
                        observable.openDocument();
                        jEditorPaneArray = observable.getOpenedPanes();
                        if (jEditorPaneArray != null && jEditorPaneArray.length > 0) {
                            JEditorPane jEditorPane = jEditorPaneArray[0];
                            try {
                                jEditorPane.setCaretPosition(n);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    void navigate(DataObject dataObject) {
        this.cleanup();
        this.current = dataObject;
        this.current.getPrimaryFile().addFileChangeListener((FileChangeListener)this.adapter);
        this.showWaitNode();
        RequestProcessor.getDefault().post((Runnable)this);
    }

    void cleanup() {
        if (this.current != null) {
            this.current.getPrimaryFile().removeFileChangeListener((FileChangeListener)this.adapter);
        }
        if (this.currentComponent != null) {
            this.currentComponent.removeCaretListener(this);
        }
    }

    public void run() {
        DataObject dataObject = this.current;
        if (dataObject != null && "text/x-maven-pom+xml".equals(dataObject.getPrimaryFile().getMIMEType())) {
            File file = FileUtil.toFile((FileObject)dataObject.getPrimaryFile());
            final EditorCookie.Observable observable = (EditorCookie.Observable)dataObject.getLookup().lookup(EditorCookie.Observable.class);
            if (observable == null) {
                return;
            }
            if (file != null) {
                try {
                    Object object;
                    ModelLineage modelLineage = EmbedderFactory.createModelLineage((File)file, (MavenEmbedder)EmbedderFactory.getOnlineEmbedder(), (boolean)false);
                    Iterator iterator = modelLineage.fileIterator();
                    ArrayList<Project> arrayList = new ArrayList<Project>();
                    ArrayList<POMModel> arrayList2 = new ArrayList<POMModel>();
                    POMQNames pOMQNames = null;
                    while (iterator.hasNext()) {
                        object = (File)iterator.next();
                        if (object == null) continue;
                        object = FileUtil.normalizeFile((File)object);
                        FileUtil.refreshFor((File[])new File[]{object});
                        FileObject fileObject = FileUtil.toFileObject((File)object);
                        if (fileObject != null) {
                            ModelSource modelSource = Utilities.createModelSource((FileObject)fileObject);
                            POMModel pOMModel = POMModelFactory.getDefault().getModel(modelSource);
                            if (pOMModel != null) {
                                arrayList.add(pOMModel.getProject());
                                arrayList2.add(pOMModel);
                                pOMQNames = pOMModel.getPOMQNames();
                                continue;
                            }
                            System.out.println("no model for " + object);
                            continue;
                        }
                        System.out.println("no fileobject for " + object);
                    }
                    object = new POMModelVisitor.SingleObjectCH(arrayList2.toArray(new POMModel[0]), pOMQNames, pOMQNames.PROJECT, Project.class, this.configuration);
                    for (Project project : arrayList) {
                        ((POMModelVisitor.POMCutHolder)object).addCut(project);
                    }
                    SwingUtilities.invokeLater(new Runnable((POMModelVisitor.POMCutHolder)object){
                        final /* synthetic */ POMModelVisitor.POMCutHolder val$hold;
                        {
                            this.val$hold = pOMCutHolder;
                        }

                        public void run() {
                            POMModelPanel.this.treeView.setRootVisible(false);
                            POMModelPanel.this.explorerManager.setRootContext(this.val$hold.createNode());
                        }
                    });
                }
                catch (ProjectBuildingException projectBuildingException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Error reading model lineage", projectBuildingException);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            POMModelPanel.this.treeView.setRootVisible(true);
                            POMModelPanel.this.explorerManager.setRootContext(POMModelPanel.createErrorNode());
                        }
                    });
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        POMModelPanel.this.treeView.setRootVisible(false);
                        POMModelPanel.this.explorerManager.setRootContext(POMModelPanel.createEmptyNode());
                    }
                });
            }
            try {
                observable.openDocument();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JEditorPane[] jEditorPaneArray = observable.getOpenedPanes();
                    if (jEditorPaneArray != null && jEditorPaneArray.length > 0) {
                        JEditorPane jEditorPane = jEditorPaneArray[0];
                        jEditorPane.removeCaretListener(POMModelPanel.this);
                        jEditorPane.addCaretListener(POMModelPanel.this);
                        POMModelPanel.this.currentComponent = jEditorPane;
                    }
                }
            });
        }
    }

    void release() {
        if (this.current != null) {
            this.current.getPrimaryFile().removeFileChangeListener((FileChangeListener)this.adapter);
        }
        this.current = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                POMModelPanel.this.treeView.setRootVisible(false);
                POMModelPanel.this.explorerManager.setRootContext(POMModelPanel.createEmptyNode());
            }
        });
    }

    public void showWaitNode() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                POMModelPanel.this.treeView.setRootVisible(true);
                POMModelPanel.this.explorerManager.setRootContext(POMModelPanel.createWaitNode());
            }
        });
    }

    private JComponent createFilterButtons() {
        Box box = new Box(0);
        box.setBorder(new EmptyBorder(1, 2, 3, 5));
        JToolBar jToolBar = new JToolBar(0){

            protected void paintComponent(Graphics graphics) {
            }
        };
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        jToolBar.setBorderPainted(false);
        jToolBar.setBorder(BorderFactory.createEmptyBorder());
        jToolBar.setOpaque(false);
        jToolBar.setFocusable(false);
        JToggleButton jToggleButton = new JToggleButton(new ShowUndefinedAction());
        jToggleButton.setSelected(this.configuration.isFilterUndefined());
        jToolBar.add(jToggleButton);
        Dimension dimension = new Dimension(3, 0);
        jToolBar.addSeparator(dimension);
        box.add(jToolBar);
        return box;
    }

    private static String getElementNameFromNode(Node node) {
        POMQName pOMQName;
        QName qName = (QName)node.getLookup().lookup(QName.class);
        if (qName == null && (pOMQName = (POMQName)node.getLookup().lookup(POMQName.class)) != null) {
            qName = pOMQName.getQName();
        }
        String string = qName != null ? qName.getLocalPart() : (String)node.getLookup().lookup(String.class);
        return string;
    }

    private void initComponents() {
        this.jScrollPane1 = new BeanTreeView();
        this.setLayout(new BorderLayout());
        this.add((Component)this.jScrollPane1, "Center");
    }

    private static Node createWaitNode() {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF);
        abstractNode.setIconBaseWithExtension("org/netbeans/modules/maven/navigator/wait.gif");
        abstractNode.setDisplayName(NbBundle.getMessage(POMInheritancePanel.class, (String)"LBL_Wait"));
        return abstractNode;
    }

    private static Node createEmptyNode() {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF);
        return abstractNode;
    }

    private static Node createErrorNode() {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF);
        abstractNode.setDisplayName(NbBundle.getMessage(POMInheritancePanel.class, (String)"LBL_Error"));
        return abstractNode;
    }

    static boolean isValueDefinedInCurrent(Object[] objectArray) {
        return objectArray[0] != null;
    }

    static boolean overridesParentValue(Object[] objectArray) {
        if (objectArray.length <= 1) {
            return false;
        }
        boolean bl = objectArray[0] != null;
        boolean bl2 = false;
        for (int i = 1; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            bl2 = true;
            break;
        }
        return bl && bl2;
    }

    static boolean definesValue(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            return true;
        }
        return false;
    }

    static int currentValueDepth(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            return i;
        }
        return -1;
    }

    static String getValidValue(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            return stringArray[i];
        }
        return null;
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getSource() != this.currentComponent) {
            ((JTextComponent)caretEvent.getSource()).removeCaretListener(this);
            return;
        }
        this.currentDot = caretEvent.getDot();
        this.caretTask.schedule(1000);
    }

    private void updateCaret(int n) {
        POMModelVisitor.POMCutHolder pOMCutHolder = (POMModelVisitor.POMCutHolder)this.getExplorerManager().getRootContext().getLookup().lookup(POMModelVisitor.POMCutHolder.class);
        if (pOMCutHolder != null) {
            Stack<POMComponent> stack = new Stack<POMComponent>();
            for (POMComponent pOMComponent = (POMComponent)pOMCutHolder.getSource()[0].findComponent(n); pOMComponent != null; pOMComponent = (POMComponent)pOMComponent.getParent()) {
                stack.push(pOMComponent);
            }
            Node node = this.getExplorerManager().getRootContext();
            if (stack.empty()) {
                return;
            }
            POMComponent pOMComponent = (POMComponent)stack.pop();
            boolean bl = false;
            while (!stack.empty()) {
                pOMComponent = (POMComponent)stack.pop();
                bl = false;
                ModelList modelList = node.getChildren().getNodes(true);
                Class clazz = null;
                if (pOMComponent instanceof ModelList) {
                    ModelList modelList2 = (ModelList)pOMComponent;
                    clazz = modelList2.getListClass();
                }
                for (ModelList modelList3 : modelList) {
                    Object object;
                    POMModelVisitor.POMCutHolder pOMCutHolder2 = (POMModelVisitor.POMCutHolder)modelList3.getLookup().lookup(POMModelVisitor.POMCutHolder.class);
                    Object object2 = pOMCutHolder2.getCutValues()[0];
                    if (object2 != null && object2 instanceof POMComponent && object2 == pOMComponent) {
                        this.treeView.expandNode(node);
                        node = modelList3;
                        bl = true;
                        break;
                    }
                    if (object2 != null && object2 instanceof String) {
                        object = POMModelPanel.getElementNameFromNode((Node)modelList3);
                        if (object == null || !(pOMComponent instanceof POMExtensibilityElement)) continue;
                        POMExtensibilityElement pOMExtensibilityElement = (POMExtensibilityElement)pOMComponent;
                        if (pOMExtensibilityElement.getQName().getLocalPart().equals(object)) {
                            this.treeView.expandNode(node);
                            node = modelList3;
                            bl = true;
                            break;
                        }
                    }
                    if (object2 == null || !(pOMCutHolder2 instanceof POMModelVisitor.ListObjectCH) || clazz == null || !((POMModelVisitor.ListObjectCH)(object = (POMModelVisitor.ListObjectCH)pOMCutHolder2)).getListClass().equals(clazz)) continue;
                    this.treeView.expandNode(node);
                    node = modelList3;
                    bl = true;
                    break;
                }
                if (bl) continue;
                break;
            }
            if (bl) {
                try {
                    this.getExplorerManager().setSelectedNodes(new Node[]{node});
                }
                catch (PropertyVetoException propertyVetoException) {
                    Exceptions.printStackTrace((Throwable)propertyVetoException);
                }
            }
        }
    }

    static class Configuration {
        private boolean filterUndefined;
        public static final String PROP_FILTERUNDEFINED = "filterUndefined";
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        Configuration() {
        }

        public boolean isFilterUndefined() {
            return this.filterUndefined;
        }

        public void setFilterUndefined(boolean bl) {
            boolean bl2 = this.filterUndefined;
            this.filterUndefined = bl;
            this.propertyChangeSupport.firePropertyChange(PROP_FILTERUNDEFINED, bl2, bl);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private class ShowUndefinedAction
    extends AbstractAction {
        public ShowUndefinedAction() {
            this.putValue("SmallIcon", ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/navigator/filterHideFields.gif")));
            this.putValue("ShortDescription", NbBundle.getMessage(POMModelPanel.class, (String)"DESC_FilterUndefined"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = POMModelPanel.this.configuration.isFilterUndefined();
            POMModelPanel.this.configuration.setFilterUndefined(!bl);
            NbPreferences.forModule(POMModelPanel.class).putBoolean(POMModelPanel.NAVIGATOR_SHOW_UNDEFINED, !bl);
        }
    }
}

