/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.format.checkstyle;

import hidden.org.codehaus.plexus.util.IOUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.format.checkstyle.ModuleConvertor;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.CacheDirectoryProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuxPropsImpl
implements AuxiliaryProperties,
PropertyChangeListener {
    private final Project project;
    private Properties cache;
    private boolean recheck = true;
    private List<String> defaults = new ArrayList<String>();
    private final RequestProcessor RP = new RequestProcessor("Download checkstyle plugin classpath", 1);

    public AuxPropsImpl(Project project) {
        this.project = project;
        this.defaults.add("config/sun_checks.xml");
        this.defaults.add("config/maven_checks.xml");
        this.defaults.add("config/avalon_checks.xml");
        this.defaults.add("config/turbine_checks.xml");
        NbMavenProject.addPropertyChangeListener((Project)project, (PropertyChangeListener)this);
    }

    private FileObject copyToCacheDir(FileObject fileObject) throws IOException {
        assert (Thread.holdsLock(this));
        CacheDirectoryProvider cacheDirectoryProvider = (CacheDirectoryProvider)this.project.getLookup().lookup(CacheDirectoryProvider.class);
        return FileUtil.copyFile((FileObject)fileObject, (FileObject)cacheDirectoryProvider.getCacheDirectory(), (String)"checkstyle-checker", (String)"xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject copyToCacheDir(InputStream inputStream) throws IOException {
        assert (Thread.holdsLock(this));
        CacheDirectoryProvider cacheDirectoryProvider = (CacheDirectoryProvider)this.project.getLookup().lookup(CacheDirectoryProvider.class);
        FileObject fileObject = cacheDirectoryProvider.getCacheDirectory().getFileObject("checkstyle-checker", "xml");
        if (fileObject == null) {
            fileObject = cacheDirectoryProvider.getCacheDirectory().createData("checkstyle-checker", "xml");
        }
        InputStream inputStream2 = inputStream;
        OutputStream outputStream = null;
        try {
            outputStream = fileObject.getOutputStream();
            FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            IOUtil.close((InputStream)inputStream2);
            IOUtil.close((OutputStream)outputStream);
        }
        return fileObject;
    }

    private Properties convert() {
        try {
            CacheDirectoryProvider cacheDirectoryProvider = (CacheDirectoryProvider)this.project.getLookup().lookup(CacheDirectoryProvider.class);
            FileObject fileObject = cacheDirectoryProvider.getCacheDirectory().getFileObject("checkstyle-checker", "xml");
            boolean bl = fileObject != null && this.cache != null;
            ModuleConvertor moduleConvertor = new ModuleConvertor();
            FileObject fileObject2 = this.project.getProjectDirectory().getFileObject("target/checkstyle-checker.xml");
            if (fileObject2 != null) {
                if (bl && fileObject.getSize() == fileObject2.getSize()) {
                    return this.cache;
                }
                fileObject2 = this.copyToCacheDir(fileObject2);
            } else {
                if (bl && fileObject.lastModified().after(this.project.getProjectDirectory().getFileObject("pom.xml").lastModified())) {
                    return this.cache;
                }
                String string = PluginPropertyUtils.getReportPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-checkstyle-plugin", (String)"configLocation", null);
                if (string == null && AuxPropsImpl.definesCheckStyle(this.project)) {
                    string = "config/sun_checks.xml";
                }
                if (string != null && this.defaults.contains(string)) {
                    InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/netbeans/modules/maven/format/checkstyle/" + string);
                    fileObject2 = this.copyToCacheDir(inputStream);
                } else if (string != null) {
                    File file = FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (String)string);
                    if (file != null && file.exists()) {
                        fileObject2 = this.copyToCacheDir(FileUtil.toFileObject((File)file));
                    } else {
                        Object object;
                        List<File> list = this.findDependencyArtifacts();
                        if (list.size() > 0) {
                            FileObject fileObject3;
                            File file2;
                            FileObject fileObject4;
                            object = list.iterator();
                            while (object.hasNext() && (!FileUtil.isArchiveFile((FileObject)(fileObject4 = FileUtil.toFileObject((File)(file2 = object.next())))) || (fileObject3 = FileUtil.getArchiveRoot((FileObject)fileObject4)) == null || (fileObject2 = fileObject3.getFileObject(string)) == null)) {
                            }
                        }
                        if (fileObject2 == null) {
                            try {
                                object = new URL(string);
                                this.RP.post(new Runnable((URL)object){
                                    final /* synthetic */ URL val$url;
                                    {
                                        this.val$url = uRL;
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void run() {
                                        InputStream inputStream = null;
                                        try {
                                            inputStream = this.val$url.openStream();
                                            byte[] byArray = IOUtil.toByteArray((InputStream)inputStream);
                                            AuxPropsImpl auxPropsImpl = AuxPropsImpl.this;
                                            synchronized (auxPropsImpl) {
                                                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                                                AuxPropsImpl.this.copyToCacheDir(byteArrayInputStream);
                                                AuxPropsImpl.this.recheck = true;
                                            }
                                        }
                                        catch (IOException iOException) {
                                            iOException.printStackTrace();
                                        }
                                        finally {
                                            IOUtil.close((InputStream)inputStream);
                                        }
                                    }
                                });
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            if (fileObject2 != null) {
                return moduleConvertor.convert(fileObject2.getInputStream());
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return new Properties();
    }

    static boolean definesCheckStyle(Project project) {
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        assert (nbMavenProject != null) : "Requires a maven project instance";
        return AuxPropsImpl.definesCheckStyle(nbMavenProject.getMavenProject());
    }

    static boolean definesCheckStyle(MavenProject mavenProject) {
        if (mavenProject.getReportPlugins() != null) {
            for (Object e : mavenProject.getReportPlugins()) {
                ReportPlugin reportPlugin = (ReportPlugin)e;
                if (!"org.apache.maven.plugins".equals(reportPlugin.getGroupId()) || !"maven-checkstyle-plugin".equals(reportPlugin.getArtifactId())) continue;
                return true;
            }
        }
        return false;
    }

    private List<File> findDependencyArtifacts() {
        ArrayList<File> arrayList = new ArrayList<File>();
        final NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        List list = nbMavenProject.getMavenProject().getBuildPlugins();
        for (Plugin plugin : list) {
            if (!"maven-checkstyle-plugin".equals(plugin.getArtifactId()) || !"org.apache.maven.plugins".equals(plugin.getGroupId())) continue;
            try {
                List list2 = plugin.getDependencies();
                final MavenEmbedder mavenEmbedder = EmbedderFactory.getOnlineEmbedder();
                ArtifactFactory artifactFactory = (ArtifactFactory)mavenEmbedder.getPlexusContainer().lookup(ArtifactFactory.class);
                final MavenProjectBuilder mavenProjectBuilder = (MavenProjectBuilder)mavenEmbedder.getPlexusContainer().lookup(MavenProjectBuilder.class);
                for (Dependency dependency : list2) {
                    final Artifact artifact = artifactFactory.createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getClassifier());
                    String string = mavenEmbedder.getLocalRepository().pathOf(artifact);
                    File file = FileUtil.normalizeFile((File)new File(mavenEmbedder.getLocalRepository().getBasedir(), string));
                    if (file.exists()) {
                        arrayList.add(file);
                        continue;
                    }
                    this.RP.post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                mavenProjectBuilder.buildFromRepository(artifact, nbMavenProject.getMavenProject().getRemoteArtifactRepositories(), mavenEmbedder.getLocalRepository());
                                AuxPropsImpl auxPropsImpl = AuxPropsImpl.this;
                                synchronized (auxPropsImpl) {
                                    AuxPropsImpl.this.recheck = true;
                                }
                            }
                            catch (ProjectBuildingException projectBuildingException) {
                                projectBuildingException.printStackTrace();
                            }
                        }
                    });
                }
            }
            catch (ComponentLookupException componentLookupException) {
                Exceptions.printStackTrace((Throwable)componentLookupException);
            }
        }
        return arrayList;
    }

    synchronized Properties getCache() {
        if (this.cache == null || this.recheck) {
            String string = ((AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class)).get("netbeans.checkstyle.format", true);
            this.cache = string != null && Boolean.parseBoolean(string) ? this.convert() : new Properties();
            this.recheck = false;
        }
        return this.cache;
    }

    public String get(String string, boolean bl) {
        if ("netbeans.checkstyle.format".equals(string)) {
            return null;
        }
        if (bl) {
            return this.getCache().getProperty(string);
        }
        return null;
    }

    public void put(String string, String string2, boolean bl) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Iterable<String> listKeys(boolean bl) {
        if (bl) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object object : this.getCache().keySet()) {
                arrayList.add((String)object);
            }
            return arrayList;
        }
        return new ArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
            AuxPropsImpl auxPropsImpl = this;
            synchronized (auxPropsImpl) {
                this.recheck = true;
            }
        }
    }
}

