/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.FolderInstance;

public final class SystemFileSystemSupport {
    private static ActionsProvider DUMMY_ACTIONS_PROVIDER = new ActionsProvider(){

        public Action[] getActions() {
            return new Action[0];
        }
    };
    private static final Map<DataFolder, ActionsProvider> dataFolder2actionsProvider = new WeakHashMap<DataFolder, ActionsProvider>();

    private SystemFileSystemSupport() {
    }

    public static Action[] getActions(String string) {
        return SystemFileSystemSupport.getActionProvider(string).getActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ActionsProvider getActionProvider(String string) {
        DataFolder dataFolder = SystemFileSystemSupport.getDataFolder(string);
        if (dataFolder == null) {
            return DUMMY_ACTIONS_PROVIDER;
        }
        Map<DataFolder, ActionsProvider> map = dataFolder2actionsProvider;
        synchronized (map) {
            ActionsProvider actionsProvider = dataFolder2actionsProvider.get(dataFolder);
            if (actionsProvider == null) {
                actionsProvider = new DefaultActionsProvider(dataFolder);
                dataFolder2actionsProvider.put(dataFolder, actionsProvider);
            }
            return actionsProvider;
        }
    }

    private static DataFolder getDataFolder(String string) {
        FileObject fileObject = FileUtil.getConfigFile((String)string);
        if (fileObject == null) {
            return null;
        }
        return DataFolder.findFolder((FileObject)fileObject);
    }

    private static class DefaultActionsProvider
    extends FolderInstance
    implements ActionsProvider {
        public DefaultActionsProvider(DataFolder dataFolder) {
            super(dataFolder);
        }

        public Action[] getActions() {
            try {
                return (Action[])this.instanceCreate();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorManager.getDefault().notify(1, (Throwable)classNotFoundException);
            }
            return new Action[0];
        }

        protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
            ArrayList<Action> arrayList = new ArrayList<Action>();
            for (int i = 0; i < instanceCookieArray.length; ++i) {
                Object object;
                Class clazz = instanceCookieArray[i].instanceClass();
                if (JSeparator.class.isAssignableFrom(clazz)) {
                    arrayList.add(null);
                    continue;
                }
                try {
                    object = instanceCookieArray[i].instanceCreate();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ErrorManager.getDefault().notify(1, (Throwable)classNotFoundException);
                    continue;
                }
                if (object instanceof Action) {
                    arrayList.add((Action)object);
                    continue;
                }
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("There is an unexpected object=" + object + ", in the folder instance=" + this));
            }
            return arrayList.toArray(new Action[0]);
        }

        protected InstanceCookie acceptFolder(DataFolder dataFolder) {
            return null;
        }
    }

    static interface ActionsProvider {
        public Action[] getActions();
    }
}

