/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Parameter;
import org.netbeans.modules.php.editor.model.PhpKind;
import org.netbeans.modules.php.editor.model.PhpModifiers;
import org.netbeans.modules.php.editor.model.QualifiedName;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.impl.CachingSupport;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VariableNameFactory;
import org.netbeans.modules.php.editor.model.impl.VariableNameImpl;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.FunctionDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.LambdaFunctionDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.MagicMethodDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.MethodDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FunctionScopeImpl
extends ScopeImpl
implements FunctionScope,
VariableNameFactory {
    private List<? extends Parameter> paremeters;
    String returnType;
    private static Set<String> recursionDetection = new HashSet<String>();

    FunctionScopeImpl(Scope scope, FunctionDeclarationInfo functionDeclarationInfo, String string) {
        super(scope, functionDeclarationInfo, new PhpModifiers(1), ((FunctionDeclaration)functionDeclarationInfo.getOriginalNode()).getBody());
        this.paremeters = functionDeclarationInfo.getParameters();
        this.returnType = string;
    }

    FunctionScopeImpl(Scope scope, LambdaFunctionDeclarationInfo lambdaFunctionDeclarationInfo) {
        super(scope, lambdaFunctionDeclarationInfo, new PhpModifiers(1), ((LambdaFunctionDeclaration)lambdaFunctionDeclarationInfo.getOriginalNode()).getBody());
        this.paremeters = lambdaFunctionDeclarationInfo.getParameters();
    }

    protected FunctionScopeImpl(Scope scope, MethodDeclarationInfo methodDeclarationInfo, String string) {
        super(scope, methodDeclarationInfo, methodDeclarationInfo.getAccessModifiers(), ((MethodDeclaration)methodDeclarationInfo.getOriginalNode()).getFunction().getBody());
        this.paremeters = methodDeclarationInfo.getParameters();
        this.returnType = string;
    }

    protected FunctionScopeImpl(Scope scope, MagicMethodDeclarationInfo magicMethodDeclarationInfo) {
        super(scope, magicMethodDeclarationInfo, magicMethodDeclarationInfo.getAccessModifiers(), null);
        this.paremeters = magicMethodDeclarationInfo.getParameters();
        this.returnType = magicMethodDeclarationInfo.getReturnType();
    }

    FunctionScopeImpl(Scope scope, IndexedFunction indexedFunction) {
        this(scope, indexedFunction, PhpKind.FUNCTION);
    }

    protected FunctionScopeImpl(Scope scope, IndexedFunction indexedFunction, PhpKind phpKind) {
        super(scope, indexedFunction, phpKind);
        this.paremeters = indexedFunction.getParameters();
        this.returnType = indexedFunction.getReturnType();
    }

    public static FunctionScopeImpl createElement(Scope scope, LambdaFunctionDeclaration lambdaFunctionDeclaration) {
        return new FunctionScopeImpl(scope, LambdaFunctionDeclarationInfo.create(lambdaFunctionDeclaration)){

            public boolean isAnonymous() {
                return true;
            }
        };
    }

    @Override
    public final Collection<? extends TypeScope> getReturnTypes() {
        return this.getReturnTypes(false);
    }

    @Override
    public Collection<? extends String> getReturnTypeNames() {
        List list = Collections.emptyList();
        if (this.returnType != null && this.returnType.length() > 0) {
            list = new ArrayList();
            for (String string : this.returnType.split("\\|")) {
                if (string.contains("@")) continue;
                list.add(string);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends TypeScope> getReturnTypes(boolean bl) {
        List<TypeScope> list = Collections.emptyList();
        if (this.returnType != null && this.returnType.length() > 0) {
            list = new ArrayList<TypeScope>();
            for (String string : this.returnType.split("\\|")) {
                if (string.trim().length() <= 0) continue;
                if (bl && string.contains("@")) {
                    try {
                        if (!recursionDetection.add(string) || recursionDetection.size() >= 30) continue;
                        list.addAll(VariousUtils.getType(this, string, this.getOffset(), false));
                        continue;
                    }
                    finally {
                        recursionDetection.remove(string);
                    }
                }
                list.addAll(CachingSupport.getTypes(string, this));
            }
            this.returnType = null;
            for (TypeScope typeScope : list) {
                if (this.returnType == null) {
                    this.returnType = typeScope.getNamespaceName().append(typeScope.getName()).toString();
                    continue;
                }
                this.returnType = this.returnType + "|" + typeScope.getNamespaceName().append(typeScope.getName()).toString();
            }
        }
        return list;
    }

    @Override
    @NonNull
    public List<? extends String> getParameterNames() {
        assert (this.paremeters != null);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Parameter parameter : this.paremeters) {
            arrayList.add(parameter.getName());
        }
        return arrayList;
    }

    @Override
    @NonNull
    public List<? extends Parameter> getParameters() {
        return this.paremeters;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var4_6;
        StringBuilder stringBuilder = new StringBuilder();
        Collection<? extends TypeScope> collection = this.getReturnTypes();
        stringBuilder.append('[');
        for (TypeScope typeScope : collection) {
            if (stringBuilder.length() == 1) {
                stringBuilder.append("|");
            }
            stringBuilder.append(typeScope.getName());
        }
        stringBuilder.append("] ");
        stringBuilder.append(super.toString()).append("(");
        List<? extends String> list = this.getParameterNames();
        boolean i = false;
        while (var4_6 < list.size()) {
            String string = (String)list.get((int)var4_6);
            if (var4_6 > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
            ++var4_6;
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public Collection<? extends VariableName> getDeclaredVariables() {
        return FunctionScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            public boolean isAccepted(ModelElement modelElement) {
                return modelElement.getPhpKind().equals((Object)PhpKind.VARIABLE);
            }
        });
    }

    @Override
    public VariableNameImpl createElement(Variable variable) {
        VariableNameImpl variableNameImpl = new VariableNameImpl((Scope)this, variable, false);
        this.addElement(variableNameImpl);
        return variableNameImpl;
    }

    @Override
    public String getIndexSignature() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName().toLowerCase()).append(";");
        stringBuilder.append(this.getName()).append(";");
        stringBuilder.append(this.getOffset()).append(";");
        List<? extends Parameter> list = this.getParameters();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(object.getIndexSignature());
        }
        stringBuilder.append(";");
        if (this.returnType != null && !"mixed".equalsIgnoreCase(this.returnType)) {
            stringBuilder.append(this.returnType);
        }
        stringBuilder.append(";");
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this);
        object = namespaceScope.getQualifiedName();
        stringBuilder.append(((QualifiedName)object).toString()).append(";");
        return stringBuilder.toString();
    }

    @Override
    public QualifiedName getNamespaceName() {
        if (this.indexedElement instanceof IndexedFunction) {
            IndexedFunction indexedFunction = (IndexedFunction)this.indexedElement;
            return QualifiedName.create(indexedFunction.getNamespaceName());
        }
        return super.getNamespaceName();
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }
}

