/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model;

import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.QualifiedNameKind;
import org.netbeans.modules.php.editor.model.UseElement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifiedName {
    private final QualifiedNameKind kind;
    private final LinkedList<String> segments;

    public static QualifiedName getPreferredName(QualifiedName qualifiedName, NamespaceScope namespaceScope) {
        Collection<QualifiedName> collection = QualifiedName.getAllNames(qualifiedName, namespaceScope);
        int n = Integer.MAX_VALUE;
        QualifiedName qualifiedName2 = null;
        for (QualifiedName qualifiedName3 : collection) {
            int n2 = qualifiedName3.segments.size();
            if (n2 >= n) continue;
            qualifiedName2 = qualifiedName3;
            n = n2;
        }
        return qualifiedName2;
    }

    public static Collection<QualifiedName> getAllNames(QualifiedName qualifiedName, NamespaceScope namespaceScope) {
        HashSet<QualifiedName> hashSet = new HashSet<QualifiedName>();
        hashSet.addAll(QualifiedName.getRelatives(namespaceScope, qualifiedName));
        hashSet.add(qualifiedName.toFullyQualified());
        return hashSet;
    }

    public static Collection<QualifiedName> getRelativesToUses(NamespaceScope namespaceScope, QualifiedName qualifiedName) {
        HashSet<QualifiedName> hashSet = new HashSet<QualifiedName>();
        Collection<? extends UseElement> collection = namespaceScope.getDeclaredUses();
        for (UseElement useElement : collection) {
            QualifiedName qualifiedName2 = QualifiedName.getSuffix(qualifiedName, QualifiedName.create(useElement.getName()), true);
            if (qualifiedName2 == null) continue;
            hashSet.add(qualifiedName2);
        }
        return hashSet;
    }

    public static Collection<QualifiedName> getRelativesToNamespace(NamespaceScope namespaceScope, QualifiedName qualifiedName) {
        HashSet<QualifiedName> hashSet = new HashSet<QualifiedName>();
        QualifiedName qualifiedName2 = QualifiedName.getSuffix(qualifiedName, QualifiedName.create(namespaceScope), false);
        if (qualifiedName2 != null) {
            hashSet.add(qualifiedName2);
        }
        return hashSet;
    }

    public static Collection<QualifiedName> getRelatives(NamespaceScope namespaceScope, QualifiedName qualifiedName) {
        HashSet<QualifiedName> hashSet = new HashSet<QualifiedName>();
        hashSet.addAll(QualifiedName.getRelativesToNamespace(namespaceScope, qualifiedName));
        hashSet.addAll(QualifiedName.getRelativesToUses(namespaceScope, qualifiedName));
        return hashSet;
    }

    public static Collection<QualifiedName> getComposedNames(QualifiedName qualifiedName, NamespaceScope namespaceScope) {
        Collection<? extends UseElement> collection = namespaceScope.getDeclaredUses();
        HashSet<QualifiedName> hashSet = new HashSet<QualifiedName>();
        if (!qualifiedName.getKind().isFullyQualified()) {
            QualifiedName qualifiedName2 = QualifiedName.create(namespaceScope).append(qualifiedName).toFullyQualified();
            if (qualifiedName2 != null) {
                hashSet.add(qualifiedName2);
            }
            for (UseElement useElement : collection) {
                qualifiedName2 = QualifiedName.create(useElement.getName()).toNamespaceName().append(qualifiedName).toFullyQualified();
                if (qualifiedName2 == null) continue;
                hashSet.add(qualifiedName2);
            }
        }
        hashSet.add(qualifiedName);
        return hashSet;
    }

    public static QualifiedName getPrefix(QualifiedName qualifiedName, QualifiedName qualifiedName2, boolean bl) {
        return QualifiedName.getRemainingName(qualifiedName, qualifiedName2, true, bl);
    }

    public static QualifiedName getSuffix(QualifiedName qualifiedName, QualifiedName qualifiedName2, boolean bl) {
        if (qualifiedName.segments.size() >= qualifiedName2.segments.size()) {
            return QualifiedName.getRemainingName(qualifiedName, qualifiedName2, false, bl);
        }
        return null;
    }

    private static QualifiedName getRemainingName(QualifiedName qualifiedName, QualifiedName qualifiedName2, boolean bl, boolean bl2) {
        Object object;
        QualifiedName qualifiedName3 = null;
        ArrayList<String> arrayList = new ArrayList<String>(qualifiedName.getSegments());
        ArrayList<String> arrayList2 = new ArrayList<String>(qualifiedName2.getSegments());
        if (bl) {
            Collections.reverse(arrayList);
            Collections.reverse(arrayList2);
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        String string = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (String)arrayList.get(i);
            if (i < arrayList2.size() && ((String)object).equalsIgnoreCase(string = (String)arrayList2.get(i))) continue;
            if (bl2 && arrayList3.isEmpty() && string != null) {
                arrayList3.add(string);
            }
            arrayList3.add((String)object);
        }
        if (bl2 && arrayList3.size() == 0 && string != null) {
            arrayList3.add(string);
        }
        if (arrayList3.size() >= 0) {
            if (bl) {
                Collections.reverse(arrayList3);
            }
            qualifiedName3 = QualifiedName.create(false, arrayList3);
        }
        if (qualifiedName3 != null) {
            QualifiedName qualifiedName4;
            QualifiedName qualifiedName5 = qualifiedName4 = bl ? qualifiedName3 : qualifiedName2;
            if (bl2) {
                qualifiedName4 = qualifiedName4.toNamespaceName();
            }
            object = bl ? qualifiedName2.getSegments() : qualifiedName3.getSegments();
            Iterator iterator = ((AbstractSequentialList)object).iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                qualifiedName4 = qualifiedName4.append(string2);
            }
            if (qualifiedName.equals(qualifiedName4)) {
                return qualifiedName3;
            }
        }
        return null;
    }

    public static QualifiedName createUnqualifiedNameInClassContext(Expression expression, ClassScope classScope) {
        NamespaceName namespaceName;
        if (expression instanceof Identifier) {
            return QualifiedName.createUnqualifiedNameInClassContext((Identifier)expression, classScope);
        }
        if (expression instanceof NamespaceName && (namespaceName = (NamespaceName)expression).getSegments().size() == 1 && !namespaceName.isGlobal()) {
            return QualifiedName.createUnqualifiedNameInClassContext(namespaceName.getSegments().get(0).getName(), classScope);
        }
        return QualifiedName.create(expression);
    }

    @CheckForNull
    public static QualifiedName create(Expression expression) {
        if (expression instanceof NamespaceName) {
            return QualifiedName.create((NamespaceName)expression);
        }
        if (expression instanceof Identifier) {
            return QualifiedName.createUnqualifiedName((Identifier)expression);
        }
        return null;
    }

    public static QualifiedName create(boolean bl, List<String> list) {
        return new QualifiedName(bl, list);
    }

    public static QualifiedName create(NamespaceScope namespaceScope) {
        return QualifiedName.create(namespaceScope.getName());
    }

    public static QualifiedName create(NamespaceName namespaceName) {
        return new QualifiedName(namespaceName);
    }

    public static QualifiedName createUnqualifiedNameInClassContext(Identifier identifier, ClassScope classScope) {
        return QualifiedName.createUnqualifiedNameInClassContext(identifier.getName(), classScope);
    }

    public static QualifiedName createUnqualifiedName(Identifier identifier) {
        return new QualifiedName(identifier);
    }

    public static QualifiedName createUnqualifiedNameInClassContext(String string, ClassScope classScope) {
        if (classScope != null) {
            String string2;
            if ("self".equals(string)) {
                string = classScope.getName();
            } else if ("parent".equals(string) && (string2 = ModelUtils.getFirst(classScope.getSuperClassNames())) != null) {
                string = string2;
            }
        }
        return QualifiedName.createUnqualifiedName(string);
    }

    public static QualifiedName createForDefaultNamespaceName() {
        return QualifiedName.createUnqualifiedName("");
    }

    public static QualifiedName createUnqualifiedName(String string) {
        QualifiedNameKind qualifiedNameKind = QualifiedNameKind.resolveKind(string);
        assert (qualifiedNameKind.equals((Object)QualifiedNameKind.UNQUALIFIED));
        return new QualifiedName(false, Collections.singletonList(string));
    }

    public static QualifiedName createFullyQualified(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.startsWith("\\") || string.endsWith("\\")) {
            throw new IllegalArgumentException();
        }
        if (string2 != null && string2.trim().length() > 0) {
            if (string2.startsWith("\\") || string2.endsWith("\\")) {
                throw new IllegalArgumentException();
            }
            String[] stringArray = string2.split("\\\\");
            arrayList.addAll(Arrays.asList(stringArray));
        }
        arrayList.add(string);
        return new QualifiedName(true, arrayList);
    }

    public static QualifiedName create(String string) {
        QualifiedNameKind qualifiedNameKind = QualifiedNameKind.resolveKind(string);
        if (qualifiedNameKind.isUnqualified()) {
            return QualifiedName.createUnqualifiedName(string);
        }
        if (qualifiedNameKind.isFullyQualified()) {
            string = string.substring(1);
        }
        String[] stringArray = string.split("\\\\");
        List<String> list = null;
        if (string.endsWith("\\")) {
            list = new ArrayList<String>(Arrays.asList(stringArray));
            list.add("");
        } else {
            list = Arrays.asList(stringArray);
        }
        return new QualifiedName(qualifiedNameKind.isFullyQualified(), list);
    }

    private QualifiedName(NamespaceName namespaceName) {
        this.kind = QualifiedNameKind.resolveKind(namespaceName);
        this.segments = new LinkedList();
        for (Identifier identifier : namespaceName.getSegments()) {
            this.segments.add(identifier.getName());
        }
    }

    private QualifiedName(Identifier identifier) {
        this.kind = QualifiedNameKind.resolveKind(identifier);
        this.segments = new LinkedList<String>(Collections.singleton(identifier.getName()));
        assert (this.kind.isUnqualified());
    }

    private QualifiedName(boolean bl, List<String> list) {
        this.segments = new LinkedList<String>(list.size() == 0 ? Collections.singleton("") : list);
        this.kind = bl ? QualifiedNameKind.FULLYQUALIFIED : QualifiedNameKind.resolveKind(this.segments);
    }

    public LinkedList<String> getSegments() {
        return this.segments;
    }

    public QualifiedNameKind getKind() {
        return this.kind;
    }

    public String toString() {
        return this.toString(this.segments.size() - 1);
    }

    public String toString(int n) {
        if (n >= this.segments.size()) {
            throw new IllegalArgumentException("n >= segments.size()");
        }
        StringBuilder stringBuilder = new StringBuilder();
        QualifiedNameKind qualifiedNameKind = this.getKind();
        for (int i = 0; i <= n; ++i) {
            String string = this.segments.get(i);
            if (stringBuilder.length() > 0 || qualifiedNameKind != null && qualifiedNameKind.isFullyQualified()) {
                stringBuilder.append("\\");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public QualifiedName append(String string) {
        return this.append(QualifiedName.createUnqualifiedName(string));
    }

    public QualifiedName append(QualifiedName qualifiedName) {
        return this.append(qualifiedName, false);
    }

    private QualifiedName append(QualifiedName qualifiedName, boolean bl) {
        LinkedList<String> linkedList = this.isDefaultNamespace() ? new LinkedList<String>() : new LinkedList<String>(this.getSegments());
        linkedList.addAll(qualifiedName.getSegments());
        return new QualifiedName(bl, linkedList);
    }

    public QualifiedName toFullyQualified() {
        return this.getKind().isFullyQualified() ? this : new QualifiedName(true, this.getSegments());
    }

    @CheckForNull
    public QualifiedName toFullyQualified(QualifiedName qualifiedName) {
        Parameters.notNull((CharSequence)"namespaceName", (Object)qualifiedName);
        return qualifiedName.append(this, true);
    }

    @CheckForNull
    public QualifiedName toFullyQualified(NamespaceScope namespaceScope) {
        Parameters.notNull((CharSequence)"namespaceScope", (Object)namespaceScope);
        return this.getKind().isFullyQualified() ? this : namespaceScope.getQualifiedName().append(this).toFullyQualified();
    }

    public QualifiedName toName() {
        return QualifiedName.createUnqualifiedName(this.getSegments().getLast());
    }

    public QualifiedName toNamespaceName(boolean bl) {
        LinkedList<String> linkedList = new LinkedList<String>(this.getSegments());
        linkedList.removeLast();
        return new QualifiedName(bl, linkedList);
    }

    public QualifiedName toNamespaceName() {
        return this.toNamespaceName(false);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        QualifiedName qualifiedName = (QualifiedName)object;
        if (this.kind != qualifiedName.kind) {
            return false;
        }
        if (this.segments.size() != qualifiedName.segments.size()) {
            return false;
        }
        return this.segments.equals(qualifiedName.segments);
    }

    public int hashCode() {
        int n = 3;
        n = 73 * n + this.kind.hashCode();
        n = 73 * n + (this.segments != null ? this.segments.hashCode() : 0);
        return n;
    }

    public boolean isDefaultNamespace() {
        return this.getSegments().size() == 1 && this.getSegments().get(0).equals("");
    }
}

