/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.SymbolNode;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FindersHelper {
    private static final String ATTRIBUTE_SEPARATOR_BASE = "_and";
    private static final String ATTRIBUTE_SEPARATOR = "_and_";
    private static final String FIND = "find";
    private static final String ALL = "all";
    private static final String[] STANDARD_FINDERS = new String[]{"all", "find"};
    private static final int MAX_ITEMS = 2000;
    private static final int THRESHOLD = 100;
    private final Collection<FinderType> prefixes;
    private final Collection<String> columns;
    private final int maxDepth;

    private FindersHelper(Collection<FinderType> collection, Collection<String> collection2) {
        this.prefixes = collection;
        this.columns = collection2;
        int n = collection2.size();
        this.maxDepth = n > 100 ? 0 : (int)(Math.log(2000.0) / Math.log(n));
    }

    static List<String> extractColumns(String string) {
        for (FinderType finderType : FinderType.values()) {
            String string2 = finderType.getPrefix();
            int n = string.indexOf(string2);
            if (n == -1) continue;
            String string3 = string.substring(string2.length());
            if (string3.endsWith(ATTRIBUTE_SEPARATOR_BASE)) {
                string3 = string3.substring(0, string3.length() - ATTRIBUTE_SEPARATOR_BASE.length());
            }
            return Arrays.asList(string3.split(ATTRIBUTE_SEPARATOR));
        }
        return Collections.emptyList();
    }

    static List<FinderMethod> getFinderSignatures(String string, Collection<String> collection) {
        HashSet<String> hashSet = new HashSet<String>(collection);
        List<String> list = FindersHelper.extractColumns(string);
        hashSet.removeAll(list);
        FindersHelper findersHelper = new FindersHelper(FindersHelper.matchingFinderPrefixes(string), collection);
        return findersHelper.computeSignatures();
    }

    private static List<FinderType> matchingFinderPrefixes(String string) {
        ArrayList<FinderType> arrayList = new ArrayList<FinderType>(5);
        for (FinderType finderType : FinderType.values()) {
            String string2 = finderType.getPrefix();
            if (string.length() >= string2.length()) {
                if (!string2.startsWith(string.substring(0, string2.length()))) continue;
                arrayList.add(finderType);
                continue;
            }
            if (!string2.startsWith(string)) continue;
            arrayList.add(finderType);
        }
        return arrayList;
    }

    private List<FinderMethod> computeSignatures() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String object : this.columns) {
            hashSet.add(object);
            HashSet<String> hashSet2 = new HashSet<String>(this.columns);
            hashSet2.remove(object);
            this.addCombinations(object, hashSet2, hashSet, 0);
        }
        ArrayList arrayList = new ArrayList(hashSet.size());
        for (FinderType finderType : this.prefixes) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new FinderMethod(finderType, (String)iterator.next()));
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private void addCombinations(String string, Set<String> set, Set<String> set2, int n) {
        if (n >= this.maxDepth) {
            return;
        }
        for (String string2 : set) {
            String string3 = string + ATTRIBUTE_SEPARATOR + string2;
            set2.add(string3);
            HashSet<String> hashSet = new HashSet<String>(set);
            hashSet.remove(string2);
            this.addCombinations(string3, hashSet, set2, n + 1);
        }
    }

    static int nextAttributeLocation(String string, int n) {
        return string.indexOf(ATTRIBUTE_SEPARATOR, n);
    }

    static String subToNextAttribute(String string, int n) {
        return string.substring(0, n + ATTRIBUTE_SEPARATOR.length() - 1);
    }

    static boolean isFinderMethod(String string) {
        for (FinderType finderType : FinderType.values()) {
            if (!string.startsWith(finderType.getPrefix())) continue;
            return true;
        }
        for (String string2 : STANDARD_FINDERS) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    static RubyType pickFinderType(Node node, String string, RubyType rubyType) {
        int n = 0;
        boolean bl = false;
        for (FinderType finderType : FinderType.values()) {
            if (!string.startsWith(finderType.getPrefix())) continue;
            bl = true;
            n = finderType.isMultiple();
            break;
        }
        if (!bl && string.equals(FIND)) {
            ArrayList arrayList = new ArrayList();
            AstUtilities.addNodesByType(node, new NodeType[]{NodeType.SYMBOLNODE}, arrayList);
            int n2 = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                FinderType finderType;
                finderType = (Node)iterator.next();
                SymbolNode symbolNode = (SymbolNode)finderType;
                if (!ALL.equals(symbolNode.getName())) continue;
                n2 = 1;
                break;
            }
            n = n2;
            bl = true;
        } else if (!bl && string.equals(ALL)) {
            n = 1;
            bl = true;
        } else if (!bl) {
            n = 0;
        }
        if (n != 0) {
            return RubyType.ARRAY;
        }
        return rubyType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FinderMethod
    implements Comparable<FinderMethod> {
        private final FinderType finder;
        private final String attributes;

        public FinderMethod(FinderType finderType, String string) {
            this.finder = finderType;
            this.attributes = string;
        }

        public String getName() {
            return this.finder.getPrefix() + this.attributes;
        }

        public String getSignature() {
            StringBuilder stringBuilder = new StringBuilder(this.finder.getPrefix() + this.attributes + "(");
            String[] stringArray = this.attributes.split(FindersHelper.ATTRIBUTE_SEPARATOR);
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                stringBuilder.append(string);
                if (i >= stringArray.length - 1) continue;
                stringBuilder.append(", ");
            }
            if (this.finder.hasOptions()) {
                stringBuilder.append(", *options");
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        public String getColumn() {
            int n = this.attributes.indexOf(FindersHelper.ATTRIBUTE_SEPARATOR);
            if (n == -1) {
                return this.attributes;
            }
            return this.attributes.substring(0, n);
        }

        @Override
        public int compareTo(FinderMethod finderMethod) {
            return this.getName().compareTo(finderMethod.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FinderType {
        FIND_BY("find_by_"){

            boolean isMultiple() {
                return false;
            }
        }
        ,
        FIND_ALL_BY("find_all_by_"){

            boolean isMultiple() {
                return true;
            }
        }
        ,
        FIND_LAST_BY("find_last_by_"){

            boolean isMultiple() {
                return false;
            }
        }
        ,
        SCOPED_BY("scoped_by_"){

            boolean isMultiple() {
                return true;
            }

            boolean hasOptions() {
                return false;
            }
        };

        private final String prefix;

        private FinderType(String string2) {
            this.prefix = string2;
        }

        abstract boolean isMultiple();

        String getPrefix() {
            return this.prefix;
        }

        boolean hasOptions() {
            return true;
        }
    }
}

