/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

class TooltipWindow
extends JWindow
implements AWTEventListener {
    private static final int SCREEN_BORDER = 20;
    private final JComponent content;

    public TooltipWindow(Window window, JComponent jComponent) {
        super(window);
        this.content = jComponent;
    }

    public void show(Point point) {
        GraphicsDevice graphicsDevice;
        GraphicsConfiguration graphicsConfiguration;
        GraphicsDevice[] graphicsDeviceArray;
        this.add(this.content);
        this.pack();
        Dimension dimension = this.getSize();
        Rectangle rectangle = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray2 = graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n = graphicsDeviceArray2.length;
        for (int i = 0; i < n && !(rectangle = (graphicsConfiguration = (graphicsDevice = graphicsDeviceArray2[i]).getDefaultConfiguration()).getBounds()).contains(point); ++i) {
        }
        if (point.y + dimension.height + 20 > rectangle.y + rectangle.height) {
            dimension.height = rectangle.y + rectangle.height - (point.y + 20);
        }
        if (point.x + dimension.width + 20 > rectangle.x + rectangle.width) {
            dimension.width = rectangle.x + rectangle.width - (point.x + 20);
        }
        this.setSize(dimension);
        this.setLocation(point.x, point.y - 1);
        this.setVisible(true);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 24L);
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 501) {
            this.onClick(aWTEvent);
        } else if (aWTEvent.getID() == 401 && ((KeyEvent)aWTEvent).getKeyCode() == 27) {
            this.shutdown();
        }
    }

    private void onClick(AWTEvent aWTEvent) {
        Component component = (Component)aWTEvent.getSource();
        Window window = SwingUtilities.windowForComponent(component);
        if (window != this) {
            this.shutdown();
        }
    }

    void shutdown() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        this.dispose();
    }
}

