/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.commit;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class ExcludeFromCommitAction
extends AbstractAction
implements Presenter.Menu {
    private final File[] files;
    private final int status;

    public ExcludeFromCommitAction(VCSContext vCSContext) {
        this(vCSContext.getRootFiles().toArray(new File[0]));
    }

    public ExcludeFromCommitAction(File[] fileArray) {
        this.files = fileArray;
        this.putValue("Name", NbBundle.getBundle(ExcludeFromCommitAction.class).getString("CTL_MenuItem_ExcludeFromCommit"));
        this.status = this.getActionStatus();
        if (this.status == 1) {
            this.putValue("BooleanState.Selected", Boolean.FALSE);
        } else if (this.status == 2) {
            this.putValue("BooleanState.Selected", Boolean.TRUE);
        }
        this.setEnabled(this.status != -1);
    }

    public boolean isEnabled() {
        FileStatusCache fileStatusCache = CvsVersioningSystem.getInstance().getStatusCache();
        for (File file : this.files) {
            if ((fileStatusCache.getStatus(file).getStatus() & 0xFFFFFFFE) == 0) continue;
            return true;
        }
        return false;
    }

    public JMenuItem getMenuPresenter() {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this);
        if (this.status != -1) {
            jCheckBoxMenuItem.setSelected(this.status == 2);
        }
        Mnemonics.setLocalizedText((AbstractButton)jCheckBoxMenuItem, (String)jCheckBoxMenuItem.getText());
        return jCheckBoxMenuItem;
    }

    private int getActionStatus() {
        CvsModuleConfig cvsModuleConfig = CvsModuleConfig.getDefault();
        int n = -1;
        for (File file : this.files) {
            if (cvsModuleConfig.isExcludedFromCommit(file)) {
                if (n == 1) {
                    return -1;
                }
                n = 2;
                continue;
            }
            if (n == 2) {
                return -1;
            }
            n = 1;
        }
        return n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CvsModuleConfig cvsModuleConfig = CvsModuleConfig.getDefault();
        for (File file : this.files) {
            if (this.status == 1) {
                cvsModuleConfig.addExclusion(file);
                continue;
            }
            if (this.status != 2) continue;
            cvsModuleConfig.removeExclusion(file);
        }
    }
}

