/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.fops;

import java.awt.Color;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataUtil;
import org.netbeans.modules.dlight.api.storage.types.Time;
import org.netbeans.modules.dlight.api.tool.DLightToolConfiguration;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;
import org.netbeans.modules.dlight.core.stack.ui.StackRenderer;
import org.netbeans.modules.dlight.dtrace.collector.DTDCConfiguration;
import org.netbeans.modules.dlight.indicators.Aggregation;
import org.netbeans.modules.dlight.indicators.DataRowToTimeSeries;
import org.netbeans.modules.dlight.indicators.DetailDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesIndicatorConfiguration;
import org.netbeans.modules.dlight.spi.tool.DLightToolConfigurationProvider;
import org.netbeans.modules.dlight.util.BytesFormatter;
import org.netbeans.modules.dlight.util.ValueFormatter;
import org.netbeans.modules.dlight.util.ui.Renderer;
import org.netbeans.modules.dlight.visualizers.api.AdvancedTableViewVisualizerConfiguration;
import org.openide.util.NbBundle;

public class FopsToolConfigurationProvider
implements DLightToolConfigurationProvider {
    private static final String ID = "dlight.tool.fops";
    private static final String FILE_COUNT_ID = "file-count";
    private static final int INDICATOR_POSITION = 400;

    public DLightToolConfiguration create() {
        String string = FopsToolConfigurationProvider.getMessage("Tool.Name");
        DLightToolConfiguration dLightToolConfiguration = new DLightToolConfiguration(ID, string);
        dLightToolConfiguration.setIcon("org/netbeans/modules/dlight/fops/resources/i_o_usage_16.png");
        dLightToolConfiguration.setDescription(FopsToolConfigurationProvider.getMessage("Tool.Description"));
        DataTableMetadata.Column column = new DataTableMetadata.Column("operation", String.class, FopsToolConfigurationProvider.getMessage("Column.OpType"), null);
        DataTableMetadata.Column column2 = new DataTableMetadata.Column("file", String.class, FopsToolConfigurationProvider.getMessage("Column.Filename"), null);
        DataTableMetadata.Column column3 = new DataTableMetadata.Column("size", Long.class, FopsToolConfigurationProvider.getMessage("Column.Size"), null);
        DataTableMetadata.Column column4 = new DataTableMetadata.Column("file_count", Long.class, FopsToolConfigurationProvider.getMessage("Column.FileCount"), null);
        List<DataTableMetadata.Column> list = Arrays.asList(new DataTableMetadata.Column("timestamp", Time.class, FopsToolConfigurationProvider.getMessage("Column.Timestamp"), null), column, new DataTableMetadata.Column("sid", Integer.class, FopsToolConfigurationProvider.getMessage("Column.SID"), null), column2, column3, column4, new DataTableMetadata.Column("stack_id", Long.class, FopsToolConfigurationProvider.getMessage("Column.StackId"), null));
        DataTableMetadata dataTableMetadata = new DataTableMetadata("fops", list, null);
        URL uRL = this.getClass().getResource("resources/fops.d");
        DTDCConfiguration dTDCConfiguration = new DTDCConfiguration(uRL, Arrays.asList(dataTableMetadata));
        dTDCConfiguration.setStackSupportEnabled(true);
        dTDCConfiguration.setIndicatorFiringFactor(1);
        dTDCConfiguration.setOutputPrefix("fops:");
        dLightToolConfiguration.addDataCollectorConfiguration((DataCollectorConfiguration)dTDCConfiguration);
        dLightToolConfiguration.addIndicatorDataProviderConfiguration((IndicatorDataProviderConfiguration)dTDCConfiguration);
        DataTableMetadata.Column column5 = new DataTableMetadata.Column("open_stack_id", Long.class, FopsToolConfigurationProvider.getMessage("Column.OpenStack"), null);
        DataTableMetadata.Column column6 = new DataTableMetadata.Column("close_stack_id", Long.class, FopsToolConfigurationProvider.getMessage("Column.CloseStack"), null);
        DataTableMetadata.Column column7 = new DataTableMetadata.Column("status", String.class, FopsToolConfigurationProvider.getMessage("Column.Status"), null);
        DataTableMetadata dataTableMetadata2 = new DataTableMetadata("iosummary", Arrays.asList(column2, new DataTableMetadata.Column("bytes_read", Long.class, FopsToolConfigurationProvider.getMessage("Column.BytesRead"), null), new DataTableMetadata.Column("bytes_written", Long.class, FopsToolConfigurationProvider.getMessage("Column.BytesWritten"), null), column5, column6, column7), "SELECT file, bytes_read, bytes_written, open_stack_id, close_stack_id, CASEWHEN(open_failed, 'err', CASEWHEN(open_seen AND NOT close_seen, 'warn', 'ok')) AS status FROM (SELECT file, SUM(CASEWHEN(operation='read', size, 0)) AS bytes_read, SUM(CASEWHEN(operation='write', size, 0)) AS bytes_written, SUM(CASEWHEN(operation='open', stack_id, 0)) AS open_stack_id, SUM(CASEWHEN(operation='close', stack_id, 0)) AS close_stack_id, SUM(CASEWHEN(operation='open', timestamp, 0)) AS open_timestamp, BOOL_OR(operation='open') AS open_seen, BOOL_OR(operation='open' AND sid=0) AS open_failed, BOOL_OR(operation='close') AS close_seen FROM fops GROUP BY sid, file) ORDER BY open_timestamp, file", Arrays.asList(dataTableMetadata));
        IndicatorMetadata indicatorMetadata = new IndicatorMetadata(list);
        TimeSeriesIndicatorConfiguration timeSeriesIndicatorConfiguration = new TimeSeriesIndicatorConfiguration(indicatorMetadata, 400);
        timeSeriesIndicatorConfiguration.setTitle(FopsToolConfigurationProvider.getMessage("Indicator.Title"));
        timeSeriesIndicatorConfiguration.setGraphScale(1024);
        timeSeriesIndicatorConfiguration.addTimeSeriesDescriptors(new TimeSeriesDescriptor[]{new TimeSeriesDescriptor(new Color(231, 111, 0), FopsToolConfigurationProvider.getMessage("Indicator.Write"), TimeSeriesDescriptor.Kind.LINE), new TimeSeriesDescriptor(new Color(255, 199, 38), FopsToolConfigurationProvider.getMessage("Indicator.Read"), TimeSeriesDescriptor.Kind.LINE)});
        timeSeriesIndicatorConfiguration.setDataRowHandler((DataRowToTimeSeries)new DataRowToFops(column, column3, column4));
        timeSeriesIndicatorConfiguration.setAggregation(Aggregation.SUM);
        timeSeriesIndicatorConfiguration.setLastNonNull(false);
        timeSeriesIndicatorConfiguration.addDetailDescriptors(new DetailDescriptor[]{new DetailDescriptor(FILE_COUNT_ID, FopsToolConfigurationProvider.getMessage("Indicator.FileCount"), String.valueOf(0))});
        timeSeriesIndicatorConfiguration.setActionDisplayName(FopsToolConfigurationProvider.getMessage("Indicator.Action"));
        timeSeriesIndicatorConfiguration.setActionTooltip(FopsToolConfigurationProvider.getMessage("Indicator.Action.Tooltip"));
        timeSeriesIndicatorConfiguration.setLabelFormatter((ValueFormatter)new BytesFormatter());
        AdvancedTableViewVisualizerConfiguration advancedTableViewVisualizerConfiguration = new AdvancedTableViewVisualizerConfiguration(dataTableMetadata2, column2.getColumnName(), column2.getColumnName());
        advancedTableViewVisualizerConfiguration.setHiddenColumnNames(Arrays.asList(column5.getColumnName(), column6.getColumnName(), column7.getColumnName()));
        advancedTableViewVisualizerConfiguration.setNodeColumnIcon(column7.getColumnName(), "org/netbeans/modules/dlight/fops/resources");
        advancedTableViewVisualizerConfiguration.setEmptyAnalyzeMessage(FopsToolConfigurationProvider.getMessage("Details.EmptyAnalyze"));
        advancedTableViewVisualizerConfiguration.setEmptyRunningMessage(FopsToolConfigurationProvider.getMessage("Details.EmptyRunning"));
        advancedTableViewVisualizerConfiguration.setDualPaneMode(true);
        advancedTableViewVisualizerConfiguration.setDataRowRenderer((Renderer)new StackRenderer(Arrays.asList(column5, column6)));
        timeSeriesIndicatorConfiguration.addVisualizerConfiguration((VisualizerConfiguration)advancedTableViewVisualizerConfiguration);
        dLightToolConfiguration.addIndicatorConfiguration((IndicatorConfiguration)timeSeriesIndicatorConfiguration);
        return dLightToolConfiguration;
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(FopsToolConfigurationProvider.class, (String)string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DataRowToFops
    implements DataRowToTimeSeries {
        private final String opColumn;
        private final String sizeColumn;
        private final String fileCountColumn;
        private long fileCount;

        public DataRowToFops(DataTableMetadata.Column column, DataTableMetadata.Column column2, DataTableMetadata.Column column3) {
            this.opColumn = column.getColumnName();
            this.sizeColumn = column2.getColumnName();
            this.fileCountColumn = column3.getColumnName();
        }

        public float[] getData(DataRow dataRow) {
            int n;
            String string = dataRow.getStringValue(this.opColumn);
            if (string == null) {
                return null;
            }
            int n2 = 0;
            int n3 = 0;
            if ("read".equals(string) || "write".equals(string)) {
                n = DataUtil.toInt((Object)dataRow.getData(this.sizeColumn));
                if ("read".equals(string)) {
                    n2 += n;
                } else {
                    n3 += n;
                }
            }
            if (0 <= (n = DataUtil.toInt((Object)dataRow.getData(this.fileCountColumn), (int)-1))) {
                this.fileCount = n;
            }
            return new float[]{n3, n2};
        }

        public Map<String, String> getDetails() {
            return Collections.singletonMap(FopsToolConfigurationProvider.FILE_COUNT_ID, String.valueOf(this.fileCount));
        }
    }
}

