/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class BiIconEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static final String BEAN_ICONEDITOR_HELP = "beans.icon";
    private FileObject sourceFileObject;
    private PropertyEnv env;
    static ResourceBundle bundle = NbBundle.getBundle(BiIconEditor.class);

    public static boolean isImage(String string) {
        return (string = string.toLowerCase()).endsWith(".jpg") || string.endsWith(".gif") || string.endsWith(".jpeg") || string.endsWith(".jpe") || string.equals("jpg") || string.equals("gif") || string.equals("jpeg") || string.equals("jpe");
    }

    public BiIconEditor(FileObject fileObject) {
        this.sourceFileObject = fileObject;
    }

    public String getSourceName() {
        if (this.getValue() instanceof BiImageIcon) {
            return this.getValue().getName();
        }
        return null;
    }

    public void setValue(Object object) {
        BiImageIcon biImageIcon = this.getValue();
        if (biImageIcon == object || biImageIcon != null && biImageIcon.equals(object)) {
            return;
        }
        if (this.env != null) {
            BiImageIcon biImageIcon2 = (BiImageIcon)object;
            this.env.setState(biImageIcon2 != null && (biImageIcon2.url == null || biImageIcon2.getIcon() == null) ? PropertyEnv.STATE_INVALID : PropertyEnv.STATE_VALID);
        }
        super.setValue(object);
    }

    public BiImageIcon getValue() {
        return (BiImageIcon)super.getValue();
    }

    public String getAsText() {
        BiImageIcon biImageIcon = this.getValue();
        return this.textFromIcon(biImageIcon);
    }

    public void setAsText(String string) throws IllegalArgumentException {
        try {
            BiImageIcon biImageIcon = this.iconFromText(string);
            if (biImageIcon == null || biImageIcon.url != null) {
                this.setValue(biImageIcon);
            } else {
                String string2 = NbBundle.getMessage(IconPanel.class, (String)"CTL_Icon_not_exists", (Object)string);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    String textFromIcon(BiImageIcon biImageIcon) {
        return biImageIcon == null ? "null" : biImageIcon.getName();
    }

    BiImageIcon iconFromText(String string) throws IllegalArgumentException {
        BiImageIcon biImageIcon;
        try {
            if (string.length() == 0 || string.equals("null")) {
                biImageIcon = null;
            } else {
                ClassPath classPath = ClassPath.getClassPath((FileObject)this.sourceFileObject, (String)"classpath/source");
                FileObject fileObject = classPath.findResource(string = string.charAt(0) != '/' ? string : string.substring(1));
                if (fileObject == null) {
                    biImageIcon = new BiImageIcon(null, string);
                } else {
                    URL uRL = fileObject.getURL();
                    biImageIcon = new BiImageIcon(uRL, string);
                }
            }
        }
        catch (Throwable throwable) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                throwable.printStackTrace();
            }
            throw new IllegalArgumentException(throwable);
        }
        return biImageIcon;
    }

    public boolean isPaintable() {
        return false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new IconPanel(this, this.env);
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        this.env = propertyEnv;
        BiImageIcon biImageIcon = this.getValue();
        if (biImageIcon != null && (biImageIcon.url == null || biImageIcon.getIcon() == null)) {
            propertyEnv.setState(PropertyEnv.STATE_INVALID);
        }
    }

    private static final class ResourceSelector
    extends JPanel
    implements ExplorerManager.Provider {
        private ExplorerManager manager = new ExplorerManager();

        public ResourceSelector(Node node) {
            this.setLayout(new BorderLayout(0, 5));
            this.setBorder(new EmptyBorder(12, 12, 0, 11));
            this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ResourceSelector"));
            this.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ResourceSelector"));
            this.manager.setRootContext(node);
            BeanTreeView beanTreeView = new BeanTreeView();
            beanTreeView.setPopupAllowed(false);
            beanTreeView.setDefaultActionAllowed(false);
            beanTreeView.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
            beanTreeView.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ResourceSelectorView"));
            beanTreeView.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ResourceSelectorView"));
            this.add((Component)beanTreeView, "Center");
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.height = Math.max(dimension.height, Utilities.getUsableScreenBounds().height / 2);
            return dimension;
        }

        public Node[] getNodes() {
            return this.manager.getSelectedNodes();
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }
    }

    private static final class RootNode
    extends FilterNode {
        RootNode(Node node, String string) {
            super(node);
            if (string != null) {
                this.disableDelegation(12);
                this.setDisplayName(string);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IconPanel
    extends JPanel
    implements VetoableChangeListener {
        JRadioButton rbClasspath;
        JRadioButton rbNoPicture;
        JTextField tfName;
        JButton bSelect;
        JScrollPane spImage;
        private final PropertyEnv env;
        private BiImageIcon value;
        private BiIconEditor editor;

        IconPanel(BiIconEditor biIconEditor, PropertyEnv propertyEnv) {
            this.env = propertyEnv;
            this.editor = biIconEditor;
            this.setLayout(new BorderLayout(6, 6));
            this.setBorder(new EmptyBorder(6, 6, 6, 6));
            this.getAccessibleContext().setAccessibleName(bundle.getString("ACS_IconPanelA11yName"));
            this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_IconPanelA11yDesc"));
            JPanel jPanel = new JPanel(new BorderLayout(3, 3));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(new TitledBorder(new EtchedBorder(), bundle.getString("CTL_ImageSourceType")));
            JPanel jPanel3 = new JPanel();
            jPanel3.setBorder(new EmptyBorder(0, 3, 0, 3));
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel3.setLayout(gridBagLayout);
            gridBagConstraints.anchor = 17;
            this.rbClasspath = new JRadioButton(bundle.getString("CTL_Classpath"));
            jPanel3.add(this.rbClasspath);
            this.rbClasspath.setToolTipText(bundle.getString("ACS_ClasspathA11yDesc"));
            this.rbClasspath.setMnemonic(bundle.getString("CTL_Classpath_Mnemonic").charAt(0));
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.rbClasspath, gridBagConstraints);
            JLabel jLabel = new JLabel(bundle.getString("CTL_ClasspathExample"));
            jPanel3.add(jLabel);
            jLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ClasspathExampleA11yDesc"));
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.rbNoPicture = new JRadioButton(bundle.getString("CTL_NoPicture"));
            jPanel3.add(this.rbNoPicture);
            this.rbNoPicture.setToolTipText(bundle.getString("ACS_NoPictureA11yDesc"));
            this.rbNoPicture.setMnemonic(bundle.getString("CTL_NoPicture_Mnemonic").charAt(0));
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.rbNoPicture, gridBagConstraints);
            jLabel = new JLabel(bundle.getString("CTL_Null"));
            jPanel3.add(jLabel);
            jLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_NullA11yDesc"));
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbClasspath);
            buttonGroup.add(this.rbNoPicture);
            this.rbClasspath.setSelected(true);
            jPanel2.add((Component)jPanel3, "West");
            jPanel.add((Component)jPanel2, "North");
            jPanel2 = new JPanel(new BorderLayout(6, 6));
            JLabel jLabel2 = new JLabel(bundle.getString("CTL_ImageSourceName"));
            jLabel2.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ImageSourceNameA11yDesc"));
            jLabel2.setDisplayedMnemonic(bundle.getString("CTL_ImageSourceName_Mnemonic").charAt(0));
            jPanel2.add((Component)jLabel2, "West");
            this.tfName = new JTextField();
            jPanel2.add((Component)this.tfName, "Center");
            jLabel2.setLabelFor(this.tfName);
            this.tfName.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ImageSourceNameTextFieldA11yName"));
            this.tfName.setToolTipText(bundle.getString("ACS_ImageSourceNameTextFieldA11yDesc"));
            this.bSelect = new JButton("...");
            jPanel2.add((Component)this.bSelect, "East");
            this.bSelect.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ImageSourceNameBrowseButtonA11yName"));
            this.bSelect.setToolTipText(bundle.getString("ACS_ImageSourceNameBrowseButtonA11yDesc"));
            this.bSelect.setEnabled(false);
            jPanel.add((Component)jPanel2, "South");
            this.add((Component)jPanel, "North");
            this.spImage = new JScrollPane(){

                public Dimension getPreferredSize() {
                    return new Dimension(60, 60);
                }
            };
            this.add((Component)this.spImage, "Center");
            this.tfName.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    IconPanel.this.setValue();
                }
            });
            this.rbClasspath.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    IconPanel.this.bSelect.setEnabled(true);
                    IconPanel.this.tfName.setEnabled(true);
                    IconPanel.this.setValue();
                }
            });
            this.rbNoPicture.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    IconPanel.this.bSelect.setEnabled(false);
                    IconPanel.this.tfName.setEnabled(false);
                    IconPanel.this.setValue(null);
                    IconPanel.this.updateIcon();
                }
            });
            this.bSelect.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string;
                    if (IconPanel.this.rbClasspath.isSelected() && (string = IconPanel.this.selectResource()) != null) {
                        IconPanel.this.tfName.setText("/" + string);
                        IconPanel.this.setValue();
                    }
                }
            });
            propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            propertyEnv.addVetoableChangeListener((VetoableChangeListener)this);
            this.setValue(biIconEditor.getValue());
            this.updateIcon();
            HelpCtx.setHelpIDString((JComponent)this, (String)BiIconEditor.BEAN_ICONEDITOR_HELP);
            BiImageIcon biImageIcon = this.getValue();
            if (biImageIcon == null) {
                this.rbNoPicture.setSelected(true);
                this.bSelect.setEnabled(false);
                this.tfName.setEnabled(false);
                return;
            }
            this.rbClasspath.setSelected(true);
            this.bSelect.setEnabled(true);
            this.tfName.setText(biImageIcon.getName());
        }

        void updateIcon() {
            BiImageIcon biImageIcon = this.getValue();
            Icon icon = biImageIcon == null ? null : biImageIcon.getIcon();
            this.spImage.setViewportView(icon == null ? new JLabel() : new JLabel(icon));
            this.validate();
        }

        void setValue() {
            String string = this.tfName.getText();
            string.trim();
            if ("".equals(string)) {
                this.setValue(null);
                return;
            }
            try {
                this.setValue(this.editor.iconFromText(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.updateIcon();
        }

        private void setValue(BiImageIcon biImageIcon) {
            this.value = biImageIcon;
        }

        private BiImageIcon getValue() {
            return this.value;
        }

        private Object getPropertyValue(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            BiImageIcon biImageIcon = null;
            String string = this.tfName.getText().trim();
            if (this.rbClasspath.isSelected() && string.length() != 0) {
                ClassPath classPath = ClassPath.getClassPath((FileObject)this.editor.sourceFileObject, (String)"classpath/source");
                String string2 = string.charAt(0) != '/' ? string : string.substring(1);
                FileObject fileObject = classPath.findResource(string2);
                try {
                    biImageIcon = new BiImageIcon(fileObject.getURL(), string2);
                }
                catch (Throwable throwable) {
                    throw new PropertyVetoException(NbBundle.getMessage(IconPanel.class, (String)"CTL_Icon_not_exists", (Object)string), propertyChangeEvent);
                }
            }
            return biImageIcon;
        }

        @Override
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if ("state" == propertyChangeEvent.getPropertyName()) {
                BiImageIcon biImageIcon = (BiImageIcon)this.getPropertyValue(propertyChangeEvent);
                this.editor.setValue(biImageIcon);
            }
        }

        private List<FileObject> getRoots(ClassPath classPath) {
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>(classPath.entries().size());
            for (ClassPath.Entry entry : classPath.entries()) {
                URL uRL = entry.getURL();
                SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots((URL)uRL);
                FileObject[] fileObjectArray = result.getRoots();
                if (fileObjectArray.length > 0) {
                    for (int i = 0; i < fileObjectArray.length; ++i) {
                        arrayList.add(fileObjectArray[i]);
                    }
                    continue;
                }
                if (entry.getRoot() == null) continue;
                arrayList.add(entry.getRoot());
            }
            return arrayList;
        }

        private String rootDisplayName(FileObject fileObject) {
            return FileUtil.getFileDisplayName((FileObject)fileObject);
        }

        private String selectResource() {
            FileObject fileObject;
            DataObject dataObject;
            String string;
            Object object;
            FileObject fileObject2;
            Children.Array array;
            ClassPath classPath = ClassPath.getClassPath((FileObject)this.editor.sourceFileObject, (String)"classpath/execute");
            List list = classPath == null ? Collections.emptyList() : this.getRoots(classPath);
            Node[] nodeArray = new Node[list.size()];
            int n = -1;
            try {
                array = list.listIterator();
                while (array.hasNext()) {
                    fileObject2 = (FileObject)array.next();
                    object = DataObject.find((FileObject)fileObject2);
                    string = this.rootDisplayName(fileObject2);
                    nodeArray[array.previousIndex()] = new RootNode(object.getNodeDelegate(), string);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                return null;
            }
            array = new Children.Array();
            array.add(nodeArray);
            fileObject2 = new AbstractNode((Children)array);
            fileObject2.setIconBaseWithExtension("org/netbeans/modules/beans/resources/iconResourceRoot.gif");
            fileObject2.setDisplayName(bundle.getString("CTL_ClassPathName"));
            object = new ResourceSelector((Node)fileObject2);
            string = new DialogDescriptor(object, bundle.getString("CTL_OpenDialogName"));
            Object object2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)string);
            nodeArray = object2 == DialogDescriptor.OK_OPTION ? ((ResourceSelector)object).getNodes() : null;
            String string2 = null;
            if (nodeArray != null && nodeArray.length == 1 && (dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class)) != null && (fileObject = dataObject.getPrimaryFile()) != null) {
                if (classPath.contains(fileObject)) {
                    string2 = classPath.getResourceName(fileObject);
                } else {
                    ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                    string2 = classPath2.getResourceName(fileObject);
                }
            }
            return string2;
        }
    }

    public static final class BiImageIcon {
        private String name;
        private URL url;
        private Icon icon;

        public BiImageIcon() {
        }

        BiImageIcon(URL uRL, String string) {
            this.url = uRL;
            this.name = string;
        }

        String getName() {
            return this.name;
        }

        public Icon getIcon() {
            if (this.icon == null) {
                if (this.url == null) {
                    return this.icon;
                }
                try {
                    BufferedImage bufferedImage = ImageIO.read(this.url);
                    if (bufferedImage == null) {
                        return null;
                    }
                    this.icon = new ImageIcon(bufferedImage);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            return this.icon;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            BiImageIcon biImageIcon = (BiImageIcon)object;
            return this.name == biImageIcon.name || this.name != null && this.name.equals(biImageIcon.name);
        }
    }
}

