/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.fixes;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.jpa.model.JPAAnnotations;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemFinder;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreatePersistenceUnit;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnifyAccessType
implements Fix {
    private FileObject fileObject;
    private ElementHandle<TypeElement> classHandle;

    public UnifyAccessType(FileObject fileObject, ElementHandle<TypeElement> elementHandle) {
        this.classHandle = elementHandle;
        this.fileObject = fileObject;
    }

    public ChangeInfo implement() {
        CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement typeElement = (TypeElement)UnifyAccessType.this.classHandle.resolve((CompilationInfo)workingCopy);
                if (typeElement != null) {
                    for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                        VariableElement variableElement;
                        if (!executableElement.getSimpleName().toString().startsWith("get") || (variableElement = ModelUtils.getField(typeElement, ModelUtils.getFieldNameFromAccessor(executableElement.getSimpleName().toString()))) == null) continue;
                        MethodTree methodTree = workingCopy.getTrees().getTree(executableElement);
                        VariableTree variableTree = (VariableTree)workingCopy.getTrees().getTree(variableElement);
                        ModifiersTree modifiersTree = UnifyAccessType.this.getSourceModifiers(variableTree, methodTree);
                        LinkedList<AnnotationTree> linkedList = new LinkedList<AnnotationTree>();
                        LinkedList<? extends AnnotationTree> linkedList2 = new LinkedList<AnnotationTree>();
                        for (AnnotationTree annotationTree : modifiersTree.getAnnotations()) {
                            if (UnifyAccessType.this.isJPAAttrAnnotation((CompilationInfo)workingCopy, annotationTree)) {
                                linkedList2.add(annotationTree);
                                continue;
                            }
                            linkedList.add(annotationTree);
                        }
                        if (linkedList2.size() <= 0) continue;
                        TreeMaker treeMaker = workingCopy.getTreeMaker();
                        ModifiersTree modifiersTree2 = UnifyAccessType.this.getTargetModifiers(variableTree, methodTree);
                        workingCopy.rewrite((Tree)modifiersTree, (Tree)treeMaker.Modifiers(modifiersTree, linkedList));
                        linkedList2.addAll(modifiersTree2.getAnnotations());
                        workingCopy.rewrite((Tree)modifiersTree2, (Tree)treeMaker.Modifiers(modifiersTree2, linkedList2));
                    }
                }
            }
        };
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        try {
            javaSource.runModificationTask((Task)cancellableTask).commit();
        }
        catch (IOException iOException) {
            JPAProblemFinder.LOG.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        return null;
    }

    protected abstract ModifiersTree getSourceModifiers(VariableTree var1, MethodTree var2);

    protected abstract ModifiersTree getTargetModifiers(VariableTree var1, MethodTree var2);

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    private boolean isJPAAttrAnnotation(CompilationInfo compilationInfo, AnnotationTree annotationTree) {
        TreePath treePath = compilationInfo.getTrees().getPath(compilationInfo.getCompilationUnit(), annotationTree.getAnnotationType());
        Element element = compilationInfo.getTrees().getElement(treePath);
        String string = element.toString();
        return JPAAnnotations.MEMBER_LEVEL.contains(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnifyFieldAccess
    extends UnifyAccessType {
        public UnifyFieldAccess(FileObject fileObject, ElementHandle<TypeElement> elementHandle) {
            super(fileObject, elementHandle);
        }

        public String getText() {
            return NbBundle.getMessage(CreatePersistenceUnit.class, (String)"LBL_UnifyFieldAccess");
        }

        @Override
        protected ModifiersTree getSourceModifiers(VariableTree variableTree, MethodTree methodTree) {
            return methodTree.getModifiers();
        }

        @Override
        protected ModifiersTree getTargetModifiers(VariableTree variableTree, MethodTree methodTree) {
            return variableTree.getModifiers();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnifyPropertyAccess
    extends UnifyAccessType {
        public UnifyPropertyAccess(FileObject fileObject, ElementHandle<TypeElement> elementHandle) {
            super(fileObject, elementHandle);
        }

        public String getText() {
            return NbBundle.getMessage(CreatePersistenceUnit.class, (String)"LBL_UnifyPropertyAccess");
        }

        @Override
        protected ModifiersTree getSourceModifiers(VariableTree variableTree, MethodTree methodTree) {
            return variableTree.getModifiers();
        }

        @Override
        protected ModifiersTree getTargetModifiers(VariableTree variableTree, MethodTree methodTree) {
            return methodTree.getModifiers();
        }
    }
}

