/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.fixes;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.awt.Dialog;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.jpa.model.AccessType;
import org.netbeans.modules.j2ee.jpa.model.JPAHelper;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemFinder;
import org.netbeans.modules.j2ee.jpa.verification.common.Utilities;
import org.netbeans.modules.j2ee.jpa.verification.fixes.CreateRelationshipPanel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.ManyToMany;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.OneToMany;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.OneToOne;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCreateRelationshipHint
implements Fix {
    private FileObject fileObject;
    private FileObject targetFileObject;
    private ElementHandle<TypeElement> classHandle;
    private AccessType accessType;
    private String targetEntityClassName;
    private String localAttrName;
    private String annotationClass;
    private String complimentaryAnnotationClassName;
    private String relationName;
    private Collection<String> fieldsExistingAtTargetClass;
    private Collection<String> compatibleFieldsExistingAtTargetClass;

    public AbstractCreateRelationshipHint(FileObject fileObject, ElementHandle<TypeElement> elementHandle, AccessType accessType, String string, String string2, String string3, String string4) {
        this.classHandle = elementHandle;
        this.fileObject = fileObject;
        this.accessType = accessType;
        this.targetEntityClassName = string2;
        this.annotationClass = string3;
        this.complimentaryAnnotationClassName = string4;
        this.localAttrName = string;
        int n = string3.lastIndexOf(46);
        this.relationName = n > -1 ? string3.substring(n + 1) : string3;
    }

    public ChangeInfo implement() {
        this.examineTargetClass();
        boolean bl = this.isOwningSideByDefault();
        String string = this.getExistingFieldInRelation();
        if (string == null) {
            CreateRelationshipPanel createRelationshipPanel = new CreateRelationshipPanel();
            createRelationshipPanel.setEntityClassNames(Utilities.getShortClassName(this.classHandle.getQualifiedName()), Utilities.getShortClassName(this.targetEntityClassName));
            createRelationshipPanel.setAvailableSelection(this.getAvailableRelationTypeSelection());
            createRelationshipPanel.setAvailableFields(this.compatibleFieldsExistingAtTargetClass);
            createRelationshipPanel.setDefaultFieldName(this.genDefaultFieldName());
            createRelationshipPanel.setExistingFieldNames(this.fieldsExistingAtTargetClass);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)createRelationshipPanel, NbBundle.getMessage(AbstractCreateRelationshipHint.class, (String)"LBL_CreateRelationDlgTitle", (Object)this.relationName, (Object)this.targetEntityClassName));
            createRelationshipPanel.setDlgDescriptor(dialogDescriptor);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                String string2 = null;
                string2 = createRelationshipPanel.wasCreateNewFieldSelected() ? createRelationshipPanel.getNewIdName() : createRelationshipPanel.getSelectedField().toString();
                bl = createRelationshipPanel.owningSide();
                string = string2;
            } else {
                string = null;
            }
        } else {
            bl = false;
        }
        if (string != null) {
            this.modifyFiles(bl, string);
        }
        return null;
    }

    private void examineTargetClass() {
        this.fieldsExistingAtTargetClass = new TreeSet<String>();
        this.compatibleFieldsExistingAtTargetClass = new TreeSet<String>();
        CancellableTask<CompilationController> cancellableTask = new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            public void run(CompilationController compilationController) throws Exception {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = compilationController.getElements().getTypeElement(AbstractCreateRelationshipHint.this.targetEntityClassName);
                assert (typeElement != null);
                AbstractCreateRelationshipHint.this.targetFileObject = SourceUtils.getFile((Element)typeElement, (ClasspathInfo)compilationController.getClasspathInfo());
                for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
                    AbstractCreateRelationshipHint.this.fieldsExistingAtTargetClass.add(variableElement.getSimpleName().toString());
                    TypeMirror typeMirror = variableElement.asType();
                    Element element = null;
                    if (AbstractCreateRelationshipHint.this.isMultiValuedAtTargetEntity()) {
                        List<? extends TypeMirror> list;
                        if (typeMirror.getKind() == TypeKind.DECLARED && (list = ((DeclaredType)typeMirror).getTypeArguments()).size() == 1) {
                            element = compilationController.getTypes().asElement(list.get(0));
                        }
                    } else {
                        element = compilationController.getTypes().asElement(typeMirror);
                    }
                    if (element == null || element.getKind() != ElementKind.CLASS || !((TypeElement)element).getQualifiedName().contentEquals(AbstractCreateRelationshipHint.this.classHandle.getQualifiedName())) continue;
                    AbstractCreateRelationshipHint.this.compatibleFieldsExistingAtTargetClass.add(variableElement.getSimpleName().toString());
                }
            }
        };
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        try {
            javaSource.runUserActionTask((Task)cancellableTask, true);
        }
        catch (IOException iOException) {
            JPAProblemFinder.LOG.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
    }

    private String getExistingFieldInRelation() {
        String string = null;
        try {
            MetadataModel<EntityMappingsMetadata> metadataModel = ModelUtils.getModel(this.fileObject);
            string = (String)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, String>(){

                public String run(EntityMappingsMetadata entityMappingsMetadata) {
                    Entity entity = ModelUtils.getEntity(entityMappingsMetadata, AbstractCreateRelationshipHint.this.targetEntityClassName);
                    assert (entity != null);
                    if (AbstractCreateRelationshipHint.this.complimentaryAnnotationClassName.equals("javax.persistence.OneToOne")) {
                        return AbstractCreateRelationshipHint.this.getMappedByFromOneToOne(entity);
                    }
                    if (AbstractCreateRelationshipHint.this.complimentaryAnnotationClassName.equals("javax.persistence.ManyToMany")) {
                        return AbstractCreateRelationshipHint.this.getMappedByFromManyToMany(entity);
                    }
                    if (AbstractCreateRelationshipHint.this.complimentaryAnnotationClassName.equals("javax.persistence.OneToMany")) {
                        return AbstractCreateRelationshipHint.this.getMappedByFromOneToMany(entity);
                    }
                    return null;
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            JPAProblemFinder.LOG.log(Level.SEVERE, metadataModelException.getMessage(), metadataModelException);
        }
        catch (IOException iOException) {
            JPAProblemFinder.LOG.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        return string;
    }

    private String getMappedByFromOneToOne(Entity entity) {
        for (OneToOne oneToOne : entity.getAttributes().getOneToOne()) {
            if (!this.classHandle.getQualifiedName().equals(oneToOne.getTargetEntity()) || !this.localAttrName.equals(oneToOne.getMappedBy())) continue;
            return oneToOne.getName();
        }
        return null;
    }

    private String getMappedByFromManyToMany(Entity entity) {
        for (ManyToMany manyToMany : entity.getAttributes().getManyToMany()) {
            if (!this.classHandle.getQualifiedName().equals(manyToMany.getTargetEntity()) || !this.localAttrName.equals(manyToMany.getMappedBy())) continue;
            return manyToMany.getName();
        }
        return null;
    }

    private String getMappedByFromOneToMany(Entity entity) {
        for (OneToMany oneToMany : entity.getAttributes().getOneToMany()) {
            if (!this.classHandle.getQualifiedName().equals(oneToMany.getTargetEntity()) || !this.localAttrName.equals(oneToMany.getMappedBy())) continue;
            return oneToMany.getName();
        }
        return null;
    }

    private void modifyFiles(final boolean bl, final String string) {
        CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                if (AbstractCreateRelationshipHint.this.fileObject.equals(workingCopy.getFileObject()) && AbstractCreateRelationshipHint.this.targetFileObject.equals(workingCopy.getFileObject())) {
                    AbstractCreateRelationshipHint.this.modifyLocalClass(workingCopy, string, bl);
                    AbstractCreateRelationshipHint.this.modifyTargetClass(workingCopy, string, !bl);
                } else if (AbstractCreateRelationshipHint.this.fileObject.equals(workingCopy.getFileObject())) {
                    AbstractCreateRelationshipHint.this.modifyLocalClass(workingCopy, string, bl);
                } else {
                    AbstractCreateRelationshipHint.this.modifyTargetClass(workingCopy, string, !bl);
                }
            }
        };
        ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)this.fileObject);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[]{this.fileObject, this.targetFileObject});
        try {
            javaSource.runModificationTask((Task)cancellableTask).commit();
        }
        catch (IOException iOException) {
            JPAProblemFinder.LOG.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
    }

    private void modifyLocalClass(WorkingCopy workingCopy, String string, boolean bl) throws IOException {
        TypeElement typeElement = (TypeElement)this.classHandle.resolve((CompilationInfo)workingCopy);
        GenerationUtils generationUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
        List<Object> list = null;
        list = !bl ? Collections.singletonList(generationUtils.createAnnotationArgument("mappedBy", (Object)string)) : Collections.emptyList();
        AnnotationTree annotationTree = generationUtils.createAnnotation(this.annotationClass, list);
        if (this.accessType == AccessType.FIELD) {
            VariableElement variableElement = ModelUtils.getField(typeElement, this.localAttrName);
            VariableTree variableTree = (VariableTree)workingCopy.getTrees().getTree(variableElement);
            VariableTree variableTree2 = generationUtils.addAnnotation(variableTree, annotationTree);
            workingCopy.rewrite((Tree)variableTree, (Tree)variableTree2);
        } else {
            ExecutableElement executableElement = ModelUtils.getAccesor(typeElement, this.localAttrName);
            MethodTree methodTree = workingCopy.getTrees().getTree(executableElement);
            MethodTree methodTree2 = generationUtils.addAnnotation(methodTree, annotationTree);
            workingCopy.rewrite((Tree)methodTree, (Tree)methodTree2);
        }
    }

    private void modifyTargetClass(WorkingCopy workingCopy, String string, boolean bl) throws IOException {
        Tree tree;
        Tree tree2;
        List<ExpressionTree> list;
        Object object;
        TypeElement typeElement = workingCopy.getElements().getTypeElement(this.targetEntityClassName);
        assert (typeElement != null);
        ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
        GenerationUtils generationUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
        String string2 = this.classHandle.getQualifiedName();
        if (this.isMultiValuedAtTargetEntity()) {
            string2 = String.format("java.util.List<%s>", string2);
        }
        VariableTree variableTree = null;
        VariableElement variableElement = ModelUtils.getField(typeElement, string);
        MethodTree methodTree = this.resolveAccessor(variableElement, typeElement, workingCopy);
        ClassTree classTree2 = classTree;
        if (variableElement != null) {
            variableTree = (VariableTree)workingCopy.getTrees().getTree(variableElement);
        } else {
            object = workingCopy.getTreeMaker().Modifiers(Collections.singleton(Modifier.PRIVATE));
            variableTree = generationUtils.createField(typeElement, object, string, string2, null);
            classTree2 = generationUtils.addClassFields(classTree, Collections.singletonList(variableTree));
        }
        object = this.findTargetEntityAccessType(typeElement);
        if (AccessType.PROPERTY == object) {
            list = this.resolveMutator(variableElement, typeElement, workingCopy);
            tree2 = workingCopy.getTreeMaker().Modifiers(Collections.singleton(Modifier.PUBLIC));
            if (methodTree == null) {
                methodTree = generationUtils.createPropertyGetterMethod(typeElement, tree2, string, string2);
                classTree2 = workingCopy.getTreeMaker().addClassMember(classTree2, (Tree)methodTree);
            }
            if (list == null) {
                tree = generationUtils.createPropertySetterMethod(typeElement, tree2, string, string2);
                classTree2 = workingCopy.getTreeMaker().addClassMember(classTree2, tree);
            }
        }
        workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
        list = null;
        list = !bl ? Collections.singletonList(generationUtils.createAnnotationArgument("mappedBy", (Object)this.localAttrName)) : Collections.emptyList();
        tree2 = generationUtils.createAnnotation(this.complimentaryAnnotationClassName, list);
        if (object == AccessType.FIELD) {
            tree = generationUtils.addAnnotation(variableTree, (AnnotationTree)tree2);
            workingCopy.rewrite((Tree)variableTree, tree);
        } else {
            tree = generationUtils.addAnnotation(methodTree, (AnnotationTree)tree2);
            workingCopy.rewrite((Tree)methodTree, tree);
        }
    }

    private MethodTree resolveAccessor(VariableElement variableElement, TypeElement typeElement, WorkingCopy workingCopy) {
        return this.resolvePropertyMethod(variableElement, typeElement, workingCopy, true);
    }

    private MethodTree resolveMutator(VariableElement variableElement, TypeElement typeElement, WorkingCopy workingCopy) {
        return this.resolvePropertyMethod(variableElement, typeElement, workingCopy, false);
    }

    private MethodTree resolvePropertyMethod(VariableElement variableElement, TypeElement typeElement, WorkingCopy workingCopy, boolean bl) {
        if (variableElement == null) {
            return null;
        }
        VariableTree variableTree = (VariableTree)workingCopy.getTrees().getTree(variableElement);
        ExecutableElement executableElement = bl ? ModelUtils.getAccesor(typeElement, variableTree.getName().toString()) : ModelUtils.getMutator((CompilationInfo)workingCopy, typeElement, variableElement);
        return executableElement == null ? null : workingCopy.getTrees().getTree(executableElement);
    }

    private AccessType findTargetEntityAccessType(final TypeElement typeElement) {
        AccessType accessType = AccessType.INDETERMINED;
        try {
            MetadataModel<EntityMappingsMetadata> metadataModel = ModelUtils.getModel(this.fileObject);
            accessType = (AccessType)((Object)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, AccessType>(){

                public AccessType run(EntityMappingsMetadata entityMappingsMetadata) {
                    Entity entity = ModelUtils.getEntity(entityMappingsMetadata, AbstractCreateRelationshipHint.this.targetEntityClassName);
                    assert (entity != null);
                    return JPAHelper.findAccessType(typeElement, entity);
                }
            }));
        }
        catch (MetadataModelException metadataModelException) {
            JPAProblemFinder.LOG.log(Level.SEVERE, metadataModelException.getMessage(), metadataModelException);
        }
        catch (IOException iOException) {
            JPAProblemFinder.LOG.log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        return accessType;
    }

    protected String genDefaultFieldName() {
        String string = Utilities.getShortClassName(this.classHandle.getQualifiedName());
        char c = Character.toLowerCase(string.charAt(0));
        string = c + string.substring(1);
        if (this.isMultiValuedAtTargetEntity()) {
            string = string + "s";
        }
        String string2 = null;
        int n = 0;
        do {
            string2 = string + (n == 0 ? "" : Integer.valueOf(n));
            ++n;
        } while (this.fieldsExistingAtTargetClass.contains(string2));
        return string2;
    }

    public String getText() {
        return NbBundle.getMessage(AbstractCreateRelationshipHint.class, (String)"LBL_CreateRelationHint", (Object)this.relationName);
    }

    protected boolean isOwningSideByDefault() {
        return this.getAvailableRelationTypeSelection() != CreateRelationshipPanel.AvailableSelection.INVERSE_ONLY;
    }

    protected CreateRelationshipPanel.AvailableSelection getAvailableRelationTypeSelection() {
        return CreateRelationshipPanel.AvailableSelection.BOTH;
    }

    protected boolean isMultiValuedAtTargetEntity() {
        return "javax.persistence.ManyToMany".equals(this.complimentaryAnnotationClassName) || "javax.persistence.OneToMany".equals(this.complimentaryAnnotationClassName);
    }

    protected boolean isMultiValuedAtLocalEntity() {
        return "javax.persistence.ManyToMany".equals(this.annotationClass) || "javax.persistence.ManyToOne".equals(this.annotationClass);
    }
}

