/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.EngineStatement;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.Util;

public class EmbedStatement
extends ConnectionChild
implements EngineStatement {
    private final Connection applicationConnection;
    protected EngineStatement applicationStatement;
    int updateCount = -1;
    ResultSet results;
    private ResultSet autoGeneratedKeysResultSet;
    private String cursorName;
    private final boolean forMetaData;
    final int resultSetType;
    private final int resultSetConcurrency;
    private final int resultSetHoldability;
    final LanguageConnectionContext lcc;
    private SQLWarning warnings;
    String SQLText;
    private int fetchSize = 1;
    private int fetchDirection = 1000;
    int MaxFieldSize;
    private int timeoutSeconds;
    private boolean active = true;
    Vector batchStatements;
    int maxRows;
    private ParameterValueSet pvs;
    protected boolean isPoolable = false;
    private EmbedResultSet[] dynamicResults;
    private int currentDynamicResultSet;

    public EmbedStatement(EmbedConnection embedConnection, boolean bl, int n, int n2, int n3) {
        super(embedConnection);
        this.forMetaData = bl;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.resultSetHoldability = n3;
        this.lcc = this.getEmbedConnection().getLanguageConnection();
        this.applicationConnection = this.getEmbedConnection().getApplicationConnection();
        this.applicationStatement = this;
        this.timeoutSeconds = 0;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        this.execute(string, true, false, 2, null, null);
        return this.results;
    }

    public int executeUpdate(String string) throws SQLException {
        this.execute(string, false, true, 2, null, null);
        return this.updateCount;
    }

    public int executeUpdate(String string, int n) throws SQLException {
        this.execute(string, false, true, n, null, null);
        return this.updateCount;
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw Util.notImplemented("executeUpdate(String, int[])");
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw Util.notImplemented("executeUpdate(String, String[])");
    }

    final void checkIfInMiddleOfBatch() throws SQLException {
        if (this.batchStatements != null) {
            throw this.newSQLException("XJ068.S");
        }
    }

    public boolean isClosed() throws SQLException {
        if (this.active) {
            try {
                this.checkExecStatus();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return !this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws SQLException {
        if (!this.active) {
            return;
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.closeActions();
            this.active = false;
            this.clearResultSets();
            this.cursorName = null;
            this.warnings = null;
            this.SQLText = null;
            this.batchStatements = null;
        }
    }

    void closeActions() throws SQLException {
    }

    public int getMaxFieldSize() throws SQLException {
        this.checkStatus();
        return this.MaxFieldSize;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.checkStatus();
        if (n < 0) {
            throw this.newSQLException("XJ066.S", new Integer(n));
        }
        this.MaxFieldSize = n;
    }

    public int getMaxRows() throws SQLException {
        this.checkStatus();
        return this.maxRows;
    }

    public void setMaxRows(int n) throws SQLException {
        this.checkStatus();
        if (n < 0) {
            throw this.newSQLException("XJ063.S", new Integer(n));
        }
        this.maxRows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkStatus();
    }

    public final int getQueryTimeout() throws SQLException {
        this.checkStatus();
        return this.timeoutSeconds;
    }

    public final void setQueryTimeout(int n) throws SQLException {
        this.checkStatus();
        if (n < 0) {
            throw this.newSQLException("XJ074.S", new Integer(n));
        }
        this.timeoutSeconds = n;
    }

    public void cancel() throws SQLException {
        throw Util.notImplemented("cancel");
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkStatus();
        return this.warnings;
    }

    public void clearWarnings() throws SQLException {
        this.checkStatus();
        this.warnings = null;
    }

    public void setCursorName(String string) throws SQLException {
        this.checkStatus();
        this.cursorName = string;
    }

    public boolean execute(String string) throws SQLException {
        return this.execute(string, false, false, 2, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute(String string, boolean bl, boolean bl2, int n, int[] nArray, String[] stringArray) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            boolean bl3;
            this.checkExecStatus();
            if (string == null) {
                throw this.newSQLException("XJ067.S");
            }
            this.checkIfInMiddleOfBatch();
            this.clearResultSets();
            this.setupContextStack();
            this.SQLText = string;
            try {
                Activation activation;
                try {
                    PreparedStatement preparedStatement = this.lcc.prepareInternalStatement(this.lcc.getDefaultSchema(), string, this.resultSetConcurrency == 1007, false);
                    activation = preparedStatement.getActivation(this.lcc, this.resultSetType == 1004);
                    this.checkRequiresCallableStatement(activation);
                }
                catch (Throwable throwable) {
                    throw this.handleException(throwable);
                }
                activation.setSingleExecution();
                if (n == 1) {
                    activation.setAutoGeneratedKeysResultsetInfo(nArray, stringArray);
                }
                bl3 = this.executeStatement(activation, bl, bl2);
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return bl3;
        }
    }

    public boolean execute(String string, int n) throws SQLException {
        return this.execute(string, false, false, n, null, null);
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        throw Util.notImplemented("execute(String, int[])");
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw Util.notImplemented("execute(String, String[])");
    }

    public final ResultSet getResultSet() throws SQLException {
        this.checkStatus();
        return this.results;
    }

    public final int getUpdateCount() throws SQLException {
        this.checkStatus();
        return this.updateCount;
    }

    public final boolean getMoreResults() throws SQLException {
        return this.getMoreResults(3);
    }

    public final int getResultSetType() throws SQLException {
        this.checkStatus();
        return this.resultSetType;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.checkStatus();
        if (n != 1000 && n != 1001 && n != 1002) {
            throw this.newSQLException("XJ064.S", new Integer(n));
        }
        this.fetchDirection = n;
    }

    public int getFetchDirection() throws SQLException {
        this.checkStatus();
        return this.fetchDirection;
    }

    public void setFetchSize(int n) throws SQLException {
        this.checkStatus();
        if (n < 0 || this.getMaxRows() != 0 && n > this.getMaxRows()) {
            throw this.newSQLException("XJ065.S", new Integer(n));
        }
        if (n > 0) {
            this.fetchSize = n;
        }
    }

    public int getFetchSize() throws SQLException {
        this.checkStatus();
        return this.fetchSize;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.checkStatus();
        return this.resultSetConcurrency;
    }

    public final int getResultSetHoldability() throws SQLException {
        this.checkStatus();
        return this.resultSetHoldability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch(String string) throws SQLException {
        this.checkStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.batchStatements == null) {
                this.batchStatements = new Vector();
            }
            this.batchStatements.addElement(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearBatch() throws SQLException {
        this.checkStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.batchStatements = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            SQLException sQLException;
            int n;
            this.setupContextStack();
            this.clearResultSets();
            Vector vector = this.batchStatements;
            this.batchStatements = null;
            int n2 = vector == null ? 0 : vector.size();
            int[] nArray = new int[n2];
            try {
                for (n = 0; n < n2; ++n) {
                    if (this.executeBatchElement(vector.elementAt(n))) {
                        throw this.newSQLException("XJ04B.S");
                    }
                    nArray[n] = this.getUpdateCount();
                }
                int[] nArray2 = nArray;
                return nArray2;
            }
            catch (StandardException standardException) {
                sQLException = this.handleException(standardException);
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            finally {
                this.restoreContextStack();
            }
            int[] nArray3 = new int[n];
            int n3 = 0;
            while (true) {
                if (n3 >= n) {
                    BatchUpdateException batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray3);
                    batchUpdateException.setNextException(sQLException);
                    throw batchUpdateException;
                }
                nArray3[n3] = nArray[n3];
                ++n3;
            }
        }
    }

    boolean executeBatchElement(Object object) throws SQLException, StandardException {
        return this.execute((String)object, false, true, 2, null, null);
    }

    public final Connection getConnection() throws SQLException {
        this.checkStatus();
        Connection connection = this.getEmbedConnection().getApplicationConnection();
        if (connection != this.applicationConnection || connection == null) {
            throw Util.noCurrentConnection();
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getMoreResults(int n) throws SQLException {
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.dynamicResults == null) {
                this.clearResultSets();
                return false;
            }
            switch (n) {
                default: {
                    int n2 = 0;
                    break;
                }
                case 1: {
                    int n2 = this.currentDynamicResultSet;
                    break;
                }
                case 2: {
                    int n2 = this.dynamicResults.length;
                }
            }
            SQLException sQLException = null;
            for (int i = n2; i <= this.currentDynamicResultSet && i < this.dynamicResults.length; ++i) {
                EmbedResultSet embedResultSet = this.dynamicResults[i];
                if (embedResultSet == null) continue;
                try {
                    embedResultSet.close();
                    continue;
                }
                catch (SQLException sQLException2) {
                    if (sQLException == null) {
                        sQLException = sQLException2;
                        continue;
                    }
                    sQLException.setNextException(sQLException2);
                    continue;
                }
                finally {
                    this.dynamicResults[i] = null;
                }
            }
            if (sQLException != null) {
                throw sQLException;
            }
            this.updateCount = -1;
            while (++this.currentDynamicResultSet < this.dynamicResults.length) {
                EmbedResultSet embedResultSet = this.dynamicResults[this.currentDynamicResultSet];
                if (embedResultSet == null) continue;
                if (embedResultSet.isClosed) {
                    this.dynamicResults[this.currentDynamicResultSet] = null;
                    continue;
                }
                this.results = embedResultSet;
                return true;
            }
            this.results = null;
            return false;
        }
    }

    public final ResultSet getGeneratedKeys() throws SQLException {
        this.checkStatus();
        if (this.autoGeneratedKeysResultSet == null) {
            return null;
        }
        this.execute("VALUES IDENTITY_VAL_LOCAL()", true, false, 2, null, null);
        return this.results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeStatement(Activation activation, boolean bl, boolean bl2) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            boolean bl3;
            this.setupContextStack();
            this.pvs = activation.getParameterValueSet();
            try {
                if (this.results != null) {
                    this.results.close();
                    this.results = null;
                }
                this.clearWarnings();
                if (!this.forMetaData) {
                    this.commitIfNeeded();
                    this.needCommit();
                } else if (this.lcc.getActivationCount() <= 1) {
                    this.commitIfNeeded();
                    this.needCommit();
                }
                ExecPreparedStatement execPreparedStatement = activation.getPreparedStatement();
                execPreparedStatement.rePrepare(this.lcc);
                this.addWarning(execPreparedStatement.getCompileTimeWarnings());
                if (this.cursorName != null) {
                    activation.setCursorName(this.cursorName);
                }
                boolean bl4 = this.getExecuteHoldable();
                activation.setResultSetHoldability(bl4);
                activation.reset();
                activation.setMaxRows(this.maxRows);
                long l = (long)this.timeoutSeconds * 1000L;
                org.apache.derby.iapi.sql.ResultSet resultSet = execPreparedStatement.execute(activation, false, l);
                this.addWarning(activation.getWarnings());
                if (resultSet.returnsRows()) {
                    if (bl2) {
                        throw StandardException.newException("X0Y79.S");
                    }
                    EmbedResultSet embedResultSet = this.factory.newEmbedResultSet(this.getEmbedConnection(), resultSet, this.forMetaData, this, execPreparedStatement.isAtomic());
                    this.results = embedResultSet;
                    if (activation.isSingleExecution()) {
                        embedResultSet.singleUseActivation = activation;
                    }
                    this.updateCount = -1;
                    bl3 = true;
                } else {
                    if (activation.getAutoGeneratedKeysResultsetMode() && resultSet.getAutoGeneratedKeysResultset() != null) {
                        resultSet.getAutoGeneratedKeysResultset().open();
                        this.autoGeneratedKeysResultSet = this.factory.newEmbedResultSet(this.getEmbedConnection(), resultSet.getAutoGeneratedKeysResultset(), false, this, execPreparedStatement.isAtomic());
                    }
                    this.updateCount = resultSet.modifiedRowCount();
                    resultSet.finish();
                    this.results = null;
                    int n = 0;
                    if (activation.getDynamicResults() != null) {
                        n = this.processDynamicResults(activation.getDynamicResults(), activation.getMaxDynamicResults());
                    }
                    if (bl && n != 1) {
                        throw StandardException.newException("X0Y78.S");
                    }
                    if (bl2 && n > 0) {
                        throw StandardException.newException("X0Y79.S");
                    }
                    if (n == 0) {
                        if (activation.isSingleExecution()) {
                            activation.close();
                        }
                        if (!this.forMetaData) {
                            this.commitIfNeeded();
                        } else if (this.lcc.getActivationCount() <= 1) {
                            this.commitIfNeeded();
                        }
                    }
                    bl3 = n > 0;
                }
            }
            catch (Throwable throwable) {
                if (activation.isSingleExecution()) {
                    try {
                        activation.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                throw this.handleException(throwable);
            }
            finally {
                this.restoreContextStack();
            }
            return bl3;
        }
    }

    final void addWarning(SQLWarning sQLWarning) {
        if (sQLWarning != null) {
            if (this.warnings == null) {
                this.warnings = sQLWarning;
            } else {
                this.warnings.setNextException(sQLWarning);
            }
        }
    }

    public String getSQLText() {
        return this.SQLText;
    }

    public ParameterValueSet getParameterValueSet() {
        return this.pvs;
    }

    final void checkStatus() throws SQLException {
        if (!this.active) {
            Connection connection = this.getEmbedConnection().getApplicationConnection();
            if (connection == null || connection.isClosed()) {
                throw Util.noCurrentConnection();
            }
            throw this.newSQLException("XJ012.S", "Statement");
        }
    }

    final void checkExecStatus() throws SQLException {
        if (!this.getConnection().isClosed()) {
            return;
        }
        this.active = false;
        throw Util.noCurrentConnection();
    }

    void clearResultSets() throws SQLException {
        SQLException sQLException = null;
        try {
            if (this.results != null) {
                this.results.close();
                this.results = null;
            }
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
        }
        try {
            if (this.autoGeneratedKeysResultSet != null) {
                this.autoGeneratedKeysResultSet.close();
                this.autoGeneratedKeysResultSet = null;
            }
        }
        catch (SQLException sQLException3) {
            if (sQLException == null) {
                sQLException = sQLException3;
            }
            sQLException.setNextException(sQLException3);
        }
        if (this.dynamicResults != null) {
            for (int i = 0; i < this.dynamicResults.length; ++i) {
                EmbedResultSet embedResultSet = this.dynamicResults[i];
                if (embedResultSet == null) continue;
                try {
                    embedResultSet.close();
                    continue;
                }
                catch (SQLException sQLException4) {
                    if (sQLException == null) {
                        sQLException = sQLException4;
                        continue;
                    }
                    sQLException.setNextException(sQLException4);
                }
            }
            this.dynamicResults = null;
        }
        this.updateCount = -1;
        if (sQLException != null) {
            throw sQLException;
        }
    }

    void checkRequiresCallableStatement(Activation activation) throws SQLException {
        ParameterValueSet parameterValueSet = activation.getParameterValueSet();
        if (parameterValueSet == null) {
            return;
        }
        if (parameterValueSet.checkNoDeclaredOutputParameters()) {
            try {
                activation.close();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            throw this.newSQLException("XJ009.S", this.SQLText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferBatch(EmbedStatement embedStatement) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            embedStatement.batchStatements = this.batchStatements;
            this.batchStatements = null;
        }
    }

    public final void setApplicationStatement(EngineStatement engineStatement) {
        this.applicationStatement = engineStatement;
    }

    private int processDynamicResults(ResultSet[][] resultSetArray, int n) throws SQLException {
        int n2;
        Object[] objectArray = new EmbedResultSet[resultSetArray.length];
        int n3 = 0;
        for (n2 = 0; n2 < resultSetArray.length; ++n2) {
            ResultSet[] resultSetArray2 = resultSetArray[n2];
            if (resultSetArray2[0] == null) continue;
            ResultSet resultSet = resultSetArray2[0];
            resultSetArray2[0] = null;
            if (!(resultSet instanceof EmbedResultSet)) continue;
            EmbedResultSet embedResultSet = (EmbedResultSet)resultSet;
            if (embedResultSet.getEmbedConnection().rootConnection != this.getEmbedConnection().rootConnection || embedResultSet.isClosed) continue;
            embedResultSet.setDynamicResultSet(this);
            objectArray[n3++] = embedResultSet;
        }
        if (n3 != 0) {
            if (n3 != 1) {
                Arrays.sort(objectArray, 0, n3);
            }
            this.dynamicResults = objectArray;
            if (n3 > n) {
                this.addWarning(StandardException.newWarning("0100E"));
                for (n2 = n; n2 < n3; ++n2) {
                    ((EmbedResultSet)objectArray[n2]).close();
                    objectArray[n2] = null;
                }
                n3 = n;
            }
            this.updateCount = -1;
            this.results = objectArray[0];
            this.currentDynamicResultSet = 0;
        }
        return n3;
    }

    void resultSetClosing(EmbedResultSet embedResultSet) throws SQLException {
        if (!this.getEmbedConnection().autoCommit) {
            return;
        }
        if (this.dynamicResults != null) {
            for (int i = 0; i < this.dynamicResults.length; ++i) {
                EmbedResultSet embedResultSet2 = this.dynamicResults[i];
                if (embedResultSet2 == null || embedResultSet2.isClosed || embedResultSet2 == embedResultSet) continue;
                return;
            }
        }
        this.commitIfAutoCommit();
    }

    private boolean getExecuteHoldable() throws SQLException {
        if (this.resultSetHoldability == 2) {
            return false;
        }
        if (this.applicationStatement == this) {
            return true;
        }
        return this.applicationStatement.getResultSetHoldability() == 1;
    }

    public boolean isPoolable() throws SQLException {
        this.checkStatus();
        return this.isPoolable;
    }

    public void setPoolable(boolean bl) throws SQLException {
        this.checkStatus();
        this.isPoolable = bl;
    }
}

