/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import junit.framework.TestResult;
import org.netbeans.junit.MultiTestCase;
import org.netbeans.junit.NbTestSuite;

public abstract class MultiTestSuite
extends NbTestSuite {
    private Throwable err = null;

    public MultiTestSuite() {
        this.setName(this.getClass().getSimpleName());
    }

    public MultiTestSuite(String string) {
        super(string);
    }

    protected abstract MultiTestCase nextTestCase();

    public void run(TestResult testResult) {
        if (this.isPrepared()) {
            this.runAllTests(testResult);
            this.cleanit();
        }
        if (this.gotFailed()) {
            this.createFailLog(testResult);
        }
    }

    protected void runAllTests(TestResult testResult) {
        MultiTestCase multiTestCase = null;
        while ((multiTestCase = this.nextTestCase()) != null) {
            this.runTest(multiTestCase, testResult);
        }
    }

    public void prepare() {
    }

    public void cleanup() {
    }

    private final boolean isPrepared() {
        boolean bl = false;
        try {
            this.prepare();
            bl = true;
        }
        catch (Throwable throwable) {
            this.err = throwable;
            System.out.println("Exception occured while preparing for test " + this.getName() + ": " + throwable.toString());
            throwable.printStackTrace();
        }
        return bl;
    }

    private final void cleanit() {
        try {
            this.cleanup();
        }
        catch (Throwable throwable) {
            this.err = throwable;
            System.out.println("Exception occured while cleaning after test " + this.getName() + ": " + throwable.toString());
            throwable.printStackTrace();
        }
    }

    private final boolean gotFailed() {
        return this.err != null;
    }

    private final void createFailLog(TestResult testResult) {
        String string = this.getName() + "FailLog";
        MultiTestCase multiTestCase = new MultiTestCase(){

            public void execute() {
            }
        };
        multiTestCase.setName(string);
        multiTestCase.setError(this.err);
        this.runTest(multiTestCase, testResult);
    }
}

