/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.model;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.ruby.debugger.ContextProviderWrapper;
import org.netbeans.modules.ruby.debugger.RubySession;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;
import org.rubyforge.debugcommons.model.RubyValue;
import org.rubyforge.debugcommons.model.RubyVariable;

public class VariablesModel
implements TreeModel,
ExtendedNodeModel,
TableModel {
    private static final String GLOBAL = "Global Variables";
    public static final String LOCAL = "org/netbeans/modules/debugger/resources/localsView/local_variable_16.png";
    public static final String CLASS = "org/netbeans/modules/debugger/resources/watchesView/SuperVariable.gif";
    protected final RubySession rubySession;
    protected final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public VariablesModel(ContextProvider contextProvider) {
        this.rubySession = new ContextProviderWrapper(contextProvider).getRubySession();
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (!this.rubySession.isSessionSuspended()) {
            return new Object[0];
        }
        if (object == "Root") {
            RubyVariable[] rubyVariableArray = this.rubySession.getVariables();
            Object[] objectArray = new Object[rubyVariableArray.length + 1];
            objectArray[0] = GLOBAL;
            System.arraycopy(rubyVariableArray, 0, objectArray, 1, rubyVariableArray.length);
            return objectArray;
        }
        if (object == GLOBAL) {
            return this.rubySession.getGlobalVariables();
        }
        if (object instanceof RubyVariable) {
            return this.rubySession.getChildren((RubyVariable)object);
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root" || object == GLOBAL) {
            return false;
        }
        if (object instanceof RubyVariable) {
            RubyValue rubyValue = ((RubyVariable)object).getValue();
            return rubyValue == null || !rubyValue.hasVariables();
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (!this.rubySession.isSessionSuspended()) {
            return 0;
        }
        if (object == "Root") {
            return this.rubySession.getVariables().length + 1;
        }
        if (object == GLOBAL) {
            return this.rubySession.getGlobalVariables().length;
        }
        if (object instanceof RubyVariable) {
            return this.rubySession.getChildren((RubyVariable)object).length;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public void fireChanges() {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return VariablesModel.getMessage("CTL_VariablesModel.Column.Name.Name");
        }
        if (object == GLOBAL) {
            return VariablesModel.getMessage("CTL_VariablesModel.Global.Variables");
        }
        if (object instanceof RubyVariable) {
            String string = ((RubyVariable)object).getName();
            assert (string != null) : "null name for the RubyVariable: " + object;
            return string;
        }
        assert (object != null) : "null node passed to VariablesModel.getDisplayName()";
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getIconBaseWithExtension(Object object) throws UnknownTypeException {
        assert (object != "Root");
        if (object == GLOBAL) {
            return CLASS;
        }
        if (object instanceof RubyVariable) {
            if (((RubyVariable)object).isClass()) {
                return CLASS;
            }
            return LOCAL;
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object == GLOBAL) {
            return VariablesModel.getMessage("CTL_VariablesModel.Global.Variables.Short.Description");
        }
        if (object == "Root") {
            return VariablesModel.getMessage("CTL_VariablesModel.Column.Name.Desc");
        }
        if (object instanceof RubyVariable) {
            RubyValue rubyValue = ((RubyVariable)object).getValue();
            return '(' + rubyValue.getReferenceTypeName() + ") " + rubyValue.getValueString();
        }
        throw new UnknownTypeException(object);
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object == GLOBAL) {
            return "";
        }
        if (object instanceof RubyVariable) {
            RubyVariable rubyVariable = (RubyVariable)object;
            if (rubyVariable.getValue() == null) {
                return "<nil>";
            }
            if ("LocalsValue".equals(string)) {
                return rubyVariable.getValue().getValueString();
            }
            if ("LocalsType".equals(string)) {
                return rubyVariable.getValue().getReferenceTypeName();
            }
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        return true;
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        throw new UnknownTypeException(object);
    }

    public boolean canRename(Object object) throws UnknownTypeException {
        return false;
    }

    public boolean canCopy(Object object) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(Object object) throws UnknownTypeException {
        return false;
    }

    public Transferable clipboardCopy(Object object) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Transferable clipboardCut(Object object) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PasteType[] getPasteTypes(Object object, Transferable transferable) throws UnknownTypeException {
        return null;
    }

    public void setName(Object object, String string) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(VariablesModel.class, (String)string);
    }
}

