/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class ProgressUI
implements ProgressListener {
    private static final Logger LOGGER = Logger.getLogger(ProgressUI.class.getName());
    private String title;
    private boolean modal;
    private Deployment.Logger logger;
    private ProgressHandle handle;
    private ProgressObject progObj;
    private JDialog dialog;
    private JLabel messageLabel;
    private String lastMessage;
    private JComponent progressComponent;
    private boolean finished;
    private boolean completionEventProcessed;

    public ProgressUI(String string, boolean bl) {
        this(string, bl, null);
    }

    public ProgressUI(String string, boolean bl, Deployment.Logger logger) {
        this.modal = bl;
        this.title = string;
        this.logger = logger;
        this.handle = ProgressHandleFactory.createHandle((String)string);
    }

    public void start() {
        this.start(null);
    }

    public void start(Integer n) {
        if (this.modal) {
            this.progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.handle);
        }
        if (n != null) {
            this.handle.setInitialDelay(n.intValue());
        }
        this.handle.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showProgressDialog() {
        String string;
        if (this.finished) {
            return;
        }
        this.dialog = new JDialog(WindowManager.getDefault().getMainWindow(), this.title, true);
        this.dialog.setDefaultCloseOperation(0);
        ProgressUI progressUI = this;
        synchronized (progressUI) {
            string = this.lastMessage;
        }
        this.dialog.getContentPane().add(this.createProgressDialog(this.handle, string != null ? string : this.title));
        this.dialog.pack();
        this.dialog.setBounds(Utilities.findCenterBounds((Dimension)this.dialog.getSize()));
        this.dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
        this.dialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progress(final String string) {
        String string2;
        ProgressUI progressUI = this;
        synchronized (progressUI) {
            string2 = this.lastMessage;
        }
        if (string != null && string.length() > 0 && !string.equals(string2)) {
            this.handle.progress(string);
            progressUI = this;
            synchronized (progressUI) {
                this.lastMessage = string;
            }
            this.log(string);
        }
        if (this.modal) {
            Mutex.EVENT.readAccess(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (ProgressUI.this.messageLabel != null) {
                        ProgressUI.this.messageLabel.setText(string);
                    } else {
                        ProgressUI progressUI = ProgressUI.this;
                        synchronized (progressUI) {
                            ProgressUI.this.lastMessage = string;
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        this.handle.finish();
        ProgressObject progressObject = null;
        ProgressUI progressUI = this;
        synchronized (progressUI) {
            progressObject = this.progObj;
            this.progObj = null;
        }
        if (progressObject != null) {
            progressObject.removeProgressListener((ProgressListener)this);
        }
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                ProgressUI.this.finished = true;
                if (ProgressUI.this.dialog != null) {
                    ProgressUI.this.dialog.setVisible(false);
                    ProgressUI.this.dialog.dispose();
                    ProgressUI.this.dialog = null;
                }
            }
        });
    }

    public void failed(String string) {
        this.finish();
        if (this.logger != null) {
            this.log(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgressObject(ProgressObject progressObject) {
        ProgressObject progressObject2 = null;
        ProgressUI progressUI = this;
        synchronized (progressUI) {
            progressObject2 = this.progObj;
        }
        if (progressObject2 != null) {
            progressObject2.removeProgressListener((ProgressListener)this);
        }
        progressUI = this;
        synchronized (progressUI) {
            this.progObj = progressObject;
            if (progressObject == null) {
                return;
            }
            this.completionEventProcessed = false;
        }
        progressObject.addProgressListener((ProgressListener)this);
        progressUI = progressObject.getDeploymentStatus();
        if (progressUI.isCompleted() || progressUI.isFailed()) {
            this.handleDeploymentStatus((DeploymentStatus)progressUI);
        } else {
            this.progress(progressUI.getMessage());
        }
    }

    private void log(String string) {
        try {
            if (this.logger != null && string != null) {
                LOGGER.log(Level.FINEST, string);
                this.logger.log(string);
            }
        }
        catch (ThreadDeath threadDeath) {
            LOGGER.log(Level.FINE, null, threadDeath);
        }
    }

    private JComponent createProgressDialog(ProgressHandle progressHandle, String string) {
        JPanel jPanel = new JPanel();
        this.messageLabel = new JLabel();
        jPanel.setLayout(new GridBagLayout());
        this.messageLabel.setText(string);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        jPanel.add((Component)this.messageLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        jPanel.add((Component)this.progressComponent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 12, 12);
        JButton jButton = new JButton(NbBundle.getMessage(ProgressUI.class, (String)"LBL_Cancel"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProgressUI.class, (String)"AD_Cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressUI.this.finish();
            }
        });
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    public void handleProgressEvent(ProgressEvent progressEvent) {
        this.handleDeploymentStatus(progressEvent.getDeploymentStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDeploymentStatus(DeploymentStatus deploymentStatus) {
        ProgressUI progressUI = this;
        synchronized (progressUI) {
            if (this.completionEventProcessed) {
                return;
            }
            if (deploymentStatus.isCompleted() || deploymentStatus.isFailed()) {
                this.completionEventProcessed = true;
            }
        }
        if (deploymentStatus.isFailed()) {
            this.failed(deploymentStatus.getMessage());
        } else {
            this.progress(deploymentStatus.getMessage());
        }
    }
}

