/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.sharability;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public class SourceForBinaryQueryImpl
implements SourceForBinaryQueryImplementation2 {
    private static final String[] CLASSPATH_VOLUMES = new String[]{"classpath", "wscompile"};
    private final Map<URL, SourceForBinaryQueryImplementation2.Result> cache = new ConcurrentHashMap<URL, SourceForBinaryQueryImplementation2.Result>();
    private final Map<URL, URL> normalizedURLCache = new ConcurrentHashMap<URL, URL>();

    public SourceForBinaryQueryImplementation2.Result findSourceRoots2(URL uRL) {
        SourceForBinaryQueryImplementation2.Result result = this.cache.get(uRL);
        if (result != null) {
            return result;
        }
        boolean bl = SourceForBinaryQueryImpl.isNormalizedURL(uRL);
        for (LibraryManager libraryManager : LibraryManager.getOpenManagers()) {
            for (Library library : libraryManager.getLibraries()) {
                if (!library.getType().equals("serverlibrary")) continue;
                for (String string : CLASSPATH_VOLUMES) {
                    Iterator iterator = library.getContent(string).iterator();
                    while (iterator.hasNext()) {
                        URL uRL2;
                        URL uRL3 = uRL2 = (URL)iterator.next();
                        if (bl) {
                            uRL3 = this.getNormalizedURL(uRL3);
                        }
                        if (!uRL.equals(uRL3)) continue;
                        result = new Result(uRL2, library);
                        this.cache.put(uRL, result);
                        return result;
                    }
                }
            }
        }
        return null;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL uRL) {
        return this.findSourceRoots2(uRL);
    }

    private URL getNormalizedURL(URL uRL) {
        FileObject fileObject;
        if (SourceForBinaryQueryImpl.isNormalizedURL(uRL)) {
            return uRL;
        }
        URL uRL2 = this.normalizedURLCache.get(uRL);
        if (uRL2 == null && (fileObject = URLMapper.findFileObject((URL)uRL)) != null) {
            try {
                uRL2 = fileObject.getURL();
                this.normalizedURLCache.put(uRL, uRL2);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
            }
        }
        return uRL2;
    }

    private static boolean isNormalizedURL(URL uRL) {
        if ("jar".equals(uRL.getProtocol())) {
            uRL = FileUtil.getArchiveFile((URL)uRL);
        }
        return "file".equals(uRL.getProtocol());
    }

    private static class Result
    implements SourceForBinaryQueryImplementation2.Result,
    PropertyChangeListener {
        private Library lib;
        private URL entry;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private FileObject[] cache;

        public Result(URL uRL, Library library) {
            this.entry = uRL;
            this.lib = library;
            this.lib.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.lib));
        }

        public synchronized FileObject[] getRoots() {
            if (this.cache == null) {
                boolean bl = false;
                for (String string : CLASSPATH_VOLUMES) {
                    if (!this.lib.getContent(string).contains(this.entry)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    ArrayList arrayList = new ArrayList();
                    for (URL uRL : this.lib.getContent("src")) {
                        String string;
                        string = URLMapper.findFileObject((URL)uRL);
                        if (string == null) continue;
                        arrayList.add(string);
                    }
                    this.cache = arrayList.toArray(new FileObject[arrayList.size()]);
                } else {
                    this.cache = new FileObject[0];
                }
            }
            return this.cache;
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            assert (changeListener != null) : "Listener cannot be null";
            this.cs.addChangeListener(changeListener);
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            assert (changeListener != null) : "Listener cannot be null";
            this.cs.removeChangeListener(changeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("content".equals(propertyChangeEvent.getPropertyName())) {
                Result result = this;
                synchronized (result) {
                    this.cache = null;
                }
                this.cs.fireChange();
            }
        }

        public boolean preferSources() {
            return false;
        }
    }
}

