/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.config.J2eeModuleAccessor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeApplication;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ResourceChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ArtifactListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.execution.DeploymentTarget;
import org.netbeans.modules.j2ee.deployment.execution.ModuleConfigurationProvider;
import org.netbeans.modules.j2ee.deployment.impl.ChangeDescriptorAccessor;
import org.netbeans.modules.j2ee.deployment.impl.DeployOnSaveManager;
import org.netbeans.modules.j2ee.deployment.impl.DeploymentHelper;
import org.netbeans.modules.j2ee.deployment.impl.InitialServerFileDistributor;
import org.netbeans.modules.j2ee.deployment.impl.ProgressObjectUtil;
import org.netbeans.modules.j2ee.deployment.impl.ServerException;
import org.netbeans.modules.j2ee.deployment.impl.ServerFileDistributor;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.modules.j2ee.deployment.impl.TimedOutException;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.netbeans.modules.j2ee.deployment.plugins.api.AppChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.api.DeploymentChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.spi.TargetModuleIDResolver;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfigurationFactory;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerServerSettings;
import org.netbeans.modules.j2ee.deployment.profiler.spi.Profiler;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetServer {
    private static final Logger LOGGER = Logger.getLogger(TargetServer.class.getName());
    private Target[] targets;
    private final ServerInstance instance;
    private final DeploymentTarget dtarget;
    private IncrementalDeployment incremental;
    private Map availablesMap = null;
    private Set deployedRootTMIDs = new HashSet();
    private Set undeployTMIDs = new HashSet();
    private Set distributeTargets = new HashSet();
    private TargetModule[] redeployTargetModules = null;
    private File application = null;
    private File currentContentDir = null;
    private String contextRoot = null;

    public TargetServer(DeploymentTarget deploymentTarget) {
        this.dtarget = deploymentTarget;
        this.instance = this.dtarget.getServer().getServerInstance();
    }

    private void init(ProgressUI progressUI, boolean bl, boolean bl2) throws ServerException {
        Object object;
        if (this.targets == null) {
            if (bl) {
                this.instance.start(progressUI);
                this.targets = this.dtarget.getServer().toTargets();
            } else {
                object = new HashSet(Arrays.asList(this.dtarget.getServer().toTargets()));
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Target target = (Target)iterator.next();
                    if (this.instance.getStartServer().isRunning(target)) continue;
                    iterator.remove();
                }
                this.targets = object.toArray(new Target[object.size()]);
            }
        }
        this.incremental = this.instance.getIncrementalDeployment();
        if (this.incremental != null && !this.checkServiceImplementations()) {
            this.incremental = null;
        }
        try {
            object = this.dtarget.getModule().getContentDirectory();
            if (object != null) {
                this.currentContentDir = FileUtil.toFile((FileObject)object);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
        object = this.dtarget.getConfigSupport();
        if (J2eeModule.Type.WAR.equals(this.dtarget.getModule().getType())) {
            try {
                this.contextRoot = object.getWebContextRoot();
            }
            catch (ConfigurationException configurationException) {
                this.contextRoot = null;
            }
        }
        if (bl2) {
            this.processLastTargetModules();
        }
    }

    private boolean canFileDeploy(Target[] targetArray, J2eeModule j2eeModule) throws IOException {
        if (targetArray == null || targetArray.length != 1) {
            LOGGER.log(Level.INFO, NbBundle.getMessage(TargetServer.class, (String)"MSG_MoreThanOneIncrementalTargets"));
            if (targetArray != null && LOGGER.isLoggable(Level.FINE)) {
                StringBuilder stringBuilder = new StringBuilder("[");
                for (int i = 0; i < targetArray.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("[").append(targetArray[i].getName()).append(",").append(targetArray[i].getDescription()).append("]");
                }
                stringBuilder.append("]");
                LOGGER.log(Level.FINE, stringBuilder.toString());
            }
            return false;
        }
        return j2eeModule != null && null != j2eeModule.getContentDirectory() && this.instance.getIncrementalDeployment().canFileDeploy(targetArray[0], j2eeModule);
    }

    private boolean canFileDeploy(TargetModule[] targetModuleArray, J2eeModule j2eeModule) throws IOException {
        if (targetModuleArray == null || targetModuleArray.length != 1) {
            LOGGER.log(Level.INFO, NbBundle.getMessage(TargetServer.class, (String)"MSG_MoreThanOneIncrementalTargets"));
            if (targetModuleArray != null && LOGGER.isLoggable(Level.FINE)) {
                StringBuilder stringBuilder = new StringBuilder("[");
                for (int i = 0; i < targetModuleArray.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("[").append(targetModuleArray[i].getId()).append(",").append(targetModuleArray[i].getTargetName()).append("]");
                }
                stringBuilder.append("]");
                LOGGER.log(Level.FINE, stringBuilder.toString());
            }
            return false;
        }
        return j2eeModule != null && null != j2eeModule.getContentDirectory() && this.instance.getIncrementalDeployment().canFileDeploy(targetModuleArray[0].getTarget(), j2eeModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentChangeDescriptor distributeChanges(TargetModule targetModule, ProgressUI progressUI) throws IOException {
        ServerFileDistributor serverFileDistributor = new ServerFileDistributor(this.instance, this.dtarget);
        try {
            progressUI.setProgressObject(serverFileDistributor);
            ModuleChangeReporter moduleChangeReporter = this.dtarget.getModuleChangeReporter();
            ResourceChangeReporter resourceChangeReporter = this.dtarget.getResourceChangeReporter();
            DeploymentChangeDescriptor deploymentChangeDescriptor = serverFileDistributor.distribute(targetModule, moduleChangeReporter, resourceChangeReporter);
            LOGGER.log(Level.FINE, "Change descriptor is {0}", deploymentChangeDescriptor);
            DeploymentChangeDescriptor deploymentChangeDescriptor2 = deploymentChangeDescriptor;
            return deploymentChangeDescriptor2;
        }
        finally {
            progressUI.setProgressObject(null);
        }
    }

    private DeploymentChangeDescriptor distributeChangesOnSave(TargetModule targetModule, Iterable<ArtifactListener.Artifact> iterable) throws IOException {
        ServerFileDistributor serverFileDistributor = new ServerFileDistributor(this.instance, this.dtarget);
        ModuleChangeReporter moduleChangeReporter = this.dtarget.getModuleChangeReporter();
        ResourceChangeReporter resourceChangeReporter = this.dtarget.getResourceChangeReporter();
        DeploymentChangeDescriptor deploymentChangeDescriptor = serverFileDistributor.distributeOnSave(targetModule, moduleChangeReporter, resourceChangeReporter, iterable);
        LOGGER.log(Level.FINE, "Change descriptor is {0}", deploymentChangeDescriptor);
        return deploymentChangeDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File initialDistribute(Target target, ProgressUI progressUI) {
        InitialServerFileDistributor initialServerFileDistributor = new InitialServerFileDistributor(this.dtarget, target);
        try {
            progressUI.setProgressObject(initialServerFileDistributor);
            File file = initialServerFileDistributor.distribute();
            return file;
        }
        finally {
            progressUI.setProgressObject(null);
        }
    }

    private boolean checkServiceImplementations() {
        String string = null;
        if (this.instance.getServer().getModuleConfigurationFactory() == null) {
            string = ModuleConfigurationFactory.class.getName();
        }
        if (string != null) {
            String string2 = NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_MissingServiceImplementations", (Object)string);
            Logger.getLogger("global").log(Level.INFO, string2);
            return false;
        }
        return true;
    }

    private TargetModule[] checkUndeployForChangedReferences(Set set) {
        if (J2eeModule.Type.WAR.equals(this.dtarget.getModule().getType())) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                File file;
                TargetModule targetModule = (TargetModule)iterator.next();
                File file2 = file = targetModule.getContentDirectory() == null ? null : new File(targetModule.getContentDirectory());
                if ((this.currentContentDir == null || this.currentContentDir.equals(file)) && (this.contextRoot == null || this.contextRoot.equals(targetModule.getContextRoot()))) continue;
                this.distributeTargets.add(targetModule.findTarget());
                this.undeployTMIDs.add(targetModule.delegate());
                targetModule.remove();
                iterator.remove();
            }
        }
        return set.toArray(new TargetModule[set.size()]);
    }

    private TargetModule[] checkUndeployForSharedReferences(Target[] targetArray) {
        HashSet<Target> hashSet = new HashSet<Target>(Arrays.asList(targetArray));
        return this.checkUndeployForSharedReferences(Collections.EMPTY_SET, hashSet);
    }

    private TargetModule[] checkUndeployForSharedReferences(Set set, Set set2) {
        return this.checkUndeployForSharedReferences(set, set2, null);
    }

    private TargetModule[] checkUndeployForSharedReferences(Set set, Set set2, Map hashMap) {
        List<TargetModuleID> list;
        if (this.contextRoot == null || set.isEmpty() && set2.isEmpty()) {
            return set.toArray(new TargetModule[set.size()]);
        }
        HashSet<Target> hashSet = new HashSet<Target>(Arrays.asList(TargetModule.toTarget(set.toArray(new TargetModule[set.size()]))));
        hashSet.addAll(set2);
        Target[] targetArray = hashSet.toArray(new Target[hashSet.size()]);
        boolean bl = false;
        ArrayList<Target> arrayList = new ArrayList<Target>();
        ArrayList<TargetModule> arrayList2 = new ArrayList<TargetModule>();
        ArrayList<TargetModuleID> arrayList3 = new ArrayList<TargetModuleID>();
        TargetModuleIDResolver targetModuleIDResolver = this.instance.getTargetModuleIDResolver();
        if (targetModuleIDResolver != null) {
            if (hashMap == null) {
                hashMap = new HashMap();
                hashMap.put("contextRoot", this.contextRoot);
            }
            Object object = TargetModule.EMPTY_TMID_ARRAY;
            if (targetArray.length > 0) {
                object = targetModuleIDResolver.lookupTargetModuleID(hashMap, targetArray);
            }
            boolean i = false;
            while (object < ((TargetModuleID[])object).length) {
                object[object] = new TargetModule(TargetServer.keyOf((TargetModuleID)object[object]), (TargetModuleID)object[object]);
                ++object;
            }
            list = Arrays.asList(object);
            for (TargetModule targetModule : list) {
                if (set.size() > 0 && !set.contains(targetModule) || set2.contains(targetModule.getTarget())) {
                    bl = true;
                    arrayList3.add(targetModule.delegate());
                    continue;
                }
                arrayList2.add(targetModule);
                arrayList.add(targetModule.getTarget());
            }
        }
        if (!bl) {
            list = TargetModule.findByContextRoot(this.dtarget.getServer(), this.contextRoot);
            list = TargetModule.initDelegate(list, this.getAvailableTMIDsMap());
            for (TargetModule targetModule : list) {
                boolean bl2 = false;
                for (TargetModule targetModule2 : set) {
                    if (!targetModule2.equals(targetModule) || !targetModule2.getContentDirectory().equals(targetModule.getContentDirectory())) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2 || set2.contains(targetModule.getTarget())) {
                    bl = true;
                    arrayList3.add(targetModule.delegate());
                    continue;
                }
                arrayList2.add(targetModule);
                arrayList.add(targetModule.getTarget());
            }
        }
        if (bl) {
            this.undeployTMIDs.addAll(arrayList3);
            TargetModule.removeByContextRoot(this.dtarget.getServer(), this.contextRoot);
            set.removeAll(arrayList2);
            this.distributeTargets.addAll(arrayList);
        }
        return set.toArray(new TargetModule[set.size()]);
    }

    private Map<String, TargetModuleID> getAvailableTMIDsMap() {
        if (this.availablesMap != null) {
            return this.availablesMap;
        }
        DeploymentManager deploymentManager = this.instance.getDeploymentManager();
        this.availablesMap = new HashMap();
        try {
            ModuleType moduleType = J2eeModuleAccessor.getDefault().getJsrModuleType(this.dtarget.getModule().getType());
            TargetModuleID[] targetModuleIDArray = deploymentManager.getAvailableModules(moduleType, this.targets);
            if (targetModuleIDArray == null) {
                return this.availablesMap;
            }
            for (int i = 0; i < targetModuleIDArray.length; ++i) {
                this.availablesMap.put(TargetServer.keyOf(targetModuleIDArray[i]), targetModuleIDArray[i]);
            }
        }
        catch (TargetException targetException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            illegalArgumentException.initCause(targetException);
            throw illegalArgumentException;
        }
        return this.availablesMap;
    }

    private void processLastTargetModules() {
        TargetModule[] targetModuleArray = this.dtarget.getTargetModules();
        if (targetModuleArray == null || targetModuleArray.length == 0) {
            this.distributeTargets.addAll(Arrays.asList(this.targets));
            this.checkUndeployForSharedReferences(this.targets);
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.targets.length; ++i) {
            hashSet.add(this.targets[i].getName());
        }
        Set<TargetModule> set = new HashSet();
        for (int i = 0; i < targetModuleArray.length; ++i) {
            if (!targetModuleArray[i].getInstanceUrl().equals(this.instance.getUrl()) || !hashSet.contains(targetModuleArray[i].getTargetName())) continue;
            TargetModuleID targetModuleID = this.getAvailableTMIDsMap().get(targetModuleArray[i].getId());
            if (targetModuleID == null) {
                Target target = targetModuleArray[i].findTarget();
                if (target == null) continue;
                this.distributeTargets.add(target);
                continue;
            }
            targetModuleArray[i].initDelegate(targetModuleID);
            set.add(targetModuleArray[i]);
        }
        DeploymentManager deploymentManager = this.instance.getDeploymentManager();
        if (this.incremental == null && this.getApplication() == null) {
            set = Collections.EMPTY_SET;
        } else if (this.incremental == null) {
            long l = this.getApplication().lastModified();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                TargetModule targetModule = (TargetModule)iterator.next();
                if (l >= targetModule.getTimestamp()) {
                    if (deploymentManager.isRedeploySupported()) continue;
                    this.distributeTargets.add(targetModule.findTarget());
                    this.undeployTMIDs.add(targetModule.delegate());
                    iterator.remove();
                    continue;
                }
                iterator.remove();
            }
        }
        this.redeployTargetModules = this.checkUndeployForChangedReferences(set);
        HashSet hashSet2 = new HashSet(this.distributeTargets);
        this.redeployTargetModules = this.checkUndeployForSharedReferences(set, hashSet2);
    }

    private File getApplication() {
        if (this.application != null) {
            return this.application;
        }
        try {
            FileObject fileObject = this.dtarget.getModule().getArchive();
            if (fileObject == null) {
                return null;
            }
            this.application = FileUtil.toFile((FileObject)fileObject);
            return this.application;
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.SEVERE, iOException.getMessage());
            return null;
        }
    }

    public void startTargets(Deployment.Mode mode, ProgressUI progressUI) throws ServerException {
        if (this.instance.getStartServer().isAlsoTargetServer(null)) {
            switch (mode) {
                case DEBUG: {
                    this.instance.startDebug(progressUI);
                    break;
                }
                case PROFILE: {
                    ProfilerServerSettings profilerServerSettings = ((Profiler)Lookup.getDefault().lookup(Profiler.class)).getSettings(this.instance.getUrl(), false);
                    this.instance.startProfile(profilerServerSettings, false, progressUI);
                    break;
                }
                case RUN: {
                    this.instance.start(progressUI);
                }
            }
            this.targets = this.dtarget.getServer().toTargets();
            return;
        }
        this.instance.start(progressUI);
        this.targets = this.dtarget.getServer().toTargets();
        switch (mode) {
            case DEBUG: {
                for (int i = 0; i < this.targets.length; ++i) {
                    this.instance.startDebugTarget(this.targets[i], progressUI);
                }
                break;
            }
            case RUN: {
                for (int i = 0; i < this.targets.length; ++i) {
                    this.instance.startTarget(this.targets[i], progressUI);
                }
                break;
            }
        }
    }

    private static String keyOf(TargetModuleID targetModuleID) {
        return targetModuleID.toString();
    }

    private TargetModuleID[] saveRootTargetModules(TargetModuleID[] targetModuleIDArray) {
        long l = System.currentTimeMillis();
        HashSet<TargetModuleID> hashSet = new HashSet<TargetModuleID>();
        for (int i = 0; i < targetModuleIDArray.length; ++i) {
            if (targetModuleIDArray[i].getParentTargetModuleID() != null) continue;
            String string = TargetServer.keyOf(targetModuleIDArray[i]);
            String string2 = targetModuleIDArray[i].getTarget().getName();
            String string3 = "";
            if (null != this.currentContentDir) {
                string3 = this.currentContentDir.getAbsolutePath();
            }
            TargetModule targetModule = new TargetModule(string, this.instance.getUrl(), l, string3, this.contextRoot, targetModuleIDArray[i]);
            this.deployedRootTMIDs.add(targetModule);
            hashSet.add(targetModuleIDArray[i]);
        }
        return hashSet.toArray(new TargetModuleID[hashSet.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TargetModule[] deploy(ProgressUI progressUI, boolean bl) throws IOException, ServerException {
        Object object;
        Object object2;
        boolean bl2;
        int n;
        ProgressObject progressObject = null;
        boolean bl3 = false;
        this.init(progressUI, true, true);
        boolean bl4 = false;
        if (J2eeModule.Type.EAR.equals(this.dtarget.getModule().getType()) && this.dtarget.getModule() instanceof J2eeApplication && this.redeployTargetModules != null && this.redeployTargetModules.length == 1) {
            n = this.redeployTargetModules[0].getChildTargetModuleID() != null ? this.redeployTargetModules[0].getChildTargetModuleID().length : 0;
            boolean bl5 = bl4 = n < ((J2eeApplication)this.dtarget.getModule()).getModules().length;
            if (bl4) {
                LOGGER.log(Level.INFO, "Enterprise application needs to be redeployed due to missing module");
            }
        }
        if ((bl || bl4) && this.redeployTargetModules != null) {
            for (n = 0; n < this.redeployTargetModules.length; ++n) {
                this.distributeTargets.add(this.redeployTargetModules[n].findTarget());
                this.undeployTMIDs.add(this.redeployTargetModules[n].delegate());
                this.redeployTargetModules[n].remove();
            }
            this.redeployTargetModules = null;
        }
        File file = null;
        J2eeModule j2eeModule = null;
        ModuleConfigurationProvider moduleConfigurationProvider = this.dtarget.getModuleConfigurationProvider();
        if (moduleConfigurationProvider != null) {
            j2eeModule = moduleConfigurationProvider.getJ2eeModule(null);
        }
        boolean bl6 = bl2 = this.dtarget.getModule().getContentDirectory() != null;
        if (this.undeployTMIDs.size() > 0) {
            object2 = this.undeployTMIDs.toArray(new TargetModuleID[this.undeployTMIDs.size()]);
            progressUI.progress(NbBundle.getMessage(TargetServer.class, (String)"MSG_Undeploying"));
            object = this.instance.getDeploymentManager().undeploy((TargetModuleID[])object2);
            try {
                ProgressObjectUtil.trackProgressObject(progressUI, (ProgressObject)object, this.instance.getDeploymentTimeout());
            }
            catch (TimedOutException timedOutException) {
                // empty catch block
            }
        }
        if (this.distributeTargets.size() > 0) {
            bl3 = true;
            object2 = this.distributeTargets.toArray(new Target[this.distributeTargets.size()]);
            object = IncrementalDeployment.getIncrementalDeploymentForModule(this.incremental, j2eeModule);
            if (object != null && bl2 && this.canFileDeploy((Target[])object2, j2eeModule)) {
                ModuleConfiguration moduleConfiguration = this.dtarget.getModuleConfigurationProvider().getModuleConfiguration();
                File file2 = this.initialDistribute((Target)object2[0], progressUI);
                progressObject = ((IncrementalDeployment)object).initialDeploy((Target)object2[0], j2eeModule, moduleConfiguration, file2);
                this.trackDeployProgressObject(progressUI, progressObject, false);
            } else {
                if (this.getApplication() == null) {
                    throw new RuntimeException(NbBundle.getMessage(TargetServer.class, (String)"MSG_NoArchive"));
                }
                progressUI.progress(NbBundle.getMessage(TargetServer.class, (String)"MSG_Distributing", (Object)this.application, Arrays.asList(object2)));
                file = this.dtarget.getConfigurationFile();
                progressObject = this.instance.getDeploymentManager().distribute((Target[])object2, this.getApplication(), file);
                this.trackDeployProgressObject(progressUI, progressObject, false);
            }
        }
        if (this.redeployTargetModules != null && this.redeployTargetModules.length > 0) {
            bl3 = true;
            object2 = IncrementalDeployment.getIncrementalDeploymentForModule(this.incremental, j2eeModule);
            if (object2 != null && bl2 && this.canFileDeploy(this.redeployTargetModules, j2eeModule)) {
                object = this.distributeChanges(this.redeployTargetModules[0], progressUI);
                if (!TargetServer.anyChanged((DeploymentChangeDescriptor)object)) return this.dtarget.getTargetModules();
                progressUI.progress(NbBundle.getMessage(TargetServer.class, (String)"MSG_IncrementalDeploying", (Object)this.redeployTargetModules[0]));
                progressObject = ((IncrementalDeployment)object2).incrementalDeploy(this.redeployTargetModules[0].delegate(), (AppChangeDescriptor)object);
                this.trackDeployProgressObject(progressUI, progressObject, true);
            } else {
                if (this.getApplication() == null) {
                    throw new IllegalArgumentException(NbBundle.getMessage(TargetServer.class, (String)"MSG_NoArchive"));
                }
                progressUI.progress(NbBundle.getMessage(TargetServer.class, (String)"MSG_Redeploying", (Object)this.application));
                object = TargetModule.toTargetModuleID(this.redeployTargetModules);
                if (file == null) {
                    file = this.dtarget.getConfigurationFile();
                }
                progressObject = this.instance.getDeploymentManager().redeploy((TargetModuleID[])object, this.getApplication(), file);
                this.trackDeployProgressObject(progressUI, progressObject, false);
            }
        }
        if (!bl3) return this.dtarget.getTargetModules();
        return this.deployedRootTMIDs.toArray(new TargetModule[this.deployedRootTMIDs.size()]);
    }

    public void undeploy(ProgressUI progressUI, boolean bl) throws IOException, ServerException {
        if (!this.instance.isRunning() && !bl) {
            return;
        }
        this.init(progressUI, bl, false);
        TargetModuleID[] targetModuleIDArray = this.getDeploymentDirectoryModules();
        if (targetModuleIDArray.length <= 0) {
            return;
        }
        ArrayList<TargetModuleID> arrayList = new ArrayList<TargetModuleID>();
        for (TargetModule targetModule : targetModuleIDArray) {
            arrayList.add(targetModule.delegate());
            targetModule.remove();
        }
        TargetModuleID[] targetModuleIDArray2 = arrayList.toArray(new TargetModuleID[arrayList.size()]);
        progressUI.progress(NbBundle.getMessage(TargetServer.class, (String)"MSG_Undeploying"));
        ProgressObject progressObject = this.instance.getDeploymentManager().undeploy(targetModuleIDArray2);
        try {
            ProgressObjectUtil.trackProgressObject(progressUI, progressObject, this.instance.getDeploymentTimeout());
        }
        catch (TimedOutException timedOutException) {
            LOGGER.log(Level.INFO, "Undeploy timeouted");
        }
    }

    public void notifyIncrementalDeployment(TargetModuleID[] targetModuleIDArray) {
        if (targetModuleIDArray != null && this.incremental != null) {
            for (int i = 0; i < targetModuleIDArray.length; ++i) {
                this.incremental.notifyDeployment(targetModuleIDArray[i]);
            }
        }
    }

    public static boolean anyChanged(DeploymentChangeDescriptor deploymentChangeDescriptor) {
        return deploymentChangeDescriptor.manifestChanged() || deploymentChangeDescriptor.descriptorChanged() || deploymentChangeDescriptor.classesChanged() || deploymentChangeDescriptor.ejbsChanged() || deploymentChangeDescriptor.serverDescriptorChanged() || deploymentChangeDescriptor.serverResourcesChanged();
    }

    public boolean supportsDeployOnSave(TargetModule[] targetModuleArray) throws IOException {
        J2eeModule j2eeModule = null;
        ModuleConfigurationProvider moduleConfigurationProvider = this.dtarget.getModuleConfigurationProvider();
        if (moduleConfigurationProvider != null) {
            j2eeModule = moduleConfigurationProvider.getJ2eeModule(null);
        }
        boolean bl = this.dtarget.getModule().getContentDirectory() != null;
        IncrementalDeployment incrementalDeployment = IncrementalDeployment.getIncrementalDeploymentForModule(this.incremental, j2eeModule);
        return incrementalDeployment != null && bl && this.canFileDeploy(targetModuleArray, j2eeModule) && incrementalDeployment.isDeployOnSaveSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeployOnSaveManager.DeploymentState notifyArtifactsUpdated(J2eeModuleProvider j2eeModuleProvider, Iterable<ArtifactListener.Artifact> iterable) {
        Object object;
        if (!this.instance.isRunning()) {
            return DeployOnSaveManager.DeploymentState.MODULE_NOT_DEPLOYED;
        }
        if (!DeployOnSaveManager.isServerStateSupported(this.instance)) {
            return DeployOnSaveManager.DeploymentState.SERVER_STATE_UNSUPPORTED;
        }
        try {
            this.init(null, false, false);
        }
        catch (ServerException serverException) {
            Exceptions.printStackTrace((Throwable)serverException);
        }
        TargetModule[] targetModuleArray = this.getDeploymentDirectoryModules();
        try {
            if (!this.supportsDeployOnSave(targetModuleArray)) {
                return DeployOnSaveManager.DeploymentState.MODULE_NOT_DEPLOYED;
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        TargetModule targetModule = this.dtarget.getTargetModules()[0];
        if (!targetModule.hasDelegate()) {
            return DeployOnSaveManager.DeploymentState.MODULE_NOT_DEPLOYED;
        }
        ProgressUI progressUI = new ProgressUI(NbBundle.getMessage(TargetServer.class, (String)"MSG_DeployOnSave", (Object)j2eeModuleProvider.getDeploymentName()), false);
        progressUI.start(0);
        try {
            boolean bl;
            boolean bl2 = false;
            for (Object object2 : iterable) {
                if (!object2.isServerResource()) continue;
                bl2 = true;
                break;
            }
            try {
                if (bl2) {
                    DeploymentHelper.deployDatasources(j2eeModuleProvider);
                    DeploymentHelper.deployMessageDestinations(j2eeModuleProvider);
                }
            }
            catch (DatasourceAlreadyExistsException datasourceAlreadyExistsException) {
                Object object2;
                Exceptions.printStackTrace((Throwable)datasourceAlreadyExistsException);
                object2 = DeployOnSaveManager.DeploymentState.DEPLOYMENT_FAILED;
                progressUI.finish();
                return object2;
            }
            object = this.distributeChangesOnSave(targetModule, iterable);
            if (bl2) {
                ChangeDescriptorAccessor.getDefault().withChangedServerResources((DeploymentChangeDescriptor)object);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, ((DeploymentChangeDescriptor)object).toString());
            }
            if (!(bl = this.reloadArtifacts(progressUI, targetModuleArray, (DeploymentChangeDescriptor)object))) {
                LOGGER.log(Level.INFO, "On save deployment failed");
                DeployOnSaveManager.DeploymentState deploymentState = DeployOnSaveManager.DeploymentState.DEPLOYMENT_FAILED;
                return deploymentState;
            }
            DeployOnSaveManager.DeploymentState deploymentState = DeployOnSaveManager.DeploymentState.MODULE_UPDATED;
            return deploymentState;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            object = DeployOnSaveManager.DeploymentState.DEPLOYMENT_FAILED;
            return object;
        }
        catch (ConfigurationException configurationException) {
            Exceptions.printStackTrace((Throwable)configurationException);
            object = DeployOnSaveManager.DeploymentState.DEPLOYMENT_FAILED;
            return object;
        }
        finally {
            progressUI.finish();
        }
    }

    private boolean reloadArtifacts(ProgressUI progressUI, TargetModule[] targetModuleArray, DeploymentChangeDescriptor deploymentChangeDescriptor) {
        boolean bl = true;
        for (TargetModule targetModule : targetModuleArray) {
            ProgressObject progressObject = this.incremental.deployOnSave(targetModule.delegate(), deploymentChangeDescriptor);
            try {
                bl = bl && this.trackDeployProgressObject(progressUI, progressObject, true);
            }
            catch (ServerException serverException) {
                Exceptions.printStackTrace((Throwable)serverException);
                bl = false;
            }
        }
        this.notifyIncrementalDeployment(targetModuleArray);
        return bl;
    }

    private TargetModule[] getDeploymentDirectoryModules() {
        TargetModule[] targetModuleArray = this.dtarget.getTargetModules();
        ServerInstance serverInstance = this.dtarget.getServer().getServerInstance();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.targets.length; ++i) {
            hashSet.add(this.targets[i].getName());
        }
        HashSet<TargetModule> hashSet2 = new HashSet<TargetModule>();
        for (TargetModule targetModule : targetModuleArray) {
            TargetModuleID targetModuleID;
            if (!targetModule.getInstanceUrl().equals(serverInstance.getUrl()) || !hashSet.contains(targetModule.getTargetName()) || (targetModuleID = this.getAvailableTMIDsMap().get(targetModule.getId())) == null) continue;
            targetModule.initDelegate(targetModuleID);
            hashSet2.add(targetModule);
        }
        return hashSet2.toArray(new TargetModule[hashSet2.size()]);
    }

    private boolean trackDeployProgressObject(ProgressUI progressUI, ProgressObject progressObject, boolean bl) throws ServerException {
        long l = this.instance.getDeploymentTimeout();
        long l2 = System.currentTimeMillis();
        try {
            boolean bl2 = ProgressObjectUtil.trackProgressObject(progressUI, progressObject, l);
            if (bl2) {
                TargetModuleID[] targetModuleIDArray = progressObject.getResultTargetModuleIDs();
                targetModuleIDArray = this.saveRootTargetModules(targetModuleIDArray);
                if (!bl) {
                    ProgressObject progressObject2 = this.instance.getDeploymentManager().start(targetModuleIDArray);
                    long l3 = System.currentTimeMillis() - l2;
                    return ProgressObjectUtil.trackProgressObject(progressUI, progressObject2, l - l3);
                }
            }
            return bl2;
        }
        catch (TimedOutException timedOutException) {
            throw new ServerException(NbBundle.getMessage(TargetServer.class, (String)"MSG_DeploymentTimeoutExceeded"));
        }
    }
}

