/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.SourceRootsProvider;
import org.openide.util.Parameters;

public final class SourceRootsSupport
implements SourceRootsProvider {
    private URL[] sourceRoots;
    private SourceRootsProvider delegate;
    private PropertyChangeSupport pcs;
    private List<ModuleList> listsForSources;

    public SourceRootsSupport(URL[] uRLArray, SourceRootsProvider sourceRootsProvider) {
        if (uRLArray == null) {
            throw new NullPointerException("sourceRoots must not be null.");
        }
        this.sourceRoots = uRLArray;
        this.pcs = new PropertyChangeSupport(this);
        this.delegate = sourceRootsProvider;
    }

    private void maybeUpdateDefaultSources() {
        URL[] uRLArray;
        if (this.sourceRoots.length == 0 && (uRLArray = this.getDefaultSourceRoots()) != null) {
            this.sourceRoots = uRLArray;
            this.pcs.firePropertyChange("sourceRoots", null, null);
        }
    }

    public URL[] getDefaultSourceRoots() {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getDefaultSourceRoots();
    }

    public void addSourceRoot(URL uRL) throws IOException, IllegalArgumentException {
        Parameters.notNull((CharSequence)"root", (Object)uRL);
        if (SourceRootsSupport.containsRoot(this, uRL)) {
            throw new IllegalArgumentException("Root '" + uRL + "' already present in sources.");
        }
        this.maybeUpdateDefaultSources();
        URL[] uRLArray = new URL[this.sourceRoots.length + 1];
        System.arraycopy(this.sourceRoots, 0, uRLArray, 0, this.sourceRoots.length);
        uRLArray[this.sourceRoots.length] = uRL;
        this.setSourceRootsInternal(uRLArray);
    }

    public File getSourceLocationOfModule(File file) {
        if (this.listsForSources == null) {
            ArrayList arrayList = new ArrayList();
            for (URL uRL : this.getSourceRoots()) {
                File file2;
                if (!uRL.getProtocol().equals("file") || !(file2 = new File(URI.create(uRL.toExternalForm()))).isDirectory()) continue;
                try {
                    if (ModuleList.isNetBeansOrg(file2)) {
                        arrayList.add(ModuleList.findOrCreateModuleListFromNetBeansOrgSources(file2));
                        continue;
                    }
                    arrayList.add(ModuleList.findOrCreateModuleListFromSuiteWithoutBinaries(file2));
                }
                catch (IOException iOException) {
                    Util.err.notify(1, (Throwable)iOException);
                }
            }
            this.listsForSources = arrayList;
        }
        for (ModuleList moduleList : this.listsForSources) {
            for (ModuleEntry moduleEntry : moduleList.getAllEntriesSoft()) {
                File file3;
                if (!moduleEntry.getJarLocation().getName().equals(file.getName()) || (file3 = moduleEntry.getSourceLocation()) == null || !file3.isDirectory()) continue;
                return file3;
            }
            for (ModuleEntry moduleEntry : moduleList.getAllEntries()) {
                File file4;
                if (!moduleEntry.getJarLocation().getName().equals(file.getName()) || (file4 = moduleEntry.getSourceLocation()) == null || !file4.isDirectory()) continue;
                return file4;
            }
        }
        return null;
    }

    public URL[] getSourceRoots() {
        URL[] uRLArray;
        if (this.sourceRoots.length == 0 && (uRLArray = this.getDefaultSourceRoots()) != null) {
            return uRLArray;
        }
        return this.sourceRoots;
    }

    public void removeSourceRoots(URL[] uRLArray) throws IOException {
        this.maybeUpdateDefaultSources();
        ArrayList<URL> arrayList = new ArrayList<URL>(Arrays.asList(this.sourceRoots));
        arrayList.removeAll(Arrays.asList(uRLArray));
        assert (arrayList.size() + uRLArray.length >= this.sourceRoots.length) : "Too many roots removed, one of " + Arrays.toString(uRLArray) + " was contained more than once";
        URL[] uRLArray2 = new URL[arrayList.size()];
        this.setSourceRootsInternal(arrayList.toArray(uRLArray2));
    }

    private void setSourceRootsInternal(URL[] uRLArray) throws IOException {
        if (this.delegate != null) {
            this.delegate.setSourceRoots(uRLArray);
        } else {
            this.setSourceRoots(uRLArray);
        }
    }

    public void setSourceRoots(URL[] uRLArray) throws IOException {
        this.sourceRoots = uRLArray;
        this.pcs.firePropertyChange("sourceRoots", null, null);
        this.listsForSources = null;
    }

    public void moveSourceRootUp(int n) throws IOException {
        this.maybeUpdateDefaultSources();
        if (n <= 0) {
            return;
        }
        URL[] uRLArray = new URL[this.sourceRoots.length];
        System.arraycopy(this.sourceRoots, 0, uRLArray, 0, this.sourceRoots.length);
        uRLArray[n - 1] = this.sourceRoots[n];
        uRLArray[n] = this.sourceRoots[n - 1];
        this.setSourceRootsInternal(uRLArray);
    }

    public void moveSourceRootDown(int n) throws IOException {
        this.maybeUpdateDefaultSources();
        if (n >= this.sourceRoots.length - 1) {
            return;
        }
        URL[] uRLArray = new URL[this.sourceRoots.length];
        System.arraycopy(this.sourceRoots, 0, uRLArray, 0, this.sourceRoots.length);
        uRLArray[n + 1] = this.sourceRoots[n];
        uRLArray[n] = this.sourceRoots[n + 1];
        this.setSourceRootsInternal(uRLArray);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public static boolean containsRoot(SourceRootsProvider sourceRootsProvider, URL uRL) {
        Parameters.notNull((CharSequence)"provider", (Object)sourceRootsProvider);
        Parameters.notNull((CharSequence)"root", (Object)uRL);
        for (URL uRL2 : sourceRootsProvider.getSourceRoots()) {
            if (!uRL.equals(uRL2)) continue;
            return true;
        }
        return false;
    }
}

