/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.ModuleOperations;
import org.netbeans.modules.apisupport.project.ui.customizer.BasicBrandingModel;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ProjectOperations;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SuiteOperations
implements DeleteOperationImplementation,
MoveOperationImplementation {
    private static final Map<String, Set<NbModuleProject>> TEMPORARY_CACHE = new HashMap<String, Set<NbModuleProject>>();
    private final SuiteProject suite;
    private final FileObject projectDir;

    public SuiteOperations(SuiteProject suiteProject) {
        this.suite = suiteProject;
        this.projectDir = suiteProject.getProjectDirectory();
    }

    public void notifyDeleting() throws IOException {
        FileObject fileObject = this.projectDir.getFileObject("build.xml");
        ActionUtils.runTarget((FileObject)fileObject, (String[])new String[]{"clean"}, null).waitFinished();
        SubprojectProvider subprojectProvider = (SubprojectProvider)this.suite.getLookup().lookup(SubprojectProvider.class);
        for (Project project : subprojectProvider.getSubprojects()) {
            SuiteUtils.removeModuleFromSuite((NbModuleProject)project);
        }
    }

    public void notifyDeleted() throws IOException {
        this.suite.getHelper().notifyDeleted();
    }

    public void notifyMoving() throws IOException {
        Set<NbModuleProject> set = SuiteUtils.getSubProjects(this.suite);
        if (!set.isEmpty()) {
            TEMPORARY_CACHE.put(ProjectUtils.getInformation((Project)this.suite).getName(), set);
        }
        this.notifyDeleting();
    }

    public void notifyMoved(Project project, File file, String string) throws IOException {
        if (project == null) {
            this.suite.getHelper().notifyDeleted();
        } else {
            boolean bl;
            FileObject fileObject;
            String string2 = ProjectUtils.getInformation((Project)this.suite).getName();
            Set<NbModuleProject> set = TEMPORARY_CACHE.remove(string2);
            if (set != null) {
                HashSet<Project> hashSet = new HashSet<Project>();
                fileObject = set.iterator();
                while (fileObject.hasNext()) {
                    boolean bl2;
                    NbModuleProject nbModuleProject;
                    NbModuleProject nbModuleProject2 = nbModuleProject = fileObject.next();
                    boolean bl3 = bl2 = !project.getProjectDirectory().equals(this.suite.getProjectDirectory());
                    if (bl2 && FileUtil.isParentOf((FileObject)project.getProjectDirectory(), (FileObject)nbModuleProject2.getProjectDirectory())) {
                        boolean bl4 = SuiteOperations.isOpened(nbModuleProject2);
                        Project project2 = SuiteOperations.moveModule(nbModuleProject2, this.suite.getProjectDirectory());
                        SuiteUtils.addModule(this.suite, (NbModuleProject)project2);
                        if (!bl4) continue;
                        hashSet.add(project2);
                        continue;
                    }
                    SuiteUtils.addModule(this.suite, nbModuleProject2);
                }
                OpenProjects.getDefault().open(hashSet.toArray(new Project[hashSet.size()]), false);
            }
            if (bl = project.getProjectDirectory().getParent().equals(this.suite.getProjectDirectory().getParent())) {
                this.setDisplayName(string);
            }
            if ((fileObject = FileUtil.toFileObject((File)file)) != null && fileObject.getChildren().length == 0) {
                fileObject.delete();
            }
        }
    }

    public List<FileObject> getMetadataFiles() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        this.addFile("build.xml", arrayList);
        this.addFile("nbproject", arrayList);
        this.addFile("master.jnlp", arrayList);
        this.addFile("branding.jnlp", arrayList);
        return arrayList;
    }

    public List<FileObject> getDataFiles() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        this.addFile(this.suite.getEvaluator().getProperty("branding.dir"), arrayList);
        return arrayList;
    }

    private void addFile(String string, List<FileObject> list) {
        FileObject fileObject = this.projectDir.getFileObject(string);
        if (fileObject != null) {
            list.add(fileObject);
        }
    }

    private void setDisplayName(final String string) throws IOException {
        final SuiteProperties suiteProperties = new SuiteProperties(this.suite, this.suite.getHelper(), this.suite.getEvaluator(), SuiteUtils.getSubProjects(this.suite));
        final BasicBrandingModel basicBrandingModel = suiteProperties.getBrandingModel();
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                public Object run() throws IOException {
                    if (basicBrandingModel.isBrandingEnabled()) {
                        basicBrandingModel.setTitle(string);
                        suiteProperties.storeProperties();
                    } else {
                        EditableProperties editableProperties = SuiteOperations.this.suite.getHelper().getProperties("nbproject/project.properties");
                        editableProperties.setProperty("app.title", string);
                        SuiteOperations.this.suite.getHelper().putProperties("nbproject/project.properties", editableProperties);
                    }
                    ProjectManager.getDefault().saveProject((Project)SuiteOperations.this.suite);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    static Project moveModule(NbModuleProject nbModuleProject, FileObject fileObject) throws IOException, IllegalArgumentException {
        ProjectOperations.notifyMoving((Project)nbModuleProject);
        SuiteOperations.close(nbModuleProject);
        FileObject fileObject2 = nbModuleProject.getProjectDirectory();
        FileObject fileObject3 = SuiteOperations.doCopy(nbModuleProject, fileObject2, fileObject);
        ProjectManager.getDefault().clearNonProjectCache();
        Project project = ProjectManager.getDefault().findProject(fileObject3);
        assert (project != null);
        File file = FileUtil.toFile((FileObject)fileObject2);
        SuiteOperations.doDelete(nbModuleProject, fileObject2);
        ProjectOperations.notifyMoved((Project)nbModuleProject, (Project)project, (File)file, (String)file.getName());
        return project;
    }

    private static boolean isOpened(Project project) {
        boolean bl = false;
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (projectArray[i] != project) continue;
            bl = true;
            break;
        }
        return bl;
    }

    static boolean canRun(SuiteProject suiteProject) {
        boolean bl = true;
        if (suiteProject.getTestUserDirLockFile().isFile()) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ModuleOperations.class, (String)"ERR_ModuleIsBeingRun")));
            bl = false;
        }
        return bl;
    }

    private static FileObject doCopy(Project project, FileObject fileObject, FileObject fileObject2) throws IOException {
        FileObject fileObject3;
        if (!VisibilityQuery.getDefault().isVisible(fileObject)) {
            return null;
        }
        if (!project.getProjectDirectory().equals(FileOwnerQuery.getOwner((FileObject)fileObject).getProjectDirectory())) {
            return null;
        }
        if (fileObject.isFolder()) {
            fileObject3 = fileObject2.createFolder(fileObject.getNameExt());
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                SuiteOperations.doCopy(project, fileObjectArray[i], fileObject3);
            }
        } else {
            assert (fileObject.isData());
            fileObject3 = FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2, (String)fileObject.getName(), (String)fileObject.getExt());
        }
        return fileObject3;
    }

    private static boolean doDelete(Project project, FileObject fileObject) throws IOException {
        if (!project.getProjectDirectory().equals(FileOwnerQuery.getOwner((FileObject)fileObject).getProjectDirectory())) {
            return false;
        }
        if (fileObject.isFolder()) {
            FileObject[] fileObjectArray = fileObject.getChildren();
            boolean bl = true;
            for (int i = 0; i < fileObjectArray.length; ++i) {
                bl &= SuiteOperations.doDelete(project, fileObjectArray[i]);
            }
            if (bl) {
                fileObject.delete();
            }
            return bl;
        }
        assert (fileObject.isData());
        fileObject.delete();
        return true;
    }

    private static void close(final Project project) {
        Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Object>(){

            public Object run() {
                LifecycleManager.getDefault().saveAll();
                Action action = CommonProjectActions.closeProjectAction();
                Action action2 = action = action instanceof ContextAwareAction ? ((ContextAwareAction)action).createContextAwareInstance(Lookups.fixed((Object[])new Object[]{project})) : null;
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(new ActionEvent(project, -1, ""));
                } else {
                    OpenProjects.getDefault().close(new Project[]{project});
                }
                return null;
            }
        });
    }
}

