/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.ui.components;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import org.netbeans.modules.dlight.core.ui.components.ContentValidator;
import org.netbeans.modules.dlight.core.ui.components.DLightTargetSelectionDialog;
import org.netbeans.modules.dlight.core.ui.components.JComboBox2;
import org.openide.util.NbBundle;

public class SelectExecutableTargetDialog
extends DLightTargetSelectionDialog {
    private DefaultComboBoxModel cmbExecutableModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel cmbArgumentsModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel cmbWorkingDirModel = new DefaultComboBoxModel();
    private JButton btnBrowseExecutable = new JButton(NbBundle.getMessage(SelectExecutableTargetDialog.class, (String)"SelectTarget.Browse.Title"));
    private JButton btnBrowseWorkingDir = new JButton(NbBundle.getMessage(SelectExecutableTargetDialog.class, (String)"SelectTarget.Browse.Title"));
    private ContentValidator workingDirValidator = new ContentValidator(){

        public String validate(String string) {
            File file = new File(string);
            if (!file.exists() || !file.isDirectory()) {
                return NbBundle.getMessage(SelectExecutableTargetDialog.class, (String)"SelectTarget.SpecifyExistentWorkingDir");
            }
            return file.canWrite() ? null : NbBundle.getMessage(SelectExecutableTargetDialog.class, (String)"SelectTarget.WorkingDirIsNotWritable");
        }
    };
    private ContentValidator executableValidator = new ContentValidator(){

        public String validate(String string) {
            return new File(string).exists() ? null : NbBundle.getMessage(SelectExecutableTargetDialog.class, (String)"SelectTarget.SpecifyExistentExecutable");
        }
    };

    public SelectExecutableTargetDialog() {
        super(NbBundle.getMessage(SelectExecutableTargetDialog.class, (String)"SelectExecutableTargetDialog.Title"));
        this.setDefaults();
        this.init();
    }

    public String getProgramName() {
        return (String)this.cmbExecutableModel.getSelectedItem();
    }

    public String getProgramArguments() {
        return (String)this.cmbArgumentsModel.getSelectedItem();
    }

    public String getWorkingDirectory() {
        return (String)this.cmbWorkingDirModel.getSelectedItem();
    }

    void initComponents() {
        this.setLayout(new GridLayout(4, 1));
        this.btnBrowseExecutable.addActionListener(this);
        this.btnBrowseWorkingDir.addActionListener(this);
        this.btnBrowseExecutable.setToolTipText(NbBundle.getMessage(SelectExecutableTargetDialog.class, (String)"SelectTarget.BrowseExecutable.Tooltip"));
        this.btnBrowseWorkingDir.setToolTipText(NbBundle.getMessage(SelectExecutableTargetDialog.class, (String)"SelectTarget.BrowseWorkingDir.Tooltip"));
        this.addPanel(NbBundle.getMessage(SelectExecutableTargetDialog.class, (String)"SelectTarget.Executable"), new JComboBox2(this.cmbExecutableModel, 10, true, this.executableValidator), this.btnBrowseExecutable);
        this.addPanel(NbBundle.getMessage(SelectExecutableTargetDialog.class, (String)"SelectTarget.Arguments"), new JComboBox2(this.cmbArgumentsModel), null);
        this.addPanel(NbBundle.getMessage(SelectExecutableTargetDialog.class, (String)"SelectTarget.WorkingDir"), new JComboBox2(this.cmbWorkingDirModel, 10, true, this.workingDirValidator), this.btnBrowseWorkingDir);
    }

    private void setDefaults() {
        SelectExecutableTargetDialog.updateModel(this.cmbExecutableModel, "/bin/tar");
        SelectExecutableTargetDialog.updateModel(this.cmbArgumentsModel, "-cvf /tmp/f1.tar /usr/include");
        SelectExecutableTargetDialog.updateModel(this.cmbWorkingDirModel, "/tmp");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (!(object instanceof JButton)) {
            return;
        }
        if (object == this.btnBrowseExecutable) {
            String string = this.selectFile((String)this.cmbExecutableModel.getSelectedItem());
            SelectExecutableTargetDialog.updateModel(this.cmbExecutableModel, string);
        } else if (object == this.btnBrowseWorkingDir) {
            String string = this.selectDirectory((String)this.cmbWorkingDirModel.getSelectedItem(), this.workingDirValidator);
            SelectExecutableTargetDialog.updateModel(this.cmbWorkingDirModel, string);
        }
    }
}

