/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.EnumDescriptor;
import org.netbeans.modules.vmd.api.model.EnumDescriptorFactoryRegistry;
import org.netbeans.modules.vmd.api.model.PrimitiveDescriptor;
import org.netbeans.modules.vmd.api.model.PrimitiveDescriptorFactoryRegistry;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.TypeID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyValue {
    private static final char USER_CODE_ID = 'U';
    private static final char NULL_ID = 'N';
    private static final char REFERENCE_ID = 'R';
    private static final char VALUE_ID = 'V';
    private static final char ENUM_ID = 'E';
    private static final char ARRAY_ID = 'A';
    private static final char ARRAY_SIZE_SEPARATOR = ':';
    private static final char ENCODED_LENGTH_SEPARATOR = '_';
    private static final PropertyValue NULL = new PropertyValue(Kind.NULL);
    private static final List<PropertyValue> EMPTY_ARRAY = new ArrayList<PropertyValue>(0);
    private final Kind kind;
    private TypeID type;
    private String userCode;
    private DesignComponent component;
    private PrimitiveDescriptor descriptor;
    private Object value;
    private List<PropertyValue> array;

    public static PropertyValue createUserCode(String string) {
        assert (string != null);
        PropertyValue propertyValue = new PropertyValue(Kind.USERCODE);
        propertyValue.userCode = string;
        return propertyValue;
    }

    public static PropertyValue createComponentReference(DesignComponent designComponent) {
        assert (designComponent != null);
        return designComponent.getReferenceValue();
    }

    static PropertyValue createComponentReferenceCore(DesignComponent designComponent) {
        assert (Debug.isFriend(DesignComponent.class, "<init>"));
        assert (designComponent != null);
        TypeID typeID = designComponent.getType();
        assert (typeID.getKind() == TypeID.Kind.COMPONENT);
        PropertyValue propertyValue = new PropertyValue(Kind.REFERENCE);
        propertyValue.type = typeID;
        propertyValue.component = designComponent;
        return propertyValue;
    }

    public static PropertyValue createNull() {
        return NULL;
    }

    public static PropertyValue createValue(PrimitiveDescriptor primitiveDescriptor, TypeID typeID, Object object) {
        assert (primitiveDescriptor != null);
        assert (typeID != null);
        assert (typeID.getKind() == TypeID.Kind.PRIMITIVE);
        assert (typeID.getDimension() == 0);
        assert (object != null);
        assert (primitiveDescriptor.isValidInstance(object));
        PropertyValue propertyValue = new PropertyValue(Kind.VALUE);
        propertyValue.descriptor = primitiveDescriptor;
        propertyValue.type = typeID;
        propertyValue.value = object;
        return propertyValue;
    }

    public static PropertyValue createValue(String string, TypeID typeID, Object object) {
        if (typeID.getKind() == TypeID.Kind.ENUM) {
            return PropertyValue.createEnumValue(EnumDescriptorFactoryRegistry.getDescriptor(string, typeID), typeID, object);
        }
        return PropertyValue.createValue(PrimitiveDescriptorFactoryRegistry.getDescriptor(string, typeID), typeID, object);
    }

    public static PropertyValue createEnumValue(EnumDescriptor enumDescriptor, TypeID typeID, Object object) {
        assert (enumDescriptor != null);
        assert (typeID != null);
        assert (typeID.getKind() == TypeID.Kind.ENUM);
        assert (typeID.getDimension() == 0);
        assert (object != null);
        assert (enumDescriptor.isValidInstance(object));
        PropertyValue propertyValue = new PropertyValue(Kind.ENUM);
        assert (enumDescriptor.values().contains(object));
        propertyValue.descriptor = enumDescriptor;
        propertyValue.type = typeID;
        propertyValue.value = object;
        return propertyValue;
    }

    public static PropertyValue createArray(TypeID typeID, List<PropertyValue> list) {
        assert (typeID != null);
        assert (list != null);
        assert (PropertyValue.createArrayAssert(list, typeID));
        PropertyValue propertyValue = new PropertyValue(Kind.ARRAY);
        propertyValue.type = typeID.getArrayType();
        propertyValue.array = Collections.unmodifiableList(new ArrayList<PropertyValue>(list));
        return propertyValue;
    }

    private static boolean createArrayAssert(List<PropertyValue> list, TypeID typeID) {
        for (PropertyValue propertyValue : list) {
            assert (propertyValue != null);
            assert (propertyValue.isCompatible(typeID));
        }
        return true;
    }

    public static PropertyValue createEmptyArray(TypeID typeID) {
        return PropertyValue.createArray(typeID, EMPTY_ARRAY);
    }

    private PropertyValue(Kind kind) {
        this.kind = kind;
    }

    public Kind getKind() {
        return this.kind;
    }

    public TypeID getType() {
        return this.type;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public DesignComponent getComponent() {
        return this.component;
    }

    public Object getPrimitiveValue() {
        return this.value;
    }

    public List<PropertyValue> getArray() {
        return this.array;
    }

    void collectAllComponentReferences(Collection<DesignComponent> collection) {
        assert (Debug.isFriend(DesignComponent.class, "writeProperty") || Debug.isFriend(DesignComponent.class, "setComponentDescriptor") || Debug.isFriend(PropertyValue.class, "collectAllComponentReferences") || Debug.isFriend(Debug.class, "collectAllComponentReferences"));
        switch (this.kind) {
            case USERCODE: 
            case NULL: 
            case VALUE: 
            case ENUM: {
                return;
            }
            case REFERENCE: {
                collection.add(this.component);
                return;
            }
            case ARRAY: {
                if (this.type.getKind() == TypeID.Kind.COMPONENT) {
                    for (PropertyValue propertyValue : this.array) {
                        propertyValue.collectAllComponentReferences(collection);
                    }
                }
                return;
            }
        }
        Debug.error("Invalid state", this);
    }

    public boolean isCompatible(TypeID typeID) {
        if (this.type == null) {
            return true;
        }
        if (this.kind == Kind.REFERENCE) {
            return this.component.getDocument().getDescriptorRegistry().isInHierarchy(typeID, this.component.getType());
        }
        return this.type.equals(typeID);
    }

    public boolean isCompatible(PropertyDescriptor propertyDescriptor) {
        PropertyValue propertyValue;
        if (propertyDescriptor == null) {
            return false;
        }
        if (this.kind == Kind.NULL ? !propertyDescriptor.isAllowNull() && ((propertyValue = propertyDescriptor.getDefaultValue()) == null || propertyValue.getKind() != Kind.NULL) : this.kind == Kind.USERCODE && !propertyDescriptor.isAllowUserCode()) {
            return false;
        }
        return this.isCompatible(propertyDescriptor.getType());
    }

    public String serialize() {
        switch (this.kind) {
            case USERCODE: {
                return 'U' + this.userCode;
            }
            case NULL: {
                return Character.toString('N');
            }
            case REFERENCE: {
                return "" + 'R' + this.component.getComponentID();
            }
            case VALUE: {
                return 'V' + this.descriptor.serialize(this.value);
            }
            case ENUM: {
                return 'E' + this.descriptor.serialize(this.value);
            }
            case ARRAY: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('A').append(this.array.size()).append(':');
                for (PropertyValue propertyValue : this.array) {
                    String string = propertyValue.serialize();
                    stringBuilder.append(string.length()).append('_').append(string);
                }
                return stringBuilder.toString();
            }
        }
        throw Debug.error("Cannot serialize property value", this.type);
    }

    public static PropertyValue deserialize(String string, DesignDocument designDocument, TypeID typeID) throws Exception {
        assert (string != null && string.length() >= 1);
        assert (designDocument != null && typeID != null);
        switch (string.charAt(0)) {
            case 'U': {
                if (string.substring(1) == null) {
                    throw new IllegalArgumentException();
                }
                return PropertyValue.createUserCode(string.substring(1));
            }
            case 'N': {
                return PropertyValue.createNull();
            }
            case 'R': {
                int n = Integer.parseInt(string.substring(1));
                if (designDocument.getComponentByUID(n) == null) {
                    throw new IllegalArgumentException("No component for given serilezed value");
                }
                return PropertyValue.createComponentReference(designDocument.getComponentByUID(n));
            }
            case 'V': {
                PrimitiveDescriptor primitiveDescriptor = PrimitiveDescriptorFactoryRegistry.getDescriptor(designDocument.getDocumentInterface().getProjectType(), typeID);
                if (primitiveDescriptor == null) {
                    throw new IllegalArgumentException();
                }
                return PropertyValue.createValue(primitiveDescriptor, typeID, primitiveDescriptor.deserialize(string.substring(1)));
            }
            case 'E': {
                EnumDescriptor enumDescriptor = EnumDescriptorFactoryRegistry.getDescriptor(designDocument.getDocumentInterface().getProjectType(), typeID);
                if (enumDescriptor == null) {
                    throw new IllegalArgumentException();
                }
                return PropertyValue.createEnumValue(enumDescriptor, typeID, enumDescriptor.deserialize(string.substring(1)));
            }
            case 'A': {
                int n = 1;
                int n2 = string.indexOf(58, n);
                assert (n2 > n);
                int n3 = Integer.parseInt(string.substring(n, n2));
                assert (n3 >= 0);
                n = n2 + 1;
                TypeID typeID2 = typeID.getComponentType();
                ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
                for (int i = 0; i < n3; ++i) {
                    int n4 = string.indexOf(95, n);
                    assert (n4 > n);
                    int n5 = Integer.parseInt(string.substring(n, n4));
                    assert (n5 >= 0);
                    n = n4 + 1;
                    arrayList.add(PropertyValue.deserialize(string.substring(n, n + n5), designDocument, typeID2));
                    n += n5;
                }
                return PropertyValue.createArray(typeID2, arrayList);
            }
        }
        Debug.warning("Cannot deserialize property value", typeID, string);
        throw new IllegalArgumentException("Cannot deserialize property value " + typeID + " " + string);
    }

    public String toString() {
        return this.serialize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        USERCODE,
        NULL,
        REFERENCE,
        VALUE,
        ENUM,
        ARRAY;

    }
}

