/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.tasklist.filter.TaskFilter;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.modules.tasklist.impl.Loader;
import org.netbeans.modules.tasklist.impl.ScannerList;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.trampoline.TaskManager;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskManagerImpl
extends TaskManager {
    public static final String PROP_SCOPE = "taskScanningScope";
    public static final String PROP_FILTER = "filter";
    public static final String PROP_WORKING_STATUS = "workingStatus";
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport((Object)this);
    private TaskList taskList = new TaskList();
    private TaskScanningScope scope = Accessor.getEmptyScope();
    private TaskFilter filter = TaskFilter.EMPTY;
    private static TaskManagerImpl theInstance;
    private final Set<PushTaskScanner> workingScanners = new HashSet<PushTaskScanner>(10);
    private boolean isLoadingFromCache = false;
    private boolean workingStatus = false;
    private Loader loader;

    public static TaskManagerImpl getInstance() {
        if (null == theInstance) {
            theInstance = new TaskManagerImpl();
        }
        return theInstance;
    }

    public void observe(final TaskScanningScope taskScanningScope, final TaskFilter taskFilter) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                TaskManagerImpl.this.doObserve(taskScanningScope, taskFilter);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doObserve(TaskScanningScope taskScanningScope, TaskFilter taskFilter) {
        TaskScanningScope taskScanningScope2 = this.scope;
        TaskFilter taskFilter2 = this.filter;
        TaskManagerImpl taskManagerImpl = this;
        synchronized (taskManagerImpl) {
            if (null == taskScanningScope || Accessor.getEmptyScope().equals(taskScanningScope)) {
                this.scope.attach(null);
                this.stopLoading();
                this.workingScanners.clear();
                this.isLoadingFromCache = false;
                for (PushTaskScanner pushTaskScanner : ScannerList.getPushScannerList().getScanners()) {
                    pushTaskScanner.setScope(null, null);
                }
                for (FileTaskScanner fileTaskScanner : ScannerList.getFileScannerList().getScanners()) {
                    fileTaskScanner.attach(null);
                }
                this.scope = Accessor.getEmptyScope();
                this.filter = TaskFilter.EMPTY;
                this.taskList.clear();
                this.setWorkingStatus(false);
            } else {
                boolean bl = NbPreferences.forModule(TaskManagerImpl.class).getBoolean("dirtyCache", false);
                NbPreferences.forModule(TaskManagerImpl.class).putBoolean("dirtyCache", false);
                if (null == taskFilter) {
                    taskFilter = TaskFilter.EMPTY;
                }
                if (!this.scope.equals(taskScanningScope) || !this.filter.equals(taskFilter)) {
                    this.taskList.clear();
                    if (!taskScanningScope.equals(this.scope)) {
                        this.scope.attach(null);
                        taskScanningScope.attach(Accessor.createCallback((TaskManager)this, taskScanningScope));
                    }
                    this.workingScanners.clear();
                    this.isLoadingFromCache = false;
                    this.setWorkingStatus(false);
                    boolean bl2 = this.compareScanners(this.filter, taskFilter);
                    this.scope = taskScanningScope;
                    this.filter = taskFilter;
                    this.attachFileScanners(taskFilter);
                    this.attachPushScanners(taskScanningScope, taskFilter);
                    if (bl2 || bl) {
                        this.clearCache();
                    } else {
                        this.startLoading();
                    }
                }
            }
        }
        this.propertySupport.firePropertyChange(PROP_SCOPE, taskScanningScope2, taskScanningScope);
        this.propertySupport.firePropertyChange(PROP_FILTER, taskFilter2, taskFilter);
    }

    private boolean compareScanners(TaskFilter taskFilter, TaskFilter taskFilter2) {
        if (null == taskFilter || taskFilter == TaskFilter.EMPTY) {
            return false;
        }
        List<FileTaskScanner> list = ScannerList.getFileScanners(taskFilter);
        List<FileTaskScanner> list2 = ScannerList.getFileScanners(taskFilter2);
        if (list.size() > 0 && list.size() != list2.size()) {
            return true;
        }
        for (FileTaskScanner fileTaskScanner : list) {
            if (list2.contains(fileTaskScanner)) continue;
            return true;
        }
        return false;
    }

    private void attachFileScanners(TaskFilter taskFilter) {
        for (FileTaskScanner fileTaskScanner : this.getFileScanners()) {
            if (!taskFilter.isEnabled(fileTaskScanner)) {
                fileTaskScanner.attach(null);
                continue;
            }
            if (!taskFilter.isEnabled(fileTaskScanner)) continue;
            fileTaskScanner.attach(Accessor.createCallback((TaskManager)this, fileTaskScanner));
        }
    }

    private void attachPushScanners(TaskScanningScope taskScanningScope, TaskFilter taskFilter) {
        for (PushTaskScanner pushTaskScanner : this.getPushScanners()) {
            if (!taskFilter.isEnabled(pushTaskScanner)) {
                pushTaskScanner.setScope(null, null);
                continue;
            }
            if (!taskFilter.isEnabled(pushTaskScanner)) continue;
            pushTaskScanner.setScope(taskScanningScope, Accessor.createCallback((TaskManager)this, pushTaskScanner));
        }
    }

    Iterable<? extends FileTaskScanner> getFileScanners() {
        return ScannerList.getFileScannerList().getScanners();
    }

    Iterable<? extends PushTaskScanner> getPushScanners() {
        return ScannerList.getPushScannerList().getScanners();
    }

    public void abort() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                TaskManagerImpl.this.doAbort();
            }
        });
    }

    private void doAbort() {
        this.stopLoading();
        for (PushTaskScanner pushTaskScanner : ScannerList.getPushScannerList().getScanners()) {
            pushTaskScanner.setScope(null, null);
        }
        this.workingScanners.clear();
        this.setWorkingStatus(false);
    }

    boolean isObserved() {
        return !Accessor.getEmptyScope().equals(this.getScope());
    }

    public TaskScanningScope getScope() {
        return this.scope;
    }

    public TaskList getTasks() {
        return this.taskList;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    private void startLoading() {
        if (null != this.loader) {
            this.loader.cancel();
        }
        this.loader = new Loader(this.scope, this.filter, this.taskList);
        RequestProcessor.getDefault().post((Runnable)this.loader);
    }

    private void stopLoading() {
        if (null != this.loader) {
            this.loader.cancel();
        }
        this.loader = null;
        this.isLoadingFromCache = false;
        this.setWorkingStatus(this.isWorking());
    }

    public TaskFilter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(FileTaskScanner fileTaskScanner, FileObject ... fileObjectArray) {
        try {
            Object object = this;
            synchronized (object) {
                this.taskList.clear(fileTaskScanner, fileObjectArray);
            }
            object = new ArrayList(1);
            for (FileObject fileObject : fileObjectArray) {
                ((ArrayList)object).clear();
                ((ArrayList)object).add(fileObject.getURL());
                Collection collection = QuerySupport.findRoots((FileObject)fileObject, null, null, null);
                for (FileObject fileObject2 : collection) {
                    IndexingManager.getDefault().refreshIndex(fileObject2.getURL(), (Collection)object);
                }
            }
        }
        catch (IOException iOException) {
            this.getLogger().log(Level.INFO, "Error while refreshing files.", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(FileTaskScanner fileTaskScanner) {
        TaskManagerImpl taskManagerImpl = this;
        synchronized (taskManagerImpl) {
            this.taskList.clear(fileTaskScanner);
            this.clearCache();
        }
    }

    public void clearCache() {
        IndexingManager.getDefault().refreshAllIndices("TaskListIndexer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void makeCacheDirty() {
        TaskManagerImpl taskManagerImpl = this;
        synchronized (taskManagerImpl) {
            NbPreferences.forModule(TaskManagerImpl.class).putBoolean("dirtyCache", true);
        }
    }

    public void refresh(final TaskScanningScope taskScanningScope) {
        if (this.scope.equals(taskScanningScope)) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    TaskManagerImpl.this.doRefresh(taskScanningScope);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefresh(TaskScanningScope taskScanningScope) {
        TaskManagerImpl taskManagerImpl = this;
        synchronized (taskManagerImpl) {
            if (this.scope.equals(taskScanningScope)) {
                this.taskList.clear();
                if (this.isObserved()) {
                    for (PushTaskScanner pushTaskScanner : ScannerList.getPushScannerList().getScanners()) {
                        pushTaskScanner.setScope(null, null);
                        if (!this.getFilter().isEnabled(pushTaskScanner)) continue;
                        pushTaskScanner.setScope(taskScanningScope, Accessor.createCallback((TaskManager)this, pushTaskScanner));
                    }
                    this.startLoading();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void started(PushTaskScanner pushTaskScanner) {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            this.workingScanners.add(pushTaskScanner);
            this.setWorkingStatus(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(PushTaskScanner pushTaskScanner) {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            this.workingScanners.remove(pushTaskScanner);
            this.setWorkingStatus(this.isWorking());
        }
    }

    public void setTasks(PushTaskScanner pushTaskScanner, FileObject fileObject, List<? extends Task> list) {
        if (this.isObserved() && this.scope.isInScope(fileObject)) {
            try {
                this.taskList.setTasks(pushTaskScanner, fileObject, list, this.filter);
            }
            catch (IOException iOException) {
                this.getLogger().log(Level.INFO, "Error while updating tasks from " + Accessor.getDisplayName(pushTaskScanner), iOException);
            }
        }
    }

    public void setTasks(PushTaskScanner pushTaskScanner, List<? extends Task> list) {
        if (this.isObserved()) {
            try {
                this.taskList.setTasks(pushTaskScanner, null, list, this.filter);
            }
            catch (IOException iOException) {
                this.getLogger().log(Level.INFO, "Error while updating tasks from " + Accessor.getDisplayName(pushTaskScanner), iOException);
            }
        }
    }

    public void clearAllTasks(PushTaskScanner pushTaskScanner) {
        this.taskList.clear(pushTaskScanner);
    }

    private Logger getLogger() {
        return Logger.getLogger(TaskManagerImpl.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWorking() {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            return !this.workingScanners.isEmpty() || this.isLoadingFromCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLoadingStatus(Loader loader, boolean bl) {
        TaskManagerImpl taskManagerImpl = this;
        synchronized (taskManagerImpl) {
            if (this.loader != loader) {
                return;
            }
            this.isLoadingFromCache = bl;
        }
        this.setWorkingStatus(this.isWorking());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWorkingStatus(boolean bl) {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            if (bl != this.workingStatus) {
                boolean bl2 = this.workingStatus;
                this.workingStatus = bl;
                Logger.getLogger("org.netbeans.log.startup").log(Level.FINE, bl ? "start" : "end", TaskManagerImpl.class.getName());
                this.propertySupport.firePropertyChange(PROP_WORKING_STATUS, bl2, bl);
                if (!this.workingStatus) {
                    this.workingScanners.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitFinished() {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            if (!this.isWorking()) {
                return;
            }
            this._waitFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _waitFinished() {
        Set<PushTaskScanner> set = this.workingScanners;
        synchronized (set) {
            try {
                this.workingScanners.wait();
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
        }
    }
}

