/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.tasklist.filter.TaskFilter;
import org.netbeans.modules.tasklist.impl.ScannerDescriptor;
import org.netbeans.modules.tasklist.impl.ScannerList;
import org.netbeans.modules.tasklist.impl.TaskIndexer;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.impl.TaskManagerImpl;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;

public class Loader
implements Runnable,
Cancellable {
    private boolean cancelled = false;
    private final TaskScanningScope scope;
    private final TaskFilter filter;
    private final TaskList taskList;

    public Loader(TaskScanningScope taskScanningScope, TaskFilter taskFilter, TaskList taskList) {
        this.scope = taskScanningScope;
        this.filter = taskFilter;
        this.taskList = taskList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TaskManagerImpl.getInstance().setLoadingStatus(this, true);
        try {
            Collection collection = this.scope.getLookup().lookupAll(Project.class);
            if (!collection.isEmpty()) {
                LinkedList linkedList = new LinkedList();
                for (Project project : collection) {
                    if (this.cancelled) {
                        return;
                    }
                    linkedList.addAll(QuerySupport.findRoots((Project)project, null, null, null));
                }
                this.loadTasks(linkedList.toArray(new FileObject[linkedList.size()]), null);
            } else {
                Iterator iterator = this.scope.iterator();
                while (iterator.hasNext() && !this.cancelled) {
                    FileObject fileObject = (FileObject)iterator.next();
                    ArrayList arrayList = new ArrayList(QuerySupport.findRoots((FileObject)fileObject, null, null, null));
                    this.loadTasks(arrayList.toArray(new FileObject[arrayList.size()]), fileObject);
                }
            }
        }
        finally {
            TaskManagerImpl.getInstance().setLoadingStatus(this, false);
        }
    }

    public boolean cancel() {
        this.cancelled = true;
        return true;
    }

    private void loadTasks(FileObject[] fileObjectArray, FileObject fileObject) {
        ArrayList<Task> arrayList = null;
        try {
            QuerySupport querySupport = QuerySupport.forRoots((String)"TaskListIndexer", (int)2, (FileObject[])fileObjectArray);
            for (FileTaskScanner fileTaskScanner : ScannerList.getFileScannerList().getScanners()) {
                if (this.cancelled) {
                    return;
                }
                if (!this.filter.isEnabled(fileTaskScanner)) continue;
                String string = ScannerDescriptor.getType(fileTaskScanner);
                Collection collection = querySupport.query("scanner", string, QuerySupport.Kind.EXACT, new String[]{"task"});
                for (IndexResult indexResult : collection) {
                    String[] stringArray;
                    if (this.cancelled) {
                        return;
                    }
                    FileObject fileObject2 = indexResult.getFile();
                    if (null == fileObject2 || null != fileObject && !fileObject.equals(indexResult.getFile())) continue;
                    if (null != arrayList) {
                        arrayList.clear();
                    }
                    for (String string2 : stringArray = indexResult.getValues("task")) {
                        if (this.cancelled) {
                            return;
                        }
                        Task task = TaskIndexer.decode(fileObject2, string2);
                        if (null == arrayList) {
                            arrayList = new ArrayList<Task>(1000);
                        }
                        arrayList.add(task);
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (null == arrayList || arrayList.isEmpty()) continue;
                    this.taskList.update(fileTaskScanner, fileObject2, (List<Task>)arrayList, this.filter);
                }
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(TaskIndexer.class.getName()).log(Level.INFO, "Error while loading tasks from cache", iOException);
        }
    }
}

