/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.syntax;

import java.lang.ref.WeakReference;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.openide.ErrorManager;

public abstract class SyntaxElement {
    protected XMLSyntaxSupport support;
    private WeakReference<TokenItem> first;
    private WeakReference<SyntaxElement> previous;
    private WeakReference<SyntaxElement> next;
    protected int offset;
    protected int length;

    public SyntaxElement(XMLSyntaxSupport xMLSyntaxSupport, TokenItem tokenItem, int n) {
        this.support = xMLSyntaxSupport;
        this.offset = tokenItem.getOffset();
        this.length = n - this.offset;
        this.first = new WeakReference<TokenItem>(tokenItem);
    }

    protected TokenItem first() {
        TokenItem tokenItem = (TokenItem)this.first.get();
        if (tokenItem == null) {
            try {
                TokenItem tokenItem2 = this.support.getTokenChain(this.offset, this.offset + 1);
                this.first = new WeakReference<TokenItem>(tokenItem2);
                return tokenItem2;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return tokenItem;
    }

    public int getElementOffset() {
        return this.offset;
    }

    public int getElementLength() {
        return this.length;
    }

    void setNext(SyntaxElement syntaxElement) {
        this.next = new WeakReference<SyntaxElement>(syntaxElement);
    }

    void setPrevious(SyntaxElement syntaxElement) {
        this.previous = new WeakReference<SyntaxElement>(syntaxElement);
    }

    public SyntaxElement getPrevious() {
        try {
            SyntaxElement syntaxElement;
            SyntaxElement syntaxElement2 = syntaxElement = this.previous == null ? null : (SyntaxElement)this.previous.get();
            if (syntaxElement == null) {
                if (this.offset == 0) {
                    return null;
                }
                SyntaxElement syntaxElement3 = this.support.getElementChain(this.getElementOffset() - 1);
                if (syntaxElement3 != null) {
                    this.setPrevious(syntaxElement3);
                    syntaxElement3.setNext(this);
                    if (syntaxElement3.offset == this.offset) {
                        IllegalStateException illegalStateException = new IllegalStateException("Previous cannot be the same as current element at offset " + this.offset);
                        ErrorManager.getDefault().notify(1, (Throwable)illegalStateException);
                        return null;
                    }
                }
                return syntaxElement3;
            }
            return syntaxElement;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public SyntaxElement getNext() {
        try {
            SyntaxElement syntaxElement;
            SyntaxElement syntaxElement2 = syntaxElement = this.next == null ? null : (SyntaxElement)this.next.get();
            if (syntaxElement == null) {
                SyntaxElement syntaxElement3 = this.support.getElementChain(this.offset + this.length + 1);
                if (syntaxElement3 != null) {
                    this.setNext(syntaxElement3);
                    syntaxElement3.setPrevious(this);
                    if (syntaxElement3.offset == this.offset) {
                        return null;
                    }
                }
                return syntaxElement3;
            }
            return syntaxElement;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public String toString() {
        String string = "?";
        try {
            string = this.support.getDocument().getText(this.offset, this.length);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return "SyntaxElement [offset=" + this.offset + "; length=" + this.length + " ;type = " + this.getClass().getName() + "; content:" + string + "]";
    }

    public int hashCode() {
        return super.hashCode() ^ this.offset ^ this.length;
    }

    public boolean equals(Object object) {
        return object instanceof SyntaxElement && ((SyntaxElement)object).offset == this.offset;
    }

    public static class Error
    extends SyntaxElement {
        public Error(XMLSyntaxSupport xMLSyntaxSupport, TokenItem tokenItem, int n) {
            super(xMLSyntaxSupport, tokenItem, n);
        }

        public String toString() {
            return "Error" + super.toString();
        }
    }
}

