/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.platform.platformdefinition;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private Util() {
    }

    public static ClassPath createClassPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            File file = FileUtil.normalizeFile((File)new File(string2));
            URL uRL = Util.getRootURL(file);
            if (uRL == null) continue;
            arrayList.add(ClassPathSupport.createResource((URL)uRL));
        }
        return ClassPathSupport.createClassPath(arrayList);
    }

    static URL getRootURL(File file) {
        URL uRL = null;
        try {
            if (Util.isArchiveFile(file)) {
                uRL = FileUtil.getArchiveRoot((URL)file.toURI().toURL());
            } else {
                uRL = file.toURI().toURL();
                String string = uRL.toExternalForm();
                if (!string.endsWith("/")) {
                    uRL = new URL(string + "/");
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)malformedURLException);
        }
        return uRL;
    }

    public static String normalizeName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '-' || c == '.') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append('_');
        }
        return stringBuffer.toString();
    }

    public static SpecificationVersion getSpecificationVersion(JavaPlatform javaPlatform) {
        String string = (String)javaPlatform.getSystemProperties().get("java.specification.version");
        if (string == null) {
            string = "1.1";
        }
        return Util.makeSpec(string);
    }

    public static FileObject findTool(String string, String string2, Collection<FileObject> collection) {
        assert (string2 != null);
        for (FileObject fileObject : collection) {
            FileObject fileObject2;
            FileObject fileObject3 = fileObject.getFileObject(string);
            if (fileObject3 == null) continue;
            String string3 = null;
            if (Utilities.isWindows()) {
                string3 = string2.indexOf(46) != -1 ? string3 : "exe";
                fileObject2 = fileObject3.getFileObject(string2, string3);
                if (fileObject2 != null) {
                    return fileObject2;
                }
                string3 = string2.indexOf(46) != -1 ? string3 : "bat";
                fileObject2 = fileObject3.getFileObject(string2, string3);
                if (fileObject2 == null) continue;
                return fileObject2;
            }
            string3 = string2.indexOf(46) != -1 ? string3 : null;
            fileObject2 = fileObject3.getFileObject(string2, string3);
            if (fileObject2 != null) {
                return fileObject2;
            }
            string3 = string2.indexOf(46) != -1 ? string3 : "sh";
            fileObject2 = fileObject3.getFileObject(string2, string3);
            if (fileObject2 == null) continue;
            return fileObject2;
        }
        return null;
    }

    public static String getExtensions(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            File file = FileUtil.normalizeFile((File)new File(stringTokenizer.nextToken()));
            File[] fileArray = file.listFiles();
            if (fileArray == null) continue;
            for (File file2 : fileArray) {
                if (!file2.exists()) {
                    ErrorManager.getDefault().log(16, MessageFormat.format(NbBundle.getMessage(Util.class, (String)"MSG_BrokenExtension"), file2, file));
                    continue;
                }
                FileObject fileObject = FileUtil.toFileObject((File)file2);
                assert (fileObject != null) : "Must have defined a FileObject for existent file " + file2;
                if (!FileUtil.isArchiveFile((FileObject)fileObject)) continue;
                stringBuffer.append(File.pathSeparator);
                stringBuffer.append(file2.getAbsolutePath());
            }
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.substring(File.pathSeparator.length());
    }

    private static SpecificationVersion makeSpec(String string) {
        if (string != null) {
            try {
                return new SpecificationVersion("1.2");
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("WARNING: invalid specification version: " + string);
                while (true) {
                    string = string.substring(0, string.length() - 1);
                    try {
                        return new SpecificationVersion(string);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        if (string.length() > 0) continue;
                    }
                    break;
                }
            }
        }
        return new SpecificationVersion("0");
    }

    private static boolean isArchiveFile(File file) {
        String string = file.getName().toLowerCase();
        return string.endsWith(".jar") || string.endsWith(".zip");
    }
}

